# Copyright (c) Facebook, Inc. and its affiliates.
# 
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

import numpy as np
import sys
import os
BASE_DIR = os.path.dirname(os.path.abspath(__file__))
sys.path.append(BASE_DIR)
ROOT_DIR = os.path.dirname(BASE_DIR)
sys.path.append(os.path.join(ROOT_DIR, 'utils'))

class lvisDatasetConfig(object):
    def __init__(self):
        self.num_class = 1204 #change this 
        self.num_heading_bin = 12
        self.num_size_cluster = 1204 #change this 
        #training sets
        self.type2class={'door':0,'aerosol_can': 1, 'air_conditioner': 2, 'airplane': 3, 'alarm_clock': 4, 'alcohol': 5, 'alligator': 6, 'almond': 7, 'ambulance': 8, 'amplifier': 9, 'anklet': 10, 'antenna': 11, 'apple': 12, 'applesauce': 13, 'apricot': 14, 'apron': 15, 'aquarium': 16, 'arctic_(type_of_shoe)': 17, 'armband': 18, 'armchair': 19, 'armoire': 20, 'armor': 21, 'artichoke': 22, 'trash_can': 23, 'ashtray': 24, 'asparagus': 25, 'atomizer': 26, 'avocado': 27, 'award': 28, 'awning': 29, 'ax': 30, 'baboon': 31, 'baby_buggy': 32, 'basketball_backboard': 33, 'backpack': 34, 'handbag': 35, 'suitcase': 36, 'bagel': 37, 'bagpipe': 38, 'baguet': 39, 'bait': 40, 'ball': 41, 'ballet_skirt': 42, 'balloon': 43, 'bamboo': 44, 'banana': 45, 'Band_Aid': 46, 'bandage': 47, 'bandanna': 48, 'banjo': 49, 'banner': 50, 'barbell': 51, 'barge': 52, 'barrel': 53, 'barrette': 54, 'barrow': 55, 'baseball_base': 56, 'baseball': 57, 'baseball_bat': 58, 'baseball_cap': 59, 'baseball_glove': 60, 'basket': 61, 'basketball': 62, 'bass_horn': 63, 'bat_(animal)': 64, 'bath_mat': 65, 'bath_towel': 66, 'bathrobe': 67, 'bathtub': 68, 'batter_(food)': 69, 'battery': 70, 'beachball': 71, 'bead': 72, 'bean_curd': 73, 'beanbag': 74, 'beanie': 75, 'bear': 76, 'bed': 77, 'bedpan': 78, 'bedspread': 79, 'cow': 80, 'beef_(food)': 81, 'beeper': 82, 'beer_bottle': 83, 'beer_can': 84, 'beetle': 85, 'bell': 86, 'bell_pepper': 87, 'belt': 88, 'belt_buckle': 89, 'bench': 90, 'beret': 91, 'bib': 92, 'Bible': 93, 'bicycle': 94, 'visor': 95, 'billboard': 96, 'binder': 97, 'binoculars': 98, 'bird': 99, 'birdfeeder': 100, 'birdbath': 101, 'birdcage': 102, 'birdhouse': 103, 'birthday_cake': 104, 'birthday_card': 105, 'pirate_flag': 106, 'black_sheep': 107, 'blackberry': 108, 'blackboard': 109, 'blanket': 110, 'blazer': 111, 'blender': 112, 'blimp': 113, 'blinker': 114, 'blouse': 115, 'blueberry': 116, 'gameboard': 117, 'boat': 118, 'bob': 119, 'bobbin': 120, 'bobby_pin': 121, 'boiled_egg': 122, 'bolo_tie': 123, 'deadbolt': 124, 'bolt': 125, 'bonnet': 126, 'book': 127, 'bookcase': 128, 'booklet': 129, 'bookmark': 130, 'boom_microphone': 131, 'boot': 132, 'bottle': 133, 'bottle_opener': 134, 'bouquet': 135, 'bow_(weapon)': 136, 'bow_(decorative_ribbons)': 137, 'bow-tie': 138, 'bowl': 139, 'pipe_bowl': 140, 'bowler_hat': 141, 'bowling_ball': 142, 'box': 143, 'boxing_glove': 144, 'suspenders': 145, 'bracelet': 146, 'brass_plaque': 147, 'brassiere': 148, 'bread-bin': 149, 'bread': 150, 'breechcloth': 151, 'bridal_gown': 152, 'briefcase': 153, 'broccoli': 154, 'broach': 155, 'broom': 156, 'brownie': 157, 'brussels_sprouts': 158, 'bubble_gum': 159, 'bucket': 160, 'horse_buggy': 161, 'bull': 162, 'bulldog': 163, 'bulldozer': 164, 'bullet_train': 165, 'bulletin_board': 166, 'bulletproof_vest': 167, 'bullhorn': 168, 'bun': 169, 'bunk_bed': 170, 'buoy': 171, 'burrito': 172, 'bus_(vehicle)': 173, 'business_card': 174, 'butter': 175, 'butterfly': 176, 'button': 177, 'cab_(taxi)': 178, 'cabana': 179, 'cabin_car': 180, 'cabinet': 181, 'locker': 182, 'cake': 183, 'calculator': 184, 'calendar': 185, 'calf': 186, 'camcorder': 187, 'camel': 188, 'camera': 189, 'camera_lens': 190, 'camper_(vehicle)': 191, 'can': 192, 'can_opener': 193, 'candle': 194, 'candle_holder': 195, 'candy_bar': 196, 'candy_cane': 197, 'walking_cane': 198, 'canister': 199, 'canoe': 200, 'cantaloup': 201, 'canteen': 202, 'cap_(headwear)': 203, 'bottle_cap': 204, 'cape': 205, 'cappuccino': 206, 'car_(automobile)': 207, 'railcar_(part_of_a_train)': 208, 'elevator_car': 209, 'car_battery': 210, 'identity_card': 211, 'card': 212, 'cardigan': 213, 'cargo_ship': 214, 'carnation': 215, 'horse_carriage': 216, 'carrot': 217, 'tote_bag': 218, 'cart': 219, 'carton': 220, 'cash_register': 221, 'casserole': 222, 'cassette': 223, 'cast': 224, 'cat': 225, 'cauliflower': 226, 'cayenne_(spice)': 227, 'CD_player': 228, 'celery': 229, 'cellular_telephone': 230, 'chain_mail': 231, 'chair': 232, 'chaise_longue': 233, 'chalice': 234, 'chandelier': 235, 'chap': 236, 'checkbook': 237, 'checkerboard': 238, 'cherry': 239, 'chessboard': 240, 'chicken_(animal)': 241, 'chickpea': 242, 'chili_(vegetable)': 243, 'chime': 244, 'chinaware': 245, 'crisp_(potato_chip)': 246, 'poker_chip': 247, 'chocolate_bar': 248, 'chocolate_cake': 249, 'chocolate_milk': 250, 'chocolate_mousse': 251, 'choker': 252, 'chopping_board': 253, 'chopstick': 254, 'Christmas_tree': 255, 'slide': 256, 'cider': 257, 'cigar_box': 258, 'cigarette': 259, 'cigarette_case': 260, 'cistern': 261, 'clarinet': 262, 'clasp': 263, 'cleansing_agent': 264, 'cleat_(for_securing_rope)': 265, 'clementine': 266, 'clip': 267, 'clipboard': 268, 'clippers_(for_plants)': 269, 'cloak': 270, 'clock': 271, 'clock_tower': 272, 'clothes_hamper': 273, 'clothespin': 274, 'clutch_bag': 275, 'coaster': 276, 'coat': 277, 'coat_hanger': 278, 'coatrack': 279, 'cock': 280, 'cockroach': 281, 'cocoa_(beverage)': 282, 'coconut': 283, 'coffee_maker': 284, 'coffee_table': 285, 'coffeepot': 286, 'coil': 287, 'coin': 288, 'colander': 289, 'coleslaw': 290, 'coloring_material': 291, 'combination_lock': 292, 'pacifier': 293, 'comic_book': 294, 'compass': 295, 'computer_keyboard': 296, 'condiment': 297, 'cone': 298, 'control': 299, 'convertible_(automobile)': 300, 'sofa_bed': 301, 'cooker': 302, 'cookie': 303, 'cooking_utensil': 304, 'cooler_(for_food)': 305, 'cork_(bottle_plug)': 306, 'corkboard': 307, 'corkscrew': 308, 'edible_corn': 309, 'cornbread': 310, 'cornet': 311, 'cornice': 312, 'cornmeal': 313, 'corset': 314, 'costume': 315, 'cougar': 316, 'coverall': 317, 'cowbell': 318, 'cowboy_hat': 319, 'crab_(animal)': 320, 'crabmeat': 321, 'cracker': 322, 'crape': 323, 'crate': 324, 'crayon': 325, 'cream_pitcher': 326, 'crescent_roll': 327, 'crib': 328, 'crock_pot': 329, 'crossbar': 330, 'crouton': 331, 'crow': 332, 'crowbar': 333, 'crown': 334, 'crucifix': 335, 'cruise_ship': 336, 'police_cruiser': 337, 'crumb': 338, 'crutch': 339, 'cub_(animal)': 340, 'cube': 341, 'cucumber': 342, 'cufflink': 343, 'cup': 344, 'trophy_cup': 345, 'cupboard': 346, 'cupcake': 347, 'hair_curler': 348, 'curling_iron': 349, 'curtain': 350, 'cushion': 351, 'cylinder': 352, 'cymbal': 353, 'dagger': 354, 'dalmatian': 355, 'dartboard': 356, 'date_(fruit)': 357, 'deck_chair': 358, 'deer': 359, 'dental_floss': 360, 'desk': 361, 'detergent': 362, 'diaper': 363, 'diary': 364, 'die': 365, 'dinghy': 366, 'dining_table': 367, 'tux': 368, 'dish': 369, 'dish_antenna': 370, 'dishrag': 371, 'dishtowel': 372, 'dishwasher': 373, 'dishwasher_detergent': 374, 'dispenser': 375, 'diving_board': 376, 'Dixie_cup': 377, 'dog': 378, 'dog_collar': 379, 'doll': 380, 'dollar': 381, 'dollhouse': 382, 'dolphin': 383, 'domestic_ass': 384, 'doorknob': 385, 'doormat': 386, 'doughnut': 387, 'dove': 388, 'dragonfly': 389, 'drawer': 390, 'underdrawers': 391, 'dress': 392, 'dress_hat': 393, 'dress_suit': 394, 'dresser': 395, 'drill': 396, 'drone': 397, 'dropper': 398, 'drum_(musical_instrument)': 399, 'drumstick': 400, 'duck': 401, 'duckling': 402, 'duct_tape': 403, 'duffel_bag': 404, 'dumbbell': 405, 'dumpster': 406, 'dustpan': 407, 'eagle': 408, 'earphone': 409, 'earplug': 410, 'earring': 411, 'easel': 412, 'eclair': 413, 'eel': 414, 'egg': 415, 'egg_roll': 416, 'egg_yolk': 417, 'eggbeater': 418, 'eggplant': 419, 'electric_chair': 420, 'refrigerator': 421, 'elephant': 422, 'elk': 423, 'envelope': 424, 'eraser': 425, 'escargot': 426, 'eyepatch': 427, 'falcon': 428, 'fan': 429, 'faucet': 430, 'fedora': 431, 'ferret': 432, 'Ferris_wheel': 433, 'ferry': 434, 'fig_(fruit)': 435, 'fighter_jet': 436, 'figurine': 437, 'file_cabinet': 438, 'file_(tool)': 439, 'fire_alarm': 440, 'fire_engine': 441, 'fire_extinguisher': 442, 'fire_hose': 443, 'fireplace': 444, 'fireplug': 445, 'first-aid_kit': 446, 'fish': 447, 'fish_(food)': 448, 'fishbowl': 449, 'fishing_rod': 450, 'flag': 451, 'flagpole': 452, 'flamingo': 453, 'flannel': 454, 'flap': 455, 'flash': 456, 'flashlight': 457, 'fleece': 458, 'flip-flop_(sandal)': 459, 'flipper_(footwear)': 460, 'flower_arrangement': 461, 'flute_glass': 462, 'foal': 463, 'folding_chair': 464, 'food_processor': 465, 'football_(American)': 466, 'football_helmet': 467, 'footstool': 468, 'fork': 469, 'forklift': 470, 'freight_car': 471, 'French_toast': 472, 'freshener': 473, 'frisbee': 474, 'frog': 475, 'fruit_juice': 476, 'frying_pan': 477, 'fudge': 478, 'funnel': 479, 'futon': 480, 'gag': 481, 'garbage': 482, 'garbage_truck': 483, 'garden_hose': 484, 'gargle': 485, 'gargoyle': 486, 'garlic': 487, 'gasmask': 488, 'gazelle': 489, 'gelatin': 490, 'gemstone': 491, 'generator': 492, 'giant_panda': 493, 'gift_wrap': 494, 'ginger': 495, 'giraffe': 496, 'cincture': 497, 'glass_(drink_container)': 498, 'globe': 499, 'glove': 500, 'goat': 501, 'goggles': 502, 'goldfish': 503, 'golf_club': 504, 'golfcart': 505, 'gondola_(boat)': 506, 'goose': 507, 'gorilla': 508, 'gourd': 509, 'grape': 510, 'grater': 511, 'gravestone': 512, 'gravy_boat': 513, 'green_bean': 514, 'green_onion': 515, 'griddle': 516, 'grill': 517, 'grits': 518, 'grizzly': 519, 'grocery_bag': 520, 'guitar': 521, 'gull': 522, 'gun': 523, 'hairbrush': 524, 'hairnet': 525, 'hairpin': 526, 'halter_top': 527, 'ham': 528, 'hamburger': 529, 'hammer': 530, 'hammock': 531, 'hamper': 532, 'hamster': 533, 'hair_dryer': 534, 'hand_glass': 535, 'hand_towel': 536, 'handcart': 537, 'handcuff': 538, 'handkerchief': 539, 'handle': 540, 'handsaw': 541, 'hardback_book': 542, 'harmonium': 543, 'hat': 544, 'hatbox': 545, 'veil': 546, 'headband': 547, 'headboard': 548, 'headlight': 549, 'headscarf': 550, 'headset': 551, 'headstall_(for_horses)': 552, 'heart': 553, 'heater': 554, 'helicopter': 555, 'helmet': 556, 'heron': 557, 'highchair': 558, 'hinge': 559, 'hippopotamus': 560, 'hockey_stick': 561, 'hog': 562, 'home_plate_(baseball)': 563, 'honey': 564, 'fume_hood': 565, 'hook': 566, 'hookah': 567, 'hornet': 568, 'horse': 569, 'hose': 570, 'hot-air_balloon': 571, 'hotplate': 572, 'hot_sauce': 573, 'hourglass': 574, 'houseboat': 575, 'hummingbird': 576, 'hummus': 577, 'polar_bear': 578, 'icecream': 579, 'popsicle': 580, 'ice_maker': 581, 'ice_pack': 582, 'ice_skate': 583, 'igniter': 584, 'inhaler': 585, 'iPod': 586, 'iron_(for_clothing)': 587, 'ironing_board': 588, 'jacket': 589, 'jam': 590, 'jar': 591, 'jean': 592, 'jeep': 593, 'jelly_bean': 594, 'jersey': 595, 'jet_plane': 596, 'jewel': 597, 'jewelry': 598, 'joystick': 599, 'jumpsuit': 600, 'kayak': 601, 'keg': 602, 'kennel': 603, 'kettle': 604, 'key': 605, 'keycard': 606, 'kilt': 607, 'kimono': 608, 'kitchen_sink': 609, 'kitchen_table': 610, 'kite': 611, 'kitten': 612, 'kiwi_fruit': 613, 'knee_pad': 614, 'knife': 615, 'knitting_needle': 616, 'knob': 617, 'knocker_(on_a_door)': 618, 'koala': 619, 'lab_coat': 620, 'ladder': 621, 'ladle': 622, 'ladybug': 623, 'lamb_(animal)': 624, 'lamb-chop': 625, 'lamp': 626, 'lamppost': 627, 'lampshade': 628, 'lantern': 629, 'lanyard': 630, 'laptop_computer': 631, 'lasagna': 632, 'latch': 633, 'lawn_mower': 634, 'leather': 635, 'legging_(clothing)': 636, 'Lego': 637, 'legume': 638, 'lemon': 639, 'lemonade': 640, 'lettuce': 641, 'license_plate': 642, 'life_buoy': 643, 'life_jacket': 644, 'lightbulb': 645, 'lightning_rod': 646, 'lime': 647, 'limousine': 648, 'lion': 649, 'lip_balm': 650, 'liquor': 651, 'lizard': 652, 'log': 653, 'lollipop': 654, 'speaker_(stero_equipment)': 655, 'loveseat': 656, 'machine_gun': 657, 'magazine': 658, 'magnet': 659, 'mail_slot': 660, 'mailbox_(at_home)': 661, 'mallard': 662, 'mallet': 663, 'mammoth': 664, 'manatee': 665, 'mandarin_orange': 666, 'manger': 667, 'manhole': 668, 'map': 669, 'marker': 670, 'martini': 671, 'mascot': 672, 'mashed_potato': 673, 'masher': 674, 'mask': 675, 'mast': 676, 'mat_(gym_equipment)': 677, 'matchbox': 678, 'mattress': 679, 'measuring_cup': 680, 'measuring_stick': 681, 'meatball': 682, 'medicine': 683, 'melon': 684, 'microphone': 685, 'microscope': 686, 'microwave_oven': 687, 'milestone': 688, 'milk': 689, 'milk_can': 690, 'milkshake': 691, 'minivan': 692, 'mint_candy': 693, 'mirror': 694, 'mitten': 695, 'mixer_(kitchen_tool)': 696, 'money': 697, 'monitor_(computer_equipment)_computer_monitor': 698, 'monkey': 699, 'motor': 700, 'motor_scooter': 701, 'motor_vehicle': 702, 'motorcycle': 703, 'mound_(baseball)': 704, 'mouse_(computer_equipment)': 705, 'mousepad': 706, 'muffin': 707, 'mug': 708, 'mushroom': 709, 'music_stool': 710, 'musical_instrument': 711, 'nailfile': 712, 'napkin': 713, 'neckerchief': 714, 'necklace': 715, 'necktie': 716, 'needle': 717, 'nest': 718, 'newspaper': 719, 'newsstand': 720, 'nightshirt': 721, 'nosebag_(for_animals)': 722, 'noseband_(for_animals)': 723, 'notebook': 724, 'notepad': 725, 'nut': 726, 'nutcracker': 727, 'oar': 728, 'octopus_(food)': 729, 'octopus_(animal)': 730, 'oil_lamp': 731, 'olive_oil': 732, 'omelet': 733, 'onion': 734, 'orange_(fruit)': 735, 'orange_juice': 736, 'ostrich': 737, 'ottoman': 738, 'oven': 739, 'overalls_(clothing)': 740, 'owl': 741, 'packet': 742, 'inkpad': 743, 'pad': 744, 'paddle': 745, 'padlock': 746, 'paintbrush': 747, 'painting': 748, 'pajamas': 749, 'palette': 750, 'pan_(for_cooking)': 751, 'pan_(metal_container)': 752, 'pancake': 753, 'pantyhose': 754, 'papaya': 755, 'paper_plate': 756, 'paper_towel': 757, 'paperback_book': 758, 'paperweight': 759, 'parachute': 760, 'parakeet': 761, 'parasail_(sports)': 762, 'parasol': 763, 'parchment': 764, 'parka': 765, 'parking_meter': 766, 'parrot': 767, 'passenger_car_(part_of_a_train)': 768, 'passenger_ship': 769, 'passport': 770, 'pastry': 771, 'patty_(food)': 772, 'pea_(food)': 773, 'peach': 774, 'peanut_butter': 775, 'pear': 776, 'peeler_(tool_for_fruit_and_vegetables)': 777, 'wooden_leg': 778, 'pegboard': 779, 'pelican': 780, 'pen': 781, 'pencil': 782, 'pencil_box': 783, 'pencil_sharpener': 784, 'pendulum': 785, 'penguin': 786, 'pennant': 787, 'penny_(coin)': 788, 'pepper': 789, 'pepper_mill': 790, 'perfume': 791, 'persimmon': 792, 'person': 793, 'pet': 794, 'pew_(church_bench)': 795, 'phonebook': 796, 'phonograph_record': 797, 'piano': 798, 'pickle': 799, 'pickup_truck': 800, 'pie': 801, 'pigeon': 802, 'piggy_bank': 803, 'pillow': 804, 'pin_(non_jewelry)': 805, 'pineapple': 806, 'pinecone': 807, 'ping-pong_ball': 808, 'pinwheel': 809, 'tobacco_pipe': 810, 'pipe': 811, 'pistol': 812, 'pita_(bread)': 813, 'pitcher_(vessel_for_liquid)': 814, 'pitchfork': 815, 'pizza': 816, 'place_mat': 817, 'plate': 818, 'platter': 819, 'playpen': 820, 'pliers': 821, 'plow_(farm_equipment)': 822, 'plume': 823, 'pocket_watch': 824, 'pocketknife': 825, 'poker_(fire_stirring_tool)': 826, 'pole': 827, 'polo_shirt': 828, 'poncho': 829, 'pony': 830, 'pool_table': 831, 'pop_(soda)': 832, 'postbox_(public)': 833, 'postcard': 834, 'poster': 835, 'pot': 836, 'flowerpot': 837, 'potato': 838, 'potholder': 839, 'pottery': 840, 'pouch': 841, 'power_shovel': 842, 'prawn': 843, 'pretzel': 844, 'printer': 845, 'projectile_(weapon)': 846, 'projector': 847, 'propeller': 848, 'prune': 849, 'pudding': 850, 'puffer_(fish)': 851, 'puffin': 852, 'pug-dog': 853, 'pumpkin': 854, 'puncher': 855, 'puppet': 856, 'puppy': 857, 'quesadilla': 858, 'quiche': 859, 'quilt': 860, 'rabbit': 861, 'race_car': 862, 'racket': 863, 'radar': 864, 'radiator': 865, 'radio_receiver': 866, 'radish': 867, 'raft': 868, 'rag_doll': 869, 'raincoat': 870, 'ram_(animal)': 871, 'raspberry': 872, 'rat': 873, 'razorblade': 874, 'reamer_(juicer)': 875, 'rearview_mirror': 876, 'receipt': 877, 'recliner': 878, 'record_player': 879, 'reflector': 880, 'remote_control': 881, 'rhinoceros': 882, 'rib_(food)': 883, 'rifle': 884, 'ring': 885, 'river_boat': 886, 'road_map': 887, 'robe': 888, 'rocking_chair': 889, 'rodent': 890, 'roller_skate': 891, 'Rollerblade': 892, 'rolling_pin': 893, 'root_beer': 894, 'router_(computer_equipment)': 895, 'rubber_band': 896, 'runner_(carpet)': 897, 'plastic_bag': 898, 'saddle_(on_an_animal)': 899, 'saddle_blanket': 900, 'saddlebag': 901, 'safety_pin': 902, 'sail': 903, 'salad': 904, 'salad_plate': 905, 'salami': 906, 'salmon_(fish)': 907, 'salmon_(food)': 908, 'salsa': 909, 'saltshaker': 910, 'sandal_(type_of_shoe)': 911, 'sandwich': 912, 'satchel': 913, 'saucepan': 914, 'saucer': 915, 'sausage': 916, 'sawhorse': 917, 'saxophone': 918, 'scale_(measuring_instrument)': 919, 'scarecrow': 920, 'scarf': 921, 'school_bus': 922, 'scissors': 923, 'scoreboard': 924, 'scraper': 925, 'screwdriver': 926, 'scrubbing_brush': 927, 'sculpture': 928, 'seabird': 929, 'seahorse': 930, 'seaplane': 931, 'seashell': 932, 'sewing_machine': 933, 'shaker': 934, 'shampoo': 935, 'shark': 936, 'sharpener': 937, 'Sharpie': 938, 'shaver_(electric)': 939, 'shaving_cream': 940, 'shawl': 941, 'shears': 942, 'sheep': 943, 'shepherd_dog': 944, 'sherbert': 945, 'shield': 946, 'shirt': 947, 'shoe': 948, 'shopping_bag': 949, 'shopping_cart': 950, 'short_pants': 951, 'shot_glass': 952, 'shoulder_bag': 953, 'shovel': 954, 'shower_head': 955, 'shower_cap': 956, 'shower_curtain': 957, 'shredder_(for_paper)': 958, 'signboard': 959, 'silo': 960, 'sink': 961, 'skateboard': 962, 'skewer': 963, 'ski': 964, 'ski_boot': 965, 'ski_parka': 966, 'ski_pole': 967, 'skirt': 968, 'skullcap': 969, 'sled': 970, 'sleeping_bag': 971, 'sling_(bandage)': 972, 'slipper_(footwear)': 973, 'smoothie': 974, 'snake': 975, 'snowboard': 976, 'snowman': 977, 'snowmobile': 978, 'soap': 979, 'soccer_ball': 980, 'sock': 981, 'sofa': 982, 'softball': 983, 'solar_array': 984, 'sombrero': 985, 'soup': 986, 'soup_bowl': 987, 'soupspoon': 988, 'sour_cream': 989, 'soya_milk': 990, 'space_shuttle': 991, 'sparkler_(fireworks)': 992, 'spatula': 993, 'spear': 994, 'spectacles': 995, 'spice_rack': 996, 'spider': 997, 'crawfish': 998, 'sponge': 999, 'spoon': 1000, 'sportswear': 1001, 'spotlight': 1002, 'squid_(food)': 1003, 'squirrel': 1004, 'stagecoach': 1005, 'stapler_(stapling_machine)': 1006, 'starfish': 1007, 'statue_(sculpture)': 1008, 'steak_(food)': 1009, 'steak_knife': 1010, 'steering_wheel': 1011, 'stepladder': 1012, 'step_stool': 1013, 'stereo_(sound_system)': 1014, 'stew': 1015, 'stirrer': 1016, 'stirrup': 1017, 'stool': 1018, 'stop_sign': 1019, 'brake_light': 1020, 'stove': 1021, 'strainer': 1022, 'strap': 1023, 'straw_(for_drinking)': 1024, 'strawberry': 1025, 'street_sign': 1026, 'streetlight': 1027, 'string_cheese': 1028, 'stylus': 1029, 'subwoofer': 1030, 'sugar_bowl': 1031, 'sugarcane_(plant)': 1032, 'suit_(clothing)': 1033, 'sunflower': 1034, 'sunglasses': 1035, 'sunhat': 1036, 'surfboard': 1037, 'sushi': 1038, 'mop': 1039, 'sweat_pants': 1040, 'sweatband': 1041, 'sweater': 1042, 'sweatshirt': 1043, 'sweet_potato': 1044, 'swimsuit': 1045, 'sword': 1046, 'syringe': 1047, 'Tabasco_sauce': 1048, 'table-tennis_table': 1049, 'table': 1050, 'table_lamp': 1051, 'tablecloth': 1052, 'tachometer': 1053, 'taco': 1054, 'tag': 1055, 'taillight': 1056, 'tambourine': 1057, 'army_tank': 1058, 'tank_(storage_vessel)': 1059, 'tank_top_(clothing)': 1060, 'tape_(sticky_cloth_or_paper)': 1061, 'tape_measure': 1062, 'tapestry': 1063, 'tarp': 1064, 'tartan': 1065, 'tassel': 1066, 'tea_bag': 1067, 'teacup': 1068, 'teakettle': 1069, 'teapot': 1070, 'teddy_bear': 1071, 'telephone': 1072, 'telephone_booth': 1073, 'telephone_pole': 1074, 'telephoto_lens': 1075, 'television_camera': 1076, 'television_set': 1077, 'tennis_ball': 1078, 'tennis_racket': 1079, 'tequila': 1080, 'thermometer': 1081, 'thermos_bottle': 1082, 'thermostat': 1083, 'thimble': 1084, 'thread': 1085, 'thumbtack': 1086, 'tiara': 1087, 'tiger': 1088, 'tights_(clothing)': 1089, 'timer': 1090, 'tinfoil': 1091, 'tinsel': 1092, 'tissue_paper': 1093, 'toast_(food)': 1094, 'toaster': 1095, 'toaster_oven': 1096, 'toilet': 1097, 'toilet_tissue': 1098, 'tomato': 1099, 'tongs': 1100, 'toolbox': 1101, 'toothbrush': 1102, 'toothpaste': 1103, 'toothpick': 1104, 'cover': 1105, 'tortilla': 1106, 'tow_truck': 1107, 'towel': 1108, 'towel_rack': 1109, 'toy': 1110, 'tractor_(farm_equipment)': 1111, 'traffic_light': 1112, 'dirt_bike': 1113, 'trailer_truck': 1114, 'train_(railroad_vehicle)': 1115, 'trampoline': 1116, 'tray': 1117, 'trench_coat': 1118, 'triangle_(musical_instrument)': 1119, 'tricycle': 1120, 'tripod': 1121, 'trousers': 1122, 'truck': 1123, 'truffle_(chocolate)': 1124, 'trunk': 1125, 'vat': 1126, 'turban': 1127, 'turkey_(food)': 1128, 'turnip': 1129, 'turtle': 1130, 'turtleneck_(clothing)': 1131, 'typewriter': 1132, 'umbrella': 1133, 'underwear': 1134, 'unicycle': 1135, 'urinal': 1136, 'urn': 1137, 'vacuum_cleaner': 1138, 'vase': 1139, 'vending_machine': 1140, 'vent': 1141, 'vest': 1142, 'videotape': 1143, 'vinegar': 1144, 'violin': 1145, 'vodka': 1146, 'volleyball': 1147, 'vulture': 1148, 'waffle': 1149, 'waffle_iron': 1150, 'wagon': 1151, 'wagon_wheel': 1152, 'walking_stick': 1153, 'wall_clock': 1154, 'wall_socket': 1155, 'wallet': 1156, 'walrus': 1157, 'wardrobe': 1158, 'washbasin': 1159, 'automatic_washer': 1160, 'watch': 1161, 'water_bottle': 1162, 'water_cooler': 1163, 'water_faucet': 1164, 'water_heater': 1165, 'water_jug': 1166, 'water_gun': 1167, 'water_scooter': 1168, 'water_ski': 1169, 'water_tower': 1170, 'watering_can': 1171, 'watermelon': 1172, 'weathervane': 1173, 'webcam': 1174, 'wedding_cake': 1175, 'wedding_ring': 1176, 'wet_suit': 1177, 'wheel': 1178, 'wheelchair': 1179, 'whipped_cream': 1180, 'whistle': 1181, 'wig': 1182, 'wind_chime': 1183, 'windmill': 1184, 'window_box_(for_plants)': 1185, 'windshield_wiper': 1186, 'windsock': 1187, 'wine_bottle': 1188, 'wine_bucket': 1189, 'wineglass': 1190, 'blinder_(for_horses)': 1191, 'wok': 1192, 'wolf': 1193, 'wooden_spoon': 1194, 'wreath': 1195, 'wrench': 1196, 'wristband': 1197, 'wristlet': 1198, 'yacht': 1199, 'yogurt': 1200, 'yoke_(animal_equipment)': 1201, 'zebra': 1202, 'zucchini': 1203}

        self.class2type = {self.type2class[t]:t for t in self.type2class}
        #change this 
        self.type_mean_size = {
            'door': np.array([1,0.05,2]),
            'aerosol_can': np.array([0.07,0.07,0.2]),
            'air_conditioner': np.array([1.0,0.5,0.3]),
            'airplane': np.array([40.0,45.0,11.6]),
            'alarm_clock': np.array([0.16,0.075,0.16]),
            'alcohol': np.array([0.1,0.1,0.2]),
            'alligator': np.array([4.0,0.5,0.2]),
            'almond': np.array([0.02,0.01,0.01]),
            'ambulance': np.array([6.0,2.5,3.0]),
            'amplifier': np.array([0.5,0.35,0.2]),
            'anklet': np.array([0.06,0.06,0.005]),
            'antenna': np.array([0.008,0.008,1.5]),
            'apple': np.array([0.08,0.08,0.09]),
            'applesauce': np.array([0.09,0.09,0.08]),
            'apricot': np.array([0.08,0.08,0.08]),
            'apron': np.array([0.3,0.01,0.7]),
            'aquarium': np.array([1.2,0.6,0.7]),
            'arctic_(type_of_shoe)': np.array([0.3,0.1,0.12]),
            'armband': np.array([0.1,0.02,0.07]),
            'armchair': np.array([1.0,0.8,1.0]),
            'armoire': np.array([2.0,1.0,2.5]),
            'armor': np.array([0.6,0.3,1.8]),
            'artichoke': np.array([0.14,0.14,0.2]),
            'trash_can': np.array([0.5,0.5,0.8]),
            'ashtray': np.array([0.15,0.15,0.05]),
            'asparagus': np.array([0.15,0.02,0.02]),
            'atomizer': np.array([0.1,0.1,0.15]),
            'avocado': np.array([0.2,0.1,0.1]),
            'award': np.array([0.2,0.02,0.3]),
            'awning': np.array([3.0,3.0,0.2]),
            'ax': np.array([0.9,0.15,0.04]),
            'baboon': np.array([0.75,0.3,0.65]),
            'baby_buggy': np.array([1.0,0.6,1.0]),
            'basketball_backboard': np.array([1.8,1.05,0.02]),
            'backpack': np.array([0.5,0.17,0.32]),
            'handbag': np.array([0.3,0.1,0.2]),
            'suitcase': np.array([0.75,0.45,0.3]),
            'bagel': np.array([0.15,0.15,0.05]),
            'bagpipe': np.array([1.0,0.3,0.5]),
            'baguet': np.array([0.65,0.05,0.05]),
            'bait': np.array([0.1,0.1,0.1]),
            'ball': np.array([0.22,0.22,0.22]),
            'ballet_skirt': np.array([0.7,1.2,0.5]),
            'balloon': np.array([0.3,0.3,0.4]),
            'bamboo': np.array([0.1,0.1,2.5]),
            'banana': np.array([0.2,0.04,0.04]),
            'Band_Aid': np.array([0.1,0.02,0.001]),
            'bandage': np.array([0.1,0.05,0.01]),
            'bandanna': np.array([0.55,0.55,0.005]),
            'banjo': np.array([0.6,0.25,0.1]),
            'banner': np.array([1.5,0.005,0.9]),
            'barbell': np.array([2.2,0.05,0.05]),
            'barge': np.array([20.0,10.0,6.0]),
            'barrel': np.array([0.9,0.9,1.2]),
            'barrette': np.array([0.04,0.01,0.006]),
            'barrow': np.array([1.0,0.6,0.5]),
            'baseball_base': np.array([0.38,0.38,0.07]),
            'baseball': np.array([0.073,0.073,0.073]),
            'baseball_bat': np.array([0.965,0.075,0.075]),
            'baseball_cap': np.array([0.3,0.2,0.15]),
            'baseball_glove': np.array([0.25,0.15,0.3]),
            'basket': np.array([0.4,0.4,0.3]),
            'basketball': np.array([0.24,0.24,0.24]),
            'bass_horn': np.array([1.3,0.3,0.3]),
            'bat_(animal)': np.array([0.15,0.4,0.02]),
            'bath_mat': np.array([0.8,0.5,0.02]),
            'bath_towel': np.array([1.5,0.75,0.02]),
            'bathrobe': np.array([0.6,0.3,0.1]),
            'bathtub': np.array([1.7,0.75,0.45]),
            'batter_(food)': np.array([0.2,0.2,0.2]),
            'battery': np.array([0.06,0.03,0.05]),
            'beachball': np.array([0.3,0.3,0.3]),
            'bead': np.array([0.002,0.002,0.002]),
            'bean_curd': np.array([0.1,0.1,0.02]),
            'beanbag': np.array([1.0,1.0,0.7]),
            'beanie': np.array([0.23,0.23,0.15]),
            'bear': np.array([1.8,0.8,1.3]),
            'bed': np.array([2.0,1.5,0.7]),
            'bedpan': np.array([0.4,0.3,0.15]),
            'bedspread': np.array([2.5,2.7,0.02]),
            'cow': np.array([2.5,1.0,1.5]),
            'beef_(food)': np.array([0.2,0.12,0.08]),
            'beeper': np.array([0.1,0.05,0.02]),
            'beer_bottle': np.array([0.07,0.07,0.25]),
            'beer_can': np.array([0.07,0.07,0.12]),
            'beetle': np.array([0.01,0.006,0.004]),
            'bell': np.array([0.2,0.2,0.3]),
            'bell_pepper': np.array([0.08,0.08,0.09]),
            'belt': np.array([1.2,0.02,0.01]),
            'belt_buckle': np.array([0.08,0.06,0.02]),
            'bench': np.array([2.0,0.5,1.0]),
            'beret': np.array([0.28,0.28,0.1]),
            'bib': np.array([0.3,0.3,0.02]),
            'Bible': np.array([0.15,0.1,0.05]),
            'bicycle': np.array([1.7,0.6,1.0]),
            'visor': np.array([0.2,0.15,0.1]),
            'billboard': np.array([6.0,1.0,3.0]),
            'binder': np.array([0.32,0.07,0.25]),
            'binoculars': np.array([0.2,0.1,0.07]),
            'bird': np.array([0.3,0.05,0.05]),
            'birdfeeder': np.array([0.15,0.15,0.3]),
            'birdbath': np.array([0.5,0.5,1.0]),
            'birdcage': np.array([0.5,0.5,1.0]),
            'birdhouse': np.array([0.2,0.2,0.3]),
            'birthday_cake': np.array([0.5,0.5,0.5]),
            'birthday_card': np.array([0.15,0.01,0.11]),
            'pirate_flag': np.array([1.5,1.0,0.02]),
            'black_sheep': np.array([1.2,0.8,0.6]),
            'blackberry': np.array([0.05,0.05,0.05]),
            'blackboard': np.array([2.0,1.0,0.05]),
            'blanket': np.array([2.0,2.3,0.02]),
            'blazer': np.array([0.8,0.6,0.2]),
            'blender': np.array([0.2,0.2,0.4]),
            'blimp': np.array([60.0,15.0,20.0]),
            'blinker': np.array([0.2,0.2,0.2]),
            'blouse': np.array([0.6,0.1,0.75]),
            'blueberry': np.array([0.01,0.01,0.01]),
            'gameboard': np.array([0.5,0.5,0.02]),
            'boat': np.array([3.0,1.5,1.0]),
            'bob': np.array([0.1,0.1,0.1]),
            'bobbin': np.array([0.02,0.02,0.04]),
            'bobby_pin': np.array([0.05,0.01,0.01]),
            'boiled_egg': np.array([0.045,0.045,0.06]),
            'bolo_tie': np.array([0.02,0.02,0.4]),
            'deadbolt': np.array([0.05,0.05,0.1]),
            'bolt': np.array([0.01,0.01,0.05]),
            'bonnet': np.array([0.3,0.3,0.2]),
            'book': np.array([0.25,0.02,0.3]),
            'bookcase': np.array([1.0,0.4,2.0]),
            'booklet': np.array([0.15,0.01,0.22]),
            'bookmark': np.array([0.15,0.04,0.001]),
            'boom_microphone': np.array([0.45,0.05,0.05]),
            'boot': np.array([0.3,0.15,0.2]),
            'bottle': np.array([0.07,0.07,0.3]),
            'bottle_opener': np.array([0.04,0.02,0.01]),
            'bouquet': np.array([0.4,0.4,0.6]),
            'bow_(weapon)': np.array([0.7,0.1,0.2]),
            'bow_(decorative_ribbons)': np.array([0.7,0.1,0.2]),
            'bow-tie': np.array([0.12,0.05,0.01]),
            'bowl': np.array([0.15,0.15,0.1]),
            'pipe_bowl': np.array([0.1,0.05,0.05]),
            'bowler_hat': np.array([0.3,0.3,0.15]),
            'bowling_ball': np.array([0.22,0.22,0.22]),
            'box': np.array([0.2,0.2,0.2]),
            'boxing_glove': np.array([0.3,0.15,0.15]),
            'suspenders': np.array([0.5,0.1,0.01]),
            'bracelet': np.array([0.07,0.07,0.05]),
            'brass_plaque': np.array([0.3,0.2,0.01]),
            'brassiere': np.array([0.35,0.15,0.15]),
            'bread-bin': np.array([0.5,0.3,0.2]),
            'bread': np.array([0.24,0.13,0.12]),
            'breechcloth': np.array([0.5,0.35,0.01]),
            'bridal_gown': np.array([0.6,0.6,1.5]),
            'briefcase': np.array([0.45,0.15,0.3]),
            'broccoli': np.array([0.15,0.15,0.2]),
            'broach': np.array([0.05,0.05,0.01]),
            'broom': np.array([1.0,0.1,0.1]),
            'brownie': np.array([0.05,0.05,0.02]),
            'brussels_sprouts': np.array([0.04,0.04,0.04]),
            'bubble_gum': np.array([0.02,0.01,0.01]),
            'bucket': np.array([0.3,0.3,0.4]),
            'horse_buggy': np.array([2.5,1.5,1.5]),
            'bull': np.array([3.1,1.5,2.0]),
            'bulldog': np.array([0.6,0.3,0.5]),
            'bulldozer': np.array([3.0,2.0,1.5]),
            'bullet_train': np.array([200.0,2.8,3.5]),
            'bulletin_board': np.array([1.2,0.05,0.9]),
            'bulletproof_vest': np.array([0.6,0.3,0.2]),
            'bullhorn': np.array([0.4,0.15,0.05]),
            'bun': np.array([0.1,0.1,0.05]),
            'bunk_bed': np.array([2.0,1.0,1.6]),
            'buoy': np.array([1.0,1.0,1.5]),
            'burrito': np.array([0.2,0.2,0.08]),
            'bus_(vehicle)': np.array([15.0,2.5,4.0]),
            'business_card': np.array([0.09,0.05,0.001]),
            'butter': np.array([0.05,0.05,0.02]),
            'butterfly': np.array([0.1,0.01,0.02]),
            'button': np.array([0.02,0.02,0.01]),
            'cab_(taxi)': np.array([4.4,1.9,1.5]),
            'cabana': np.array([3.0,3.0,2.5]),
            'cabin_car': np.array([35.0,2.5,4.0]),
            'cabinet': np.array([0.9,0.45,1.8]),
            'locker': np.array([0.4,0.6,1.8]),
            'cake': np.array([0.2,0.2,0.1]),
            'calculator': np.array([0.15,0.1,0.02]),
            'calendar': np.array([0.3,0.01,0.4]),
            'calf': np.array([1.2,0.5,1.4]),
            'camcorder': np.array([0.2,0.13,0.09]),
            'camel': np.array([3.5,1.5,2.2]),
            'camera': np.array([0.15,0.1,0.1]),
            'camera_lens': np.array([0.075,0.075,0.075]),
            'camper_(vehicle)': np.array([6.0,2.5,3.0]),
            'can': np.array([0.07,0.07,0.12]),
            'can_opener': np.array([0.15,0.05,0.02]),
            'candle': np.array([0.04,0.04,0.2]),
            'candle_holder': np.array([0.1,0.1,0.2]),
            'candy_bar': np.array([0.15,0.05,0.01]),
            'candy_cane': np.array([0.01,0.01,0.13]),
            'walking_cane': np.array([0.9,0.02,0.02]),
            'canister': np.array([0.2,0.2,0.3]),
            'canoe': np.array([5.0,1.0,0.5]),
            'cantaloup': np.array([0.25,0.25,0.15]),
            'canteen': np.array([0.1,0.1,0.2]),
            'cap_(headwear)': np.array([0.3,0.2,0.15]),
            'bottle_cap': np.array([0.03,0.03,0.01]),
            'cape': np.array([1.0,1.0,0.2]),
            'cappuccino': np.array([0.1,0.1,0.12]),
            'car_(automobile)': np.array([4.3,1.8,1.5]),
            'railcar_(part_of_a_train)': np.array([15.0,3.0,4.5]),
            'elevator_car': np.array([2.5,2.0,2.25]),
            'car_battery': np.array([0.3,0.2,0.2]),
            'identity_card': np.array([0.086,0.054,0.001]),
            'card': np.array([0.085,0.05,0.001]),
            'cardigan': np.array([0.6,0.5,0.2]),
            'cargo_ship': np.array([300.0,50.0,30.0]),
            'carnation': np.array([0.05,0.05,0.2]),
            'horse_carriage': np.array([2.5,1.2,1.5]),
            'carrot': np.array([0.025,0.025,0.15]),
            'tote_bag': np.array([0.35,0.2,0.4]),
            'cart': np.array([1.2,0.6,0.65]),
            'carton': np.array([0.6,0.4,0.4]),
            'cash_register': np.array([0.4,0.4,0.4]),
            'casserole': np.array([0.3,0.3,0.15]),
            'cassette': np.array([0.1,0.07,0.02]),
            'cast': np.array([0.5,0.3,0.15]),
            'cat': np.array([0.46,0.12,0.25]),
            'cauliflower': np.array([0.2,0.2,0.1]),
            'cayenne_(spice)': np.array([0.15,0.02,0.02]),
            'CD_player': np.array([0.43,0.38,0.13]),
            'celery': np.array([0.05,0.05,0.3]),
            'cellular_telephone': np.array([0.07,0.03,0.01]),
            'chain_mail': np.array([1.0,0.6,0.1]),
            'chair': np.array([0.6,0.6,1.0]),
            'chaise_longue': np.array([2.0,0.9,0.75]),
            'chalice': np.array([0.1,0.1,0.2]),
            'chandelier': np.array([1.0,1.0,1.5]),
            'chap': np.array([1.0,0.5,0.05]),
            'checkbook': np.array([0.15,0.08,0.01]),
            'checkerboard': np.array([0.4,0.4,0.02]),
            'cherry': np.array([0.02,0.02,0.02]),
            'chessboard': np.array([0.4,0.4,0.01]),
            'chicken_(animal)': np.array([0.3,0.15,0.4]),
            'chickpea': np.array([0.01,0.01,0.01]),
            'chili_(vegetable)': np.array([0.15,0.02,0.02]),
            'chime': np.array([0.05,0.05,1.0]),
            'chinaware': np.array([0.3,0.3,0.1]),
            'crisp_(potato_chip)': np.array([0.04,0.04,0.01]),
            'poker_chip': np.array([0.9,0.6,0.02]),
            'chocolate_bar': np.array([0.15,0.05,0.02]),
            'chocolate_cake': np.array([0.15,0.15,0.06]),
            'chocolate_milk': np.array([0.1,0.1,0.3]),
            'chocolate_mousse': np.array([0.07,0.07,0.06]),
            'choker': np.array([0.15,0.02,0.025]),
            'chopping_board': np.array([0.3,0.2,0.02]),
            'chopstick': np.array([0.25,0.01,0.01]),
            'Christmas_tree': np.array([1.5,1.2,2.4]),
            'slide': np.array([3.0,1.0,2.0]),
            'cider': np.array([0.1,0.1,0.3]),
            'cigar_box': np.array([0.2,0.1,0.03]),
            'cigarette': np.array([0.01,0.01,0.09]),
            'cigarette_case': np.array([0.09,0.06,0.02]),
            'cistern': np.array([1.5,1.5,1.5]),
            'clarinet': np.array([0.67,0.05,0.05]),
            'clasp': np.array([0.02,0.01,0.005]),
            'cleansing_agent': np.array([0.1,0.05,0.2]),
            'cleat_(for_securing_rope)': np.array([0.3,0.1,0.1]),
            'clementine': np.array([0.08,0.08,0.08]),
            'clip': np.array([0.1,0.03,0.02]),
            'clipboard': np.array([0.31,0.23,0.02]),
            'clippers_(for_plants)': np.array([0.15,0.05,0.05]),
            'cloak': np.array([1.2,0.6,0.2]),
            'clock': np.array([0.3,0.05,0.3]),
            'clock_tower': np.array([10.0,4.0,30.0]),
            'clothes_hamper': np.array([0.5,0.5,0.6]),
            'clothespin': np.array([0.1,0.02,0.03]),
            'clutch_bag': np.array([0.2,0.02,0.1]),
            'coaster': np.array([0.1,0.1,0.02]),
            'coat': np.array([0.8,0.3,1.2]),
            'coat_hanger': np.array([0.4,0.01,0.15]),
            'coatrack': np.array([0.4,0.4,1.8]),
            'cock': np.array([0.5,0.2,0.6]),
            'cockroach': np.array([0.04,0.01,0.01]),
            'cocoa_(beverage)': np.array([0.15,0.15,0.3]),
            'coconut': np.array([0.1,0.1,0.1]),
            'coffee_maker': np.array([0.3,0.2,0.4]),
            'coffee_table': np.array([1.2,0.6,0.4]),
            'coffeepot': np.array([0.25,0.15,0.3]),
            'coil': np.array([0.15,0.15,0.1]),
            'coin': np.array([0.02,0.02,0.001]),
            'colander': np.array([0.3,0.3,0.15]),
            'coleslaw': np.array([0.15,0.15,0.07]),
            'coloring_material': np.array([0.05,0.05,0.1]),
            'combination_lock': np.array([0.06,0.05,0.03]),
            'pacifier': np.array([0.03,0.03,0.06]),
            'comic_book': np.array([0.02,0.15,0.22]),
            'compass': np.array([0.1,0.1,0.02]),
            'computer_keyboard': np.array([0.45,0.15,0.03]),
            'condiment': np.array([0.05,0.05,0.12]),
            'cone': np.array([0.3,0.3,0.5]),
            'control': np.array([0.15,0.07,0.02]),
            'convertible_(automobile)': np.array([4.7,1.8,1.3]),
            'sofa_bed': np.array([2.0,0.9,1.0]),
            'cooker': np.array([0.6,0.6,0.85]),
            'cookie': np.array([0.05,0.05,0.02]),
            'cooking_utensil': np.array([0.3,0.1,0.05]),
            'cooler_(for_food)': np.array([0.6,0.4,0.35]),
            'cork_(bottle_plug)': np.array([0.05,0.05,0.04]),
            'corkboard': np.array([1.2,1.8,0.02]),
            'corkscrew': np.array([0.015,0.015,0.1]),
            'edible_corn': np.array([0.02,0.02,0.08]),
            'cornbread': np.array([0.3,0.3,0.05]),
            'cornet': np.array([0.09,0.06,0.48]),
            'cornice': np.array([2.0,0.3,0.15]),
            'cornmeal': np.array([0.2,0.1,0.3]),
            'corset': np.array([0.6,0.3,0.15]),
            'costume': np.array([1.0,0.5,1.5]),
            'cougar': np.array([1.2,0.3,0.6]),
            'coverall': np.array([0.8,0.35,1.2]),
            'cowbell': np.array([0.08,0.08,0.12]),
            'cowboy_hat': np.array([0.4,0.35,0.15]),
            'crab_(animal)': np.array([0.15,0.1,0.06]),
            'crabmeat': np.array([0.15,0.15,0.05]),
            'cracker': np.array([0.06,0.06,0.01]),
            'crape': np.array([0.5,0.5,0.02]),
            'crate': np.array([1.0,1.0,1.0]),
            'crayon': np.array([0.01,0.01,0.1]),
            'cream_pitcher': np.array([0.15,0.1,0.1]),
            'crescent_roll': np.array([0.1,0.05,0.05]),
            'crib': np.array([1.3,0.7,1.2]),
            'crock_pot': np.array([0.35,0.35,0.25]),
            'crossbar': np.array([2.0,0.02,0.02]),
            'crouton': np.array([0.02,0.02,0.01]),
            'crow': np.array([0.4,0.07,0.2]),
            'crowbar': np.array([1.0,0.03,0.03]),
            'crown': np.array([0.2,0.2,0.2]),
            'crucifix': np.array([1.8,1.2,0.1]),
            'cruise_ship': np.array([300.0,50.0,72.0]),
            'police_cruiser': np.array([4.5,2.0,1.5]),
            'crumb': np.array([0.005,0.005,0.005]),
            'crutch': np.array([1.4,0.2,0.05]),
            'cub_(animal)': np.array([0.5,0.3,0.3]),
            'cube': np.array([1.0,1.0,1.0]),
            'cucumber': np.array([0.03,0.03,0.15]),
            'cufflink': np.array([0.02,0.02,0.01]),
            'cup': np.array([0.12,0.12,0.15]),
            'trophy_cup': np.array([0.2,0.2,0.5]),
            'cupboard': np.array([2.0,0.6,1.75]),
            'cupcake': np.array([0.07,0.07,0.07]),
            'hair_curler': np.array([0.35,0.03,0.03]),
            'curling_iron': np.array([0.4,0.05,0.05]),
            'curtain': np.array([2.0,3.0,0.01]),
            'cushion': np.array([0.5,0.5,0.15]),
            'cylinder': np.array([1.0,1.0,2.0]),
            'cymbal': np.array([0.5,0.5,0.05]),
            'dagger': np.array([0.3,0.02,0.02]),
            'dalmatian': np.array([1.5,0.4,1.0]),
            'dartboard': np.array([0.45,0.45,0.05]),
            'date_(fruit)': np.array([0.1,0.1,0.1]),
            'deck_chair': np.array([0.65,0.6,1.1]),
            'deer': np.array([2.0,1.0,1.5]),
            'dental_floss': np.array([0.02,0.02,0.05]),
            'desk': np.array([1.2,0.6,0.75]),
            'detergent': np.array([0.09,0.09,0.28]),
            'diaper': np.array([0.15,0.15,0.03]),
            'diary': np.array([0.25,0.18,0.03]),
            'die': np.array([0.015,0.015,0.015]),
            'dinghy': np.array([2.0,1.0,0.5]),
            'dining_table': np.array([1.8,1.0,0.75]),
            'tux': np.array([0.8,0.5,0.2]),
            'dish': np.array([0.2,0.2,0.05]),
            'dish_antenna': np.array([1.0,1.0,1.5]),
            'dishrag': np.array([0.3,0.3,0.01]),
            'dishtowel': np.array([0.3,0.3,0.01]),
            'dishwasher': np.array([0.6,0.6,0.85]),
            'dishwasher_detergent': np.array([0.1,0.1,0.25]),
            'dispenser': np.array([0.25,0.25,1.5]),
            'diving_board': np.array([3.0,0.5,0.8]),
            'Dixie_cup': np.array([0.1,0.1,0.15]),
            'dog': np.array([1.0,0.3,0.7]),
            'dog_collar': np.array([0.6,0.3,0.1]),
            'doll': np.array([0.1,0.05,0.2]),
            'dollar': np.array([0.006,0.01,0.0001]),
            'dollhouse': np.array([1.0,0.6,1.2]),
            'dolphin': np.array([4.0,1.0,1.6]),
            'domestic_ass': np.array([2.4,1.0,1.5]),
            'doorknob': np.array([0.05,0.05,0.05]),
            'doormat': np.array([0.7,0.4,0.02]),
            'doughnut': np.array([0.1,0.1,0.05]),
            'dove': np.array([0.05,0.1,0.08]),
            'dragonfly': np.array([0.05,0.04,0.01]),
            'drawer': np.array([0.7,0.5,0.4]),
            'underdrawers': np.array([0.4,0.1,0.2]),
            'dress': np.array([1.0,0.5,0.05]),
            'dress_hat': np.array([0.3,0.3,0.15]),
            'dress_suit': np.array([0.8,0.6,0.3]),
            'dresser': np.array([1.5,0.5,0.75]),
            'drill': np.array([0.3,0.07,0.07]),
            'drone': np.array([0.3,0.3,0.1]),
            'dropper': np.array([0.15,0.03,0.03]),
            'drum_(musical_instrument)': np.array([0.5,0.5,0.75]),
            'drumstick': np.array([0.04,0.04,0.15]),
            'duck': np.array([0.6,0.25,0.3]),
            'duckling': np.array([0.15,0.1,0.1]),
            'duct_tape': np.array([0.1,0.1,0.05]),
            'duffel_bag': np.array([0.8,0.3,0.4]),
            'dumbbell': np.array([0.3,0.05,0.05]),
            'dumpster': np.array([2.0,1.5,1.5]),
            'dustpan': np.array([0.3,0.2,0.03]),
            'eagle': np.array([0.9,2.1,0.3]),
            'earphone': np.array([0.01,0.02,0.025]),
            'earplug': np.array([0.02,0.01,0.01]),
            'earring': np.array([0.01,0.01,0.02]),
            'easel': np.array([1.7,0.6,2.1]),
            'eclair': np.array([0.15,0.05,0.03]),
            'eel': np.array([1.0,0.2,0.1]),
            'egg': np.array([0.045,0.03,0.03]),
            'egg_roll': np.array([0.1,0.1,0.05]),
            'egg_yolk': np.array([0.03,0.03,0.03]),
            'eggbeater': np.array([0.3,0.1,0.1]),
            'eggplant': np.array([0.2,0.1,0.1]),
            'electric_chair': np.array([0.9,0.65,1.2]),
            'refrigerator': np.array([0.7,0.7,1.8]),
            'elephant': np.array([6.0,2.5,3.3]),
            'elk': np.array([2.5,1.0,1.7]),
            'envelope': np.array([0.25,0.175,0.01]),
            'eraser': np.array([0.06,0.02,0.01]),
            'escargot': np.array([0.05,0.03,0.02]),
            'eyepatch': np.array([0.1,0.05,0.01]),
            'falcon': np.array([0.5,0.3,0.7]),
            'fan': np.array([0.3,0.3,0.5]),
            'faucet': np.array([0.15,0.15,0.2]),
            'fedora': np.array([0.3,0.3,0.15]),
            'ferret': np.array([0.5,0.1,0.2]),
            'Ferris_wheel': np.array([30.0,30.0,35.0]),
            'ferry': np.array([50.0,10.0,22.0]),
            'fig_(fruit)': np.array([0.05,0.05,0.05]),
            'fighter_jet': np.array([15.0,10.0,5.0]),
            'figurine': np.array([0.2,0.1,0.3]),
            'file_cabinet': np.array([0.45,0.6,1.3]),
            'file_(tool)': np.array([0.3,0.25,0.05]),
            'fire_alarm': np.array([0.15,0.15,0.05]),
            'fire_engine': np.array([8.0,2.5,3.0]),
            'fire_extinguisher': np.array([0.14,0.14,0.5]),
            'fire_hose': np.array([0.75,0.1,0.1]),
            'fireplace': np.array([1.5,0.6,2.0]),
            'fireplug': np.array([0.6,0.6,1.2]),
            'first-aid_kit': np.array([0.2,0.15,0.1]),
            'fish': np.array([0.3,0.15,0.1]),
            'fish_(food)': np.array([0.3,0.15,0.1]),
            'fishbowl': np.array([0.3,0.3,0.35]),
            'fishing_rod': np.array([2.0,0.02,0.02]),
            'flag': np.array([1.8,0.9,0.01]),
            'flagpole': np.array([1.0,0.05,9.0]),
            'flamingo': np.array([1.2,0.4,1.6]),
            'flannel': np.array([2.0,1.5,0.02]),
            'flap': np.array([0.3,0.25,0.02]),
            'flash': np.array([0.05,0.05,0.1]),
            'flashlight': np.array([0.15,0.05,0.05]),
            'fleece': np.array([2.0,1.5,0.5]),
            'flip-flop_(sandal)': np.array([0.3,0.11,0.1]),
            'flipper_(footwear)': np.array([0.3,0.25,0.05]),
            'flower_arrangement': np.array([0.4,0.4,0.7]),
            'flute_glass': np.array([0.05,0.05,0.2]),
            'foal': np.array([1.0,0.3,1.0]),
            'folding_chair': np.array([0.9,0.5,0.8]),
            'food_processor': np.array([0.38,0.25,0.4]),
            'football_(American)': np.array([0.22,0.22,0.22]),
            'football_helmet': np.array([0.3,0.25,0.2]),
            'footstool': np.array([0.4,0.4,0.2]),
            'fork': np.array([0.19,0.02,0.02]),
            'forklift': np.array([3.0,1.5,2.5]),
            'freight_car': np.array([14.6,2.6,4.1]),
            'French_toast': np.array([0.15,0.15,0.02]),
            'freshener': np.array([0.05,0.05,0.15]),
            'frisbee': np.array([0.27,0.27,0.025]),
            'frog': np.array([0.15,0.15,0.1]),
            'fruit_juice': np.array([0.1,0.1,0.2]),
            'frying_pan': np.array([0.3,0.5,0.1]),
            'fudge': np.array([0.1,0.1,0.02]),
            'funnel': np.array([0.3,0.3,0.4]),
            'futon': np.array([2.0,1.2,0.2]),
            'gag': np.array([0.05,0.01,0.01]),
            'garbage': np.array([0.6,0.6,0.9]),
            'garbage_truck': np.array([6.0,2.5,3.0]),
            'garden_hose': np.array([20.0,0.02,0.02]),
            'gargle': np.array([0.05,0.05,0.15]),
            'gargoyle': np.array([0.6,0.3,1.0]),
            'garlic': np.array([0.05,0.05,0.05]),
            'gasmask': np.array([0.15,0.1,0.2]),
            'gazelle': np.array([1.5,0.3,1.0]),
            'gelatin': np.array([0.06,0.06,0.04]),
            'gemstone': np.array([0.05,0.05,0.05]),
            'generator': np.array([1.0,0.7,0.8]),
            'giant_panda': np.array([1.5,0.6,0.9]),
            'gift_wrap': np.array([0.5,0.5,0.02]),
            'ginger': np.array([0.1,0.04,0.02]),
            'giraffe': np.array([4.2,2.0,6.0]),
            'cincture': np.array([1.0,0.03,0.1]),
            'glass_(drink_container)': np.array([0.1,0.1,0.2]),
            'globe': np.array([0.4,0.4,0.6]),
            'glove': np.array([0.25,0.1,0.15]),
            'goat': np.array([1.5,0.4,1.0]),
            'goggles': np.array([0.15,0.05,0.05]),
            'goldfish': np.array([0.3,0.15,0.15]),
            'golf_club': np.array([1.0,0.01,0.01]),
            'golfcart': np.array([2.0,1.0,1.5]),
            'gondola_(boat)': np.array([11.0,1.4,1.7]),
            'goose': np.array([0.9,0.4,0.6]),
            'gorilla': np.array([1.75,0.75,1.7]),
            'gourd': np.array([0.2,0.2,0.4]),
            'grape': np.array([0.02,0.02,0.02]),
            'grater': np.array([0.1,0.05,0.2]),
            'gravestone': np.array([0.9,0.3,2.0]),
            'gravy_boat': np.array([0.2,0.1,0.1]),
            'green_bean': np.array([0.01,0.01,0.1]),
            'green_onion': np.array([0.03,0.03,0.3]),
            'griddle': np.array([0.4,0.4,0.05]),
            'grill': np.array([0.6,0.6,0.9]),
            'grits': np.array([0.01,0.01,0.01]),
            'grizzly': np.array([2.0,1.0,1.3]),
            'grocery_bag': np.array([0.4,0.3,0.6]),
            'guitar': np.array([1.0,0.38,0.1]),
            'gull': np.array([0.6,1.6,0.2]),
            'gun': np.array([0.35,0.02,0.15]),
            'hairbrush': np.array([0.2,0.05,0.03]),
            'hairnet': np.array([0.2,0.2,0.02]),
            'hairpin': np.array([0.06,0.006,0.02]),
            'halter_top': np.array([0.4,0.01,0.3]),
            'ham': np.array([0.3,0.2,0.15]),
            'hamburger': np.array([0.12,0.12,0.06]),
            'hammer': np.array([0.3,0.1,0.05]),
            'hammock': np.array([2.5,1.5,0.7]),
            'hamper': np.array([0.5,0.3,0.2]),
            'hamster': np.array([0.1,0.06,0.06]),
            'hair_dryer': np.array([0.2,0.08,0.1]),
            'hand_glass': np.array([0.1,0.1,0.15]),
            'hand_towel': np.array([0.5,0.3,0.01]),
            'handcart': np.array([1.5,0.8,1.0]),
            'handcuff': np.array([0.1,0.05,0.02]),
            'handkerchief': np.array([0.4,0.4,0.01]),
            'handle': np.array([0.15,0.02,0.05]),
            'handsaw': np.array([0.5,0.02,0.06]),
            'hardback_book': np.array([0.3,0.02,0.2]),
            'harmonium': np.array([1.0,0.5,1.0]),
            'hat': np.array([0.35,0.35,0.15]),
            'hatbox': np.array([0.4,0.4,0.3]),
            'veil': np.array([0.9,0.9,0.01]),
            'headband': np.array([0.5,0.01,0.005]),
            'headboard': np.array([1.5,0.05,1.0]),
            'headlight': np.array([0.15,0.15,0.2]),
            'headscarf': np.array([0.7,0.7,0.02]),
            'headset': np.array([0.16,0.03,0.18]),
            'headstall_(for_horses)': np.array([0.25,1.5,0.15]),
            'heart': np.array([0.15,0.15,0.1]),
            'heater': np.array([1.0,0.3,1.5]),
            'helicopter': np.array([8.0,3.0,2.5]),
            'helmet': np.array([0.3,0.25,0.2]),
            'heron': np.array([0.9,0.18,1.0]),
            'highchair': np.array([0.5,0.5,0.85]),
            'hinge': np.array([0.05,0.02,0.01]),
            'hippopotamus': np.array([3.5,1.5,1.5]),
            'hockey_stick': np.array([1.5,0.03,0.02]),
            'hog': np.array([1.5,0.6,0.9]),
            'home_plate_(baseball)': np.array([0.43,0.43,0.05]),
            'honey': np.array([0.08,0.08,0.1]),
            'fume_hood': np.array([1.2,0.8,2.0]),
            'hook': np.array([0.1,0.02,0.02]),
            'hookah': np.array([0.1,0.1,0.3]),
            'hornet': np.array([0.05,0.01,0.01]),
            'horse': np.array([2.4,0.5,1.7]),
            'hose': np.array([10.0,0.05,0.05]),
            'hot-air_balloon': np.array([10.0,10.0,12.0]),
            'hotplate': np.array([0.3,0.3,0.1]),
            'hot_sauce': np.array([0.05,0.05,0.2]),
            'hourglass': np.array([0.1,0.1,0.2]),
            'houseboat': np.array([15.0,6.0,5.0]),
            'hummingbird': np.array([0.02,0.02,0.05]),
            'hummus': np.array([0.1,0.1,0.05]),
            'polar_bear': np.array([2.0,1.0,1.5]),
            'icecream': np.array([0.1,0.1,0.15]),
            'popsicle': np.array([0.15,0.02,0.02]),
            'ice_maker': np.array([0.35,0.5,0.6]),
            'ice_pack': np.array([0.5,0.3,0.75]),
            'ice_skate': np.array([0.3,0.1,0.15]),
            'igniter': np.array([0.04,0.04,0.02]),
            'inhaler': np.array([0.04,0.02,0.1]),
            'iPod': np.array([0.06,0.01,0.1]),
            'iron_(for_clothing)': np.array([0.3,0.1,0.15]),
            'ironing_board': np.array([1.42,0.34,0.87]),
            'jacket': np.array([0.8,0.3,0.2]),
            'jam': np.array([0.1,0.1,0.1]),
            'jar': np.array([0.09,0.09,0.15]),
            'jean': np.array([1.0,0.6,0.02]),
            'jeep': np.array([4.5,2.0,1.8]),
            'jelly_bean': np.array([0.015,0.008,0.008]),
            'jersey': np.array([0.7,0.02,0.75]),
            'jet_plane': np.array([45.0,44.0,12.0]),
            'jewel': np.array([0.05,0.05,0.05]),
            'jewelry': np.array([0.1,0.1,0.1]),
            'joystick': np.array([0.15,0.15,0.2]),
            'jumpsuit': np.array([1.0,0.5,0.1]),
            'kayak': np.array([5.0,0.7,0.4]),
            'keg': np.array([0.6,0.6,1.0]),
            'kennel': np.array([1.0,1.0,1.0]),
            'kettle': np.array([0.2,0.2,0.3]),
            'key': np.array([0.06,0.02,0.01]),
            'keycard': np.array([0.085,0.055,0.002]),
            'kilt': np.array([0.7,0.8,0.5]),
            'kimono': np.array([1.3,0.6,0.02]),
            'kitchen_sink': np.array([1.0,0.6,0.4]),
            'kitchen_table': np.array([2.5,1.5,1.0]),
            'kite': np.array([1.2,0.3,0.1]),
            'kitten': np.array([0.3,0.15,0.15]),
            'kiwi_fruit': np.array([0.075,0.075,0.05]),
            'knee_pad': np.array([0.2,0.15,0.1]),
            'knife': np.array([0.3,0.02,0.02]),
            'knitting_needle': np.array([0.3,0.01,0.01]),
            'knob': np.array([0.04,0.04,0.04]),
            'knocker_(on_a_door)': np.array([0.1,0.05,0.05]),
            'koala': np.array([0.85,0.6,0.75]),
            'lab_coat': np.array([1.5,0.6,1.0]),
            'ladder': np.array([2.0,0.5,0.05]),
            'ladle': np.array([0.3,0.1,0.05]),
            'ladybug': np.array([0.01,0.01,0.005]),
            'lamb_(animal)': np.array([0.9,0.3,0.6]),
            'lamb-chop': np.array([0.2,0.1,0.04]),
            'lamp': np.array([0.2,0.2,0.5]),
            'lamppost': np.array([0.3,0.3,3.7]),
            'lampshade': np.array([0.45,0.45,0.3]),
            'lantern': np.array([0.2,0.2,0.4]),
            'lanyard': np.array([0.5,0.02,0.01]),
            'laptop_computer': np.array([0.36,0.24,0.018]),
            'lasagna': np.array([0.3,0.2,0.05]),
            'latch': np.array([0.1,0.04,0.02]),
            'lawn_mower': np.array([1.0,0.5,0.5]),
            'leather': np.array([2.0,1.5,0.02]),
            'legging_(clothing)': np.array([0.9,0.15,0.1]),
            'Lego': np.array([0.016,0.016,0.009]),
            'legume': np.array([0.08,0.03,0.05]),
            'lemon': np.array([0.08,0.08,0.08]),
            'lemonade': np.array([0.1,0.1,0.25]),
            'lettuce': np.array([0.25,0.25,0.1]),
            'license_plate': np.array([0.52,0.11,0.01]),
            'life_buoy': np.array([0.6,0.6,0.15]),
            'life_jacket': np.array([0.6,0.2,0.3]),
            'lightbulb': np.array([0.06,0.06,0.11]),
            'lightning_rod': np.array([5.0,0.02,0.02]),
            'lime': np.array([0.06,0.06,0.06]),
            'limousine': np.array([6.0,2.0,1.5]),
            'lion': np.array([1.9,0.8,1.2]),
            'lip_balm': np.array([0.02,0.02,0.07]),
            'liquor': np.array([0.1,0.1,0.25]),
            'lizard': np.array([0.3,0.1,0.08]),
            'log': np.array([2.0,0.5,0.5]),
            'lollipop': np.array([0.05,0.05,0.05]),
            'speaker_(stero_equipment)': np.array([0.2,0.2,0.3]),
            'loveseat': np.array([1.5,0.9,0.9]),
            'machine_gun': np.array([0.9,0.2,0.35]),
            'magazine': np.array([0.3,0.2,0.01]),
            'magnet': np.array([0.04,0.03,0.01]),
            'mail_slot': np.array([0.25,0.02,0.15]),
            'mailbox_(at_home)': np.array([0.4,0.2,0.2]),
            'mallard': np.array([0.6,0.3,0.3]),
            'mallet': np.array([0.4,0.1,0.03]),
            'mammoth': np.array([5.0,2.0,3.5]),
            'manatee': np.array([4.0,1.0,2.0]),
            'mandarin_orange': np.array([0.08,0.08,0.08]),
            'manger': np.array([2.0,1.0,1.2]),
            'manhole': np.array([1.0,1.0,0.5]),
            'map': np.array([0.6,0.03,0.9]),
            'marker': np.array([0.02,0.02,0.15]),
            'martini': np.array([0.12,0.12,0.16]),
            'mascot': np.array([0.5,0.3,1.2]),
            'mashed_potato': np.array([0.09,0.09,0.06]),
            'masher': np.array([0.3,0.08,0.08]),
            'mask': np.array([0.25,0.15,0.1]),
            'mast': np.array([0.3,0.3,5.0]),
            'mat_(gym_equipment)': np.array([1.0,0.5,1.5]),
            'matchbox': np.array([0.05,0.03,0.015]),
            'mattress': np.array([2.0,1.5,0.25]),
            'measuring_cup': np.array([0.15,0.15,0.1]),
            'measuring_stick': np.array([1.0,0.02,0.02]),
            'meatball': np.array([0.04,0.04,0.04]),
            'medicine': np.array([0.02,0.02,0.07]),
            'melon': np.array([0.3,0.2,0.2]),
            'microphone': np.array([0.05,0.05,0.2]),
            'microscope': np.array([0.2,0.15,0.3]),
            'microwave_oven': np.array([0.6,0.4,0.4]),
            'milestone': np.array([0.6,0.3,1.0]),
            'milk': np.array([0.1,0.1,0.3]),
            'milk_can': np.array([0.1,0.1,0.2]),
            'milkshake': np.array([0.1,0.1,0.2]),
            'minivan': np.array([4.6,2.0,2.0]),
            'mint_candy': np.array([0.02,0.01,0.01]),
            'mirror': np.array([0.5,0.02,1.5]),
            'mitten': np.array([0.25,0.1,0.15]),
            'mixer_(kitchen_tool)': np.array([0.4,0.3,0.3]),
            'money': np.array([0.15,0.065,0.001]),
            'monitor_(computer_equipment)_computer_monitor': np.array([0.5,0.03,0.3]),
            'monkey': np.array([0.3,0.2,0.5]),
            'motor': np.array([0.5,0.25,0.35]),
            'motor_scooter': np.array([2.0,0.6,1.0]),
            'motor_vehicle': np.array([0.5,0.25,0.35]),
            'motorcycle': np.array([2.2,0.8,1.15]),
            'mound_(baseball)': np.array([0.073,0.073,0.073]),
            'mouse_(computer_equipment)': np.array([0.075,0.04,0.025]),
            'mousepad': np.array([0.3,0.25,0.005]),
            'muffin': np.array([0.08,0.08,0.05]),
            'mug': np.array([0.12,0.09,0.13]),
            'mushroom': np.array([0.05,0.05,0.08]),
            'music_stool': np.array([0.4,0.4,0.5]),
            'musical_instrument': np.array([1.5,0.5,0.2]),
            'nailfile': np.array([0.15,0.02,0.02]),
            'napkin': np.array([0.2,0.2,0.01]),
            'neckerchief': np.array([0.6,0.6,0.01]),
            'necklace': np.array([0.1,0.1,0.01]),
            'necktie': np.array([1.45,0.06,0.003]),
            'needle': np.array([0.05,0.001,0.001]),
            'nest': np.array([0.3,0.3,0.15]),
            'newspaper': np.array([0.3,0.4,0.005]),
            'newsstand': np.array([2.0,1.2,2.5]),
            'nightshirt': np.array([0.7,0.01,0.85]),
            'nosebag_(for_animals)': np.array([0.3,0.2,0.2]),
            'noseband_(for_animals)': np.array([0.2,0.1,0.05]),
            'notebook': np.array([0.25,0.175,0.025]),
            'notepad': np.array([0.2,0.1,0.02]),
            'nut': np.array([0.01,0.01,0.01]),
            'nutcracker': np.array([0.07,0.07,0.2]),
            'oar': np.array([2.0,0.15,0.05]),
            'octopus_(food)': np.array([0.7,0.3,0.2]),
            'octopus_(animal)': np.array([0.7,0.3,0.2]),
            'oil_lamp': np.array([0.25,0.25,0.35]),
            'olive_oil': np.array([0.08,0.08,0.25]),
            'omelet': np.array([0.15,0.15,0.03]),
            'onion': np.array([0.1,0.1,0.1]),
            'orange_(fruit)': np.array([0.08,0.08,0.08]),
            'orange_juice': np.array([0.1,0.1,0.2]),
            'ostrich': np.array([2.5,0.6,2.7]),
            'ottoman': np.array([0.6,0.6,0.4]),
            'oven': np.array([0.6,0.65,0.85]),
            'overalls_(clothing)': np.array([1.0,0.5,0.02]),
            'owl': np.array([0.4,0.2,0.25]),
            'packet': np.array([0.18,0.12,0.02]),
            'inkpad': np.array([0.07,0.05,0.02]),
            'pad': np.array([0.13,0.07,0.01]),
            'paddle': np.array([1.8,0.15,0.03]),
            'padlock': np.array([0.1,0.05,0.15]),
            'paintbrush': np.array([0.2,0.02,0.02]),
            'painting': np.array([1.5,0.02,1.0]),
            'pajamas': np.array([0.6,0.3,0.05]),
            'palette': np.array([0.5,0.35,0.02]),
            'pan_(for_cooking)': np.array([0.3,0.2,0.1]),
            'pan_(metal_container)': np.array([0.3,0.2,0.15]),
            'pancake': np.array([0.2,0.2,0.03]),
            'pantyhose': np.array([1.0,0.2,0.1]),
            'papaya': np.array([0.2,0.15,0.15]),
            'paper_plate': np.array([0.23,0.23,0.02]),
            'paper_towel': np.array([0.2,0.2,0.1]),
            'paperback_book': np.array([0.2,0.13,0.02]),
            'paperweight': np.array([0.15,0.15,0.2]),
            'parachute': np.array([3.0,3.0,0.2]),
            'parakeet': np.array([0.1,0.1,0.15]),
            'parasail_(sports)': np.array([4.0,4.0,1.0]),
            'parasol': np.array([2.0,2.0,2.5]),
            'parchment': np.array([0.3,0.2,0.01]),
            'parka': np.array([0.8,0.8,0.2]),
            'parking_meter': np.array([0.6,0.3,0.15]),
            'parrot': np.array([0.1,0.1,0.3]),
            'passenger_car_(part_of_a_train)': np.array([5.0,2.0,1.5]),
            'passenger_ship': np.array([240.0,30.0,60.0]),
            'passport': np.array([0.125,0.091,0.001]),
            'pastry': np.array([0.1,0.1,0.05]),
            'patty_(food)': np.array([0.1,0.1,0.03]),
            'pea_(food)': np.array([0.01,0.01,0.01]),
            'peach': np.array([0.08,0.08,0.08]),
            'peanut_butter': np.array([0.1,0.1,0.15]),
            'pear': np.array([0.1,0.08,0.08]),
            'peeler_(tool_for_fruit_and_vegetables)': np.array([0.15,0.05,0.01]),
            'wooden_leg': np.array([0.85,0.1,0.1]),
            'pegboard': np.array([2.0,0.01,1.0]),
            'pelican': np.array([1.6,0.5,0.8]),
            'pen': np.array([0.15,0.01,0.01]),
            'pencil': np.array([0.175,0.007,0.007]),
            'pencil_box': np.array([0.2,0.08,0.03]),
            'pencil_sharpener': np.array([0.12,0.06,0.1]),
            'pendulum': np.array([0.01,0.01,1.0]),
            'penguin': np.array([0.3,0.2,0.9]),
            'pennant': np.array([1.0,0.5,0.01]),
            'penny_(coin)': np.array([0.019,0.019,0.0015]),
            'pepper': np.array([0.04,0.04,0.1]),
            'pepper_mill': np.array([0.06,0.06,0.3]),
            'perfume': np.array([0.07,0.07,0.12]),
            'persimmon': np.array([0.08,0.08,0.09]),
            'person': np.array([0.45,0.6,1.8]),
            'pet': np.array([0.5,0.3,0.25]),
            'pew_(church_bench)': np.array([2.0,0.5,1.0]),
            'phonebook': np.array([0.2,0.04,0.3]),
            'phonograph_record': np.array([0.3,0.3,0.02]),
            'piano': np.array([1.5,0.6,1.2]),
            'pickle': np.array([0.02,0.02,0.1]),
            'pickup_truck': np.array([5.5,2.0,1.8]),
            'pie': np.array([0.3,0.3,0.05]),
            'pigeon': np.array([0.3,0.15,0.15]),
            'piggy_bank': np.array([0.15,0.1,0.2]),
            'pillow': np.array([0.5,0.5,0.15]),
            'pin_(non_jewelry)': np.array([0.1,0.1,0.1]),
            'pineapple': np.array([0.12,0.12,0.2]),
            'pinecone': np.array([0.1,0.1,0.2]),
            'ping-pong_ball': np.array([0.04,0.04,0.04]),
            'pinwheel': np.array([0.3,0.3,0.6]),
            'tobacco_pipe': np.array([0.15,0.04,0.05]),
            'pipe': np.array([1.0,0.1,0.1]),
            'pistol': np.array([0.25,0.04,0.15]),
            'pita_(bread)': np.array([0.12,0.12,0.02]),
            'pitcher_(vessel_for_liquid)': np.array([0.2,0.13,0.3]),
            'pitchfork': np.array([1.5,0.3,0.05]),
            'pizza': np.array([0.3,0.3,0.02]),
            'place_mat': np.array([0.45,0.3,0.01]),
            'plate': np.array([0.2,0.2,0.02]),
            'platter': np.array([0.3,0.3,0.05]),
            'playpen': np.array([1.0,1.0,0.6]),
            'pliers': np.array([0.1,0.03,0.02]),
            'plow_(farm_equipment)': np.array([3.0,1.5,2.0]),
            'plume': np.array([0.02,0.02,0.1]),
            'pocket_watch': np.array([0.05,0.01,0.06]),
            'pocketknife': np.array([0.15,0.02,0.005]),
            'poker_(fire_stirring_tool)': np.array([0.9,0.6,0.02]),
            'pole': np.array([0.1,0.1,3.0]),
            'polo_shirt': np.array([0.6,0.5,0.03]),
            'poncho': np.array([1.0,1.5,0.02]),
            'pony': np.array([1.5,0.5,1.2]),
            'pool_table': np.array([2.2,1.2,0.8]),
            'pop_(soda)': np.array([0.07,0.07,0.15]),
            'postbox_(public)': np.array([0.35,0.35,1.5]),
            'postcard': np.array([0.14,0.09,0.001]),
            'poster': np.array([0.6,0.01,0.9]),
            'pot': np.array([0.3,0.3,0.2]),
            'flowerpot': np.array([0.4,0.4,0.6]),
            'potato': np.array([0.1,0.08,0.05]),
            'potholder': np.array([0.2,0.2,0.03]),
            'pottery': np.array([0.3,0.3,0.4]),
            'pouch': np.array([0.2,0.01,0.15]),
            'power_shovel': np.array([6.0,3.0,5.0]),
            'prawn': np.array([0.025,0.008,0.005]),
            'pretzel': np.array([0.15,0.12,0.04]),
            'printer': np.array([0.4,0.4,0.3]),
            'projectile_(weapon)': np.array([0.2,0.2,0.2]),
            'projector': np.array([0.3,0.3,0.1]),
            'propeller': np.array([1.5,0.05,0.05]),
            'prune': np.array([0.05,0.05,0.05]),
            'pudding': np.array([0.1,0.1,0.05]),
            'puffer_(fish)': np.array([0.3,0.2,0.15]),
            'puffin': np.array([0.1,0.1,0.2]),
            'pug-dog': np.array([0.6,0.4,0.35]),
            'pumpkin': np.array([0.3,0.3,0.3]),
            'puncher': np.array([0.15,0.05,0.05]),
            'puppet': np.array([0.15,0.1,0.3]),
            'puppy': np.array([0.3,0.15,0.2]),
            'quesadilla': np.array([0.15,0.15,0.02]),
            'quiche': np.array([0.2,0.2,0.05]),
            'quilt': np.array([2.5,2.0,0.2]),
            'rabbit': np.array([0.3,0.15,0.2]),
            'race_car': np.array([4.0,1.8,1.2]),
            'racket': np.array([0.7,0.25,0.03]),
            'radar': np.array([2.5,2.5,2.0]),
            'radiator': np.array([1.0,0.25,0.75]),
            'radio_receiver': np.array([0.3,0.2,0.2]),
            'radish': np.array([0.05,0.05,0.1]),
            'raft': np.array([2.0,1.5,0.2]),
            'rag_doll': np.array([0.3,0.1,0.5]),
            'raincoat': np.array([1.0,0.8,0.02]),
            'ram_(animal)': np.array([1.8,0.75,1.0]),
            'raspberry': np.array([0.02,0.02,0.02]),
            'rat': np.array([0.3,0.1,0.15]),
            'razorblade': np.array([0.05,0.02,0.001]),
            'reamer_(juicer)': np.array([0.3,0.05,0.05]),
            'rearview_mirror': np.array([0.25,0.1,0.15]),
            'receipt': np.array([0.15,0.01,0.001]),
            'recliner': np.array([1.0,0.9,1.0]),
            'record_player': np.array([0.42,0.37,0.16]),
            'reflector': np.array([0.3,0.05,0.3]),
            'remote_control': np.array([0.18,0.05,0.02]),
            'rhinoceros': np.array([4.0,2.0,2.1]),
            'rib_(food)': np.array([0.3,0.06,0.02]),
            'rifle': np.array([1.1,0.06,0.03]),
            'ring': np.array([0.02,0.02,0.01]),
            'river_boat': np.array([30.0,6.0,10.0]),
            'road_map': np.array([0.1,0.05,0.01]),
            'robe': np.array([1.2,0.7,0.3]),
            'rocking_chair': np.array([0.8,1.2,1.0]),
            'rodent': np.array([0.2,0.1,0.1]),
            'roller_skate': np.array([0.2,0.1,0.15]),
            'Rollerblade': np.array([0.3,0.1,0.2]),
            'rolling_pin': np.array([0.4,0.04,0.04]),
            'root_beer': np.array([0.07,0.07,0.3]),
            'router_(computer_equipment)': np.array([0.2,0.15,0.04]),
            'rubber_band': np.array([0.05,0.05,0.005]),
            'runner_(carpet)': np.array([3.0,2.0,0.02]),
            'plastic_bag': np.array([0.3,0.15,0.6]),
            'saddle_(on_an_animal)': np.array([0.41,0.3,0.2]),
            'saddle_blanket': np.array([1.0,0.75,0.05]),
            'saddlebag': np.array([0.5,0.2,0.4]),
            'safety_pin': np.array([0.05,0.01,0.01]),
            'sail': np.array([4.0,0.01,6.0]),
            'salad': np.array([0.25,0.25,0.1]),
            'salad_plate': np.array([0.25,0.25,0.05]),
            'salami': np.array([0.2,0.2,0.04]),
            'salmon_(fish)': np.array([0.8,0.3,0.2]),
            'salmon_(food)': np.array([0.8,0.3,0.2]),
            'salsa': np.array([0.1,0.1,0.05]),
            'saltshaker': np.array([0.05,0.05,0.1]),
            'sandal_(type_of_shoe)': np.array([0.3,0.11,0.1]),
            'sandwich': np.array([0.15,0.15,0.05]),
            'satchel': np.array([0.4,0.1,0.3]),
            'saucepan': np.array([0.3,0.3,0.15]),
            'saucer': np.array([0.15,0.15,0.02]),
            'sausage': np.array([0.15,0.15,0.025]),
            'sawhorse': np.array([0.9,0.3,0.7]),
            'saxophone': np.array([0.1,0.3,0.7]),
            'scale_(measuring_instrument)': np.array([1.5,0.5,0.2]),
            'scarecrow': np.array([0.5,0.5,1.8]),
            'scarf': np.array([1.5,0.3,0.02]),
            'school_bus': np.array([12.0,3.0,3.5]),
            'scissors': np.array([0.15,0.05,0.02]),
            'scoreboard': np.array([2.0,0.05,1.5]),
            'scraper': np.array([0.1,0.05,0.15]),
            'screwdriver': np.array([0.1,0.01,0.01]),
            'scrubbing_brush': np.array([0.12,0.05,0.04]),
            'sculpture': np.array([1.0,0.3,1.8]),
            'seabird': np.array([0.2,0.2,0.05]),
            'seahorse': np.array([0.1,0.025,0.25]),
            'seaplane': np.array([10.0,15.0,4.0]),
            'seashell': np.array([0.1,0.1,0.05]),
            'sewing_machine': np.array([0.4,0.4,0.3]),
            'shaker': np.array([0.05,0.05,0.2]),
            'shampoo': np.array([0.08,0.08,0.25]),
            'shark': np.array([4.0,1.0,1.0]),
            'sharpener': np.array([0.05,0.03,0.04]),
            'Sharpie': np.array([0.14,0.01,0.01]),
            'shaver_(electric)': np.array([0.05,0.05,0.15]),
            'shaving_cream': np.array([0.05,0.05,0.15]),
            'shawl': np.array([2.0,1.0,0.01]),
            'shears': np.array([0.2,0.05,0.05]),
            'sheep': np.array([1.0,0.5,0.7]),
            'shepherd_dog': np.array([0.9,0.3,0.6]),
            'sherbert': np.array([0.1,0.1,0.12]),
            'shield': np.array([0.6,0.4,0.1]),
            'shirt': np.array([0.6,0.5,0.2]),
            'shoe': np.array([0.3,0.1,0.12]),
            'shopping_bag': np.array([0.5,0.15,0.35]),
            'shopping_cart': np.array([1.0,0.6,1.0]),
            'short_pants': np.array([0.5,0.3,0.01]),
            'shot_glass': np.array([0.04,0.04,0.07]),
            'shoulder_bag': np.array([0.5,0.2,0.3]),
            'shovel': np.array([1.5,0.2,0.1]),
            'shower_head': np.array([0.1,0.1,0.15]),
            'shower_cap': np.array([0.3,0.2,0.15]),
            'shower_curtain': np.array([1.8,0.2,2.2]),
            'shredder_(for_paper)': np.array([0.6,0.4,0.7]),
            'signboard': np.array([1.5,0.05,1.0]),
            'silo': np.array([10.0,10.0,30.0]),
            'sink': np.array([0.6,0.5,0.35]),
            'skateboard': np.array([0.8,0.2,0.1]),
            'skewer': np.array([0.3,0.02,0.02]),
            'ski': np.array([1.8,0.1,0.02]),
            'ski_boot': np.array([0.3,0.1,0.3]),
            'ski_parka': np.array([0.8,0.6,0.1]),
            'ski_pole': np.array([1.5,0.03,0.03]),
            'skirt': np.array([0.6,0.6,0.1]),
            'skullcap': np.array([0.2,0.2,0.1]),
            'sled': np.array([1.0,0.5,0.5]),
            'sleeping_bag': np.array([2.0,0.8,0.5]),
            'sling_(bandage)': np.array([0.1,0.05,0.01]),
            'slipper_(footwear)': np.array([0.3,0.12,0.08]),
            'smoothie': np.array([0.1,0.1,0.2]),
            'snake': np.array([1.0,0.02,0.2]),
            'snowboard': np.array([1.5,0.3,0.05]),
            'snowman': np.array([1.5,1.5,2.0]),
            'snowmobile': np.array([3.0,1.5,1.5]),
            'soap': np.array([0.09,0.06,0.03]),
            'soccer_ball': np.array([0.22,0.22,0.22]),
            'sock': np.array([0.3,0.1,0.02]),
            'sofa': np.array([2.5,1.0,1.0]),
            'softball': np.array([0.1,0.1,0.1]),
            'solar_array': np.array([10.0,4.0,2.0]),
            'sombrero': np.array([0.5,0.5,0.3]),
            'soup': np.array([0.14,0.14,0.07]),
            'soup_bowl': np.array([0.14,0.14,0.07]),
            'soupspoon': np.array([0.2,0.04,0.01]),
            'sour_cream': np.array([0.1,0.1,0.05]),
            'soya_milk': np.array([0.08,0.05,0.2]),
            'space_shuttle': np.array([30.0,10.0,20.0]),
            'sparkler_(fireworks)': np.array([0.3,0.003,0.003]),
            'spatula': np.array([0.3,0.05,0.02]),
            'spear': np.array([2.0,0.02,0.02]),
            'spectacles': np.array([0.15,0.05,0.05]),
            'spice_rack': np.array([0.35,0.1,0.4]),
            'spider': np.array([0.05,0.025,0.025]),
            'crawfish': np.array([0.1,0.02,0.02]),
            'sponge': np.array([0.12,0.08,0.04]),
            'spoon': np.array([0.2,0.045,0.005]),
            'sportswear': np.array([0.2,0.15,0.05]),
            'spotlight': np.array([0.2,0.2,0.5]),
            'squid_(food)': np.array([0.6,0.1,0.4]),
            'squirrel': np.array([0.24,0.08,0.1]),
            'stagecoach': np.array([4.5,2.2,2.8]),
            'stapler_(stapling_machine)': np.array([0.15,0.06,0.04]),
            'starfish': np.array([0.3,0.3,0.05]),
            'statue_(sculpture)': np.array([1.0,0.3,1.8]),
            'steak_(food)': np.array([0.2,0.2,0.04]),
            'steak_knife': np.array([0.25,0.02,0.01]),
            'steering_wheel': np.array([0.45,0.45,0.15]),
            'stepladder': np.array([1.6,0.6,0.04]),
            'step_stool': np.array([0.4,0.3,0.2]),
            'stereo_(sound_system)': np.array([0.4,0.3,0.15]),
            'stew': np.array([0.2,0.2,0.05]),
            'stirrer': np.array([0.25,0.005,0.005]),
            'stirrup': np.array([0.15,0.05,0.2]),
            'stool': np.array([0.4,0.4,0.45]),
            'stop_sign': np.array([0.75,0.02,0.75]),
            'brake_light': np.array([0.2,0.05,0.05]),
            'stove': np.array([0.9,0.6,0.9]),
            'strainer': np.array([0.3,0.3,0.15]),
            'strap': np.array([1.0,0.01,0.01]),
            'straw_(for_drinking)': np.array([0.005,0.005,0.21]),
            'strawberry': np.array([0.03,0.03,0.02]),
            'street_sign': np.array([0.6,0.02,0.6]),
            'streetlight': np.array([0.3,0.3,3.0]),
            'string_cheese': np.array([0.15,0.015,0.015]),
            'stylus': np.array([0.1,0.01,0.01]),
            'subwoofer': np.array([0.4,0.4,0.45]),
            'sugar_bowl': np.array([0.15,0.15,0.1]),
            'sugarcane_(plant)': np.array([3.2,0.04,0.04]),
            'suit_(clothing)': np.array([0.8,0.6,0.05]),
            'sunflower': np.array([0.04,0.04,0.6]),
            'sunglasses': np.array([0.15,0.05,0.05]),
            'sunhat': np.array([0.35,0.35,0.2]),
            'surfboard': np.array([2.5,0.5,0.05]),
            'sushi': np.array([0.08,0.08,0.04]),
            'mop': np.array([1.5,0.3,0.1]),
            'sweat_pants': np.array([1.1,0.5,0.05]),
            'sweatband': np.array([0.1,0.1,0.02]),
            'sweater': np.array([0.6,0.5,0.05]),
            'sweatshirt': np.array([0.6,0.5,0.02]),
            'sweet_potato': np.array([0.1,0.05,0.1]),
            'swimsuit': np.array([0.3,0.1,0.1]),
            'sword': np.array([1.0,0.02,0.02]),
            'syringe': np.array([0.15,0.02,0.02]),
            'Tabasco_sauce': np.array([0.05,0.05,0.13]),
            'table-tennis_table': np.array([2.74,1.525,0.76]),
            'table': np.array([1.2,0.8,0.75]),
            'table_lamp': np.array([0.4,0.2,0.6]),
            'tablecloth': np.array([2.5,1.5,0.01]),
            'tachometer': np.array([0.2,0.2,0.05]),
            'taco': np.array([0.15,0.05,0.02]),
            'tag': np.array([0.06,0.04,0.001]),
            'taillight': np.array([0.2,0.1,0.1]),
            'tambourine': np.array([0.2,0.02,0.2]),
            'army_tank': np.array([6.0,3.5,2.2]),
            'tank_(storage_vessel)': np.array([7.0,3.7,2.4]),
            'tank_top_(clothing)': np.array([0.3,0.3,0.05]),
            'tape_(sticky_cloth_or_paper)': np.array([0.01,0.01,0.05]),
            'tape_measure': np.array([0.1,0.1,0.05]),
            'tapestry': np.array([2.0,1.5,0.01]),
            'tarp': np.array([6.0,8.0,0.02]),
            'tartan': np.array([1.5,1.0,0.02]),
            'tassel': np.array([0.02,0.02,0.1]),
            'tea_bag': np.array([0.05,0.02,0.01]),
            'teacup': np.array([0.1,0.1,0.08]),
            'teakettle': np.array([0.2,0.12,0.24]),
            'teapot': np.array([0.3,0.2,0.2]),
            'teddy_bear': np.array([0.3,0.2,0.4]),
            'telephone': np.array([0.2,0.2,0.2]),
            'telephone_booth': np.array([1.0,1.0,2.5]),
            'telephone_pole': np.array([0.4,0.4,8.0]),
            'telephoto_lens': np.array([0.1,0.1,0.15]),
            'television_camera': np.array([0.6,0.6,0.5]),
            'television_set': np.array([1.2,0.2,0.7]),
            'tennis_ball': np.array([0.07,0.07,0.07]),
            'tennis_racket': np.array([0.3,0.01,0.7]),
            'tequila': np.array([0.08,0.08,0.3]),
            'thermometer': np.array([0.1,0.02,0.02]),
            'thermos_bottle': np.array([0.07,0.07,0.25]),
            'thermostat': np.array([0.15,0.03,0.22]),
            'thimble': np.array([0.02,0.02,0.03]),
            'thread': np.array([0.02,0.02,0.06]),
            'thumbtack': np.array([0.015,0.015,0.025]),
            'tiara': np.array([0.14,0.14,0.06]),
            'tiger': np.array([3.0,0.8,1.0]),
            'tights_(clothing)': np.array([1.0,0.2,0.02]),
            'timer': np.array([0.08,0.08,0.05]),
            'tinfoil': np.array([0.3,0.3,0.01]),
            'tinsel': np.array([0.5,0.5,0.01]),
            'tissue_paper': np.array([0.1,0.1,0.05]),
            'toast_(food)': np.array([0.1,0.1,0.03]),
            'toaster': np.array([0.3,0.2,0.2]),
            'toaster_oven': np.array([0.45,0.33,0.25]),
            'toilet': np.array([0.7,0.6,0.8]),
            'toilet_tissue': np.array([0.12,0.12,0.11]),
            'tomato': np.array([0.07,0.07,0.07]),
            'tongs': np.array([0.3,0.05,0.05]),
            'toolbox': np.array([0.6,0.3,0.2]),
            'toothbrush': np.array([0.02,0.01,0.17]),
            'toothpaste': np.array([0.02,0.02,0.15]),
            'toothpick': np.array([0.05,0.005,0.005]),
            'cover': np.array([0.45,0.35,0.15]),
            'tortilla': np.array([0.2,0.2,0.01]),
            'tow_truck': np.array([8.0,2.5,3.0]),
            'towel': np.array([1.5,0.75,0.02]),
            'towel_rack': np.array([0.6,0.15,0.8]),
            'toy': np.array([0.2,0.2,0.2]),
            'tractor_(farm_equipment)': np.array([4.0,2.5,2.5]),
            'traffic_light': np.array([0.3,0.3,1.2]),
            'dirt_bike': np.array([1.85,0.65,1.15]),
            'trailer_truck': np.array([8.0,2.5,3.7]),
            'train_(railroad_vehicle)': np.array([15.0,3.0,4.5]),
            'trampoline': np.array([3.7,3.7,0.9]),
            'tray': np.array([0.4,0.3,0.05]),
            'trench_coat': np.array([1.0,0.6,0.1]),
            'triangle_(musical_instrument)': np.array([0.3,0.3,0.01]),
            'tricycle': np.array([1.5,0.8,0.9]),
            'tripod': np.array([0.7,0.7,1.5]),
            'trousers': np.array([1.1,0.5,0.01]),
            'truck': np.array([6.0,2.5,2.0]),
            'truffle_(chocolate)': np.array([0.05,0.05,0.05]),
            'trunk': np.array([1.0,0.6,0.5]),
            'vat': np.array([1.2,1.2,1.5]),
            'turban': np.array([0.3,0.3,0.15]),
            'turkey_(food)': np.array([1.0,0.6,1.0]),
            'turnip': np.array([0.08,0.08,0.15]),
            'turtle': np.array([0.6,0.45,0.2]),
            'turtleneck_(clothing)': np.array([0.6,0.5,0.02]),
            'typewriter': np.array([0.4,0.3,0.2]),
            'umbrella': np.array([1.0,1.0,1.0]),
            'underwear': np.array([0.3,0.2,0.1]),
            'unicycle': np.array([1.0,0.5,1.2]),
            'urinal': np.array([0.6,0.5,1.1]),
            'urn': np.array([0.3,0.3,0.5]),
            'vacuum_cleaner': np.array([1.2,0.4,0.4]),
            'vase': np.array([0.2,0.2,0.4]),
            'vending_machine': np.array([1.2,0.8,2.0]),
            'vent': np.array([0.3,0.3,0.1]),
            'vest': np.array([0.5,0.2,0.3]),
            'videotape': np.array([0.2,0.13,0.02]),
            'vinegar': np.array([0.09,0.09,0.25]),
            'violin': np.array([0.6,0.2,0.05]),
            'vodka': np.array([0.1,0.1,0.3]),
            'volleyball': np.array([0.22,0.22,0.22]),
            'vulture': np.array([1.0,2.5,0.5]),
            'waffle': np.array([0.18,0.18,0.02]),
            'waffle_iron': np.array([0.3,0.2,0.1]),
            'wagon': np.array([2.5,1.0,0.8]),
            'wagon_wheel': np.array([1.0,1.0,0.1]),
            'walking_stick': np.array([1.0,0.02,0.02]),
            'wall_clock': np.array([0.3,0.3,0.05]),
            'wall_socket': np.array([0.1,0.05,0.15]),
            'wallet': np.array([0.2,0.1,0.02]),
            'walrus': np.array([3.2,1.0,1.5]),
            'wardrobe': np.array([2.0,1.0,2.0]),
            'washbasin': np.array([0.6,0.45,0.3]),
            'automatic_washer': np.array([0.65,0.65,0.85]),
            'watch': np.array([0.05,0.005,0.01]),
            'water_bottle': np.array([0.07,0.07,0.2]),
            'water_cooler': np.array([1.0,0.4,0.4]),
            'water_faucet': np.array([0.13,0.13,0.2]),
            'water_heater': np.array([0.75,0.4,1.2]),
            'water_jug': np.array([0.1,0.1,0.2]),
            'water_gun': np.array([0.3,0.1,0.15]),
            'water_scooter': np.array([2.5,1.0,1.2]),
            'water_ski': np.array([1.7,0.15,0.05]),
            'water_tower': np.array([10.0,10.0,20.0]),
            'watering_can': np.array([0.3,0.3,0.5]),
            'watermelon': np.array([0.3,0.2,0.2]),
            'weathervane': np.array([0.5,0.5,1.0]),
            'webcam': np.array([0.1,0.05,0.05]),
            'wedding_cake': np.array([0.75,0.75,0.5]),
            'wedding_ring': np.array([0.02,0.02,0.01]),
            'wet_suit': np.array([1.0,0.5,0.1]),
            'wheel': np.array([0.5,0.5,0.2]),
            'wheelchair': np.array([1.1,0.65,0.9]),
            'whipped_cream': np.array([0.1,0.1,0.15]),
            'whistle': np.array([0.05,0.02,0.02]),
            'wig': np.array([0.2,0.2,0.15]),
            'wind_chime': np.array([0.08,0.08,0.6]),
            'windmill': np.array([10.0,4.0,15.0]),
            'window_box_(for_plants)': np.array([1.0,0.2,0.5]),
            'windshield_wiper': np.array([0.7,0.02,0.02]),
            'windsock': np.array([1.0,0.1,0.25]),
            'wine_bottle': np.array([0.1,0.1,0.3]),
            'wine_bucket': np.array([0.3,0.3,0.4]),
            'wineglass': np.array([0.08,0.08,0.2]),
            'blinder_(for_horses)': np.array([0.2,0.05,0.1]),
            'wok': np.array([0.35,0.35,0.1]),
            'wolf': np.array([1.5,0.3,0.8]),
            'wooden_spoon': np.array([0.3,0.05,0.02]),
            'wreath': np.array([0.6,0.6,0.1]),
            'wrench': np.array([0.3,0.05,0.02]),
            'wristband': np.array([0.07,0.05,0.01]),
            'wristlet': np.array([0.07,0.007,0.007]),
            'yacht': np.array([20.0,5.0,9.0]),
            'yogurt': np.array([0.08,0.08,0.12]),
            'yoke_(animal_equipment)': np.array([0.6,0.2,0.3]),
            'zebra': np.array([2.5,0.5,1.4]),
            'zucchini': np.array([0.02,0.02,0.2])
            }
        

        import pickle
        # with open('meansize_5k.pkl', 'rb') as file:
        #     self.type_mean_size = pickle.load(file)
        self.mean_size_arr = np.zeros((self.num_size_cluster, 3))
        for i in range(self.num_size_cluster):
            self.mean_size_arr[i,:] = self.type_mean_size[self.class2type[i]]
        
        #testing set
        self.num_eval_class = 20 #change this 
        self.type2class_eval ={'toilet': 0, 'bed': 1, 'chair': 2, 'bathtub': 3, 'sofa': 4, 'dresser': 5, 'scanner': 6, 'fridge': 7, 'lamp': 8, 'desk': 9, 'table': 10, 'stand': 11, 'cabinet': 12, 'counter': 13, 'bin': 14, 'bookshelf': 15, 'pillow': 16, 'microwave': 17, 'sink': 18, 'stool': 19}
        self.class2type_eval = {self.type2class_eval[t]:t for t in self.type2class_eval}
        #change this 
        self.type_mean_size_eval = {
                                'toilet' : np.array([0.697272, 0.454178, 0.75625]),
                                'bed' : np.array([2.115816, 1.621716, 0.936364]),
                                'chair' : np.array([0.592329, 0.552978, 0.827272]),
                                'bathtub' : np.array([0.767272, 1.398258, 0.45663]),
                                'sofa' : np.array([0.924369, 1.8750179999999999, 0.847046]),
                                'dresser' : np.array([0.528526, 1.0013420000000002, 1.183333]),
                                'scanner' : np.array([0.707552, 0.686108, 0.954546]),
                                'fridge' : np.array([0.732086, 0.7546, 1.65]),
                                'lamp' : np.array([0.367022, 0.379614, 0.69091]),
                                'desk' : np.array([0.68826, 1.337694, 0.7375]),
                                'table' : np.array([0.792666, 1.285808, 0.718182]),
                                'stand' : np.array([0.36723799999999995, 0.46594599999999997, 0.9227270000000001]),
                                'cabinet' : np.array([0.571631, 1.214407, 0.963636]),
                                'counter' : np.array([0.760644, 2.23633, 0.85]),
                                'bin' : np.array([0.297542, 0.356406, 0.75909]),
                                'bookshelf' : np.array([0.40298500000000004, 1.063498, 1.727273]),
                                'pillow' : np.array([0.355497, 0.56077, 0.318182]),
                                'microwave' : np.array([0.394077, 0.5639620000000001, 0.327272]),
                                'sink' : np.array([0.502248, 0.599351, 0.457344]),
                                'stool' : np.array([0.409797, 0.411632, 0.681818])}
        
        self.mean_size_arr_eval = np.zeros((self.num_eval_class, 3))
        for i in range(self.num_eval_class):
            self.mean_size_arr_eval[i,:] = self.type_mean_size_eval[self.class2type_eval[i]]
    def size2class(self, size, type_name):
        ''' Convert 3D box size (l,w,h) to size class and size residual '''
    
        size_class = self.type2class[type_name]
        size_residual = size - self.type_mean_size[type_name]    
        
        return size_class, size_residual
    def size2class_eval(self, size, type_name):
        ''' Convert 3D box size (l,w,h) to size class and size residual '''

        size_class = self.type2class_eval[type_name]
        size_residual = size - self.type_mean_size_eval[type_name]
        
        return size_class, size_residual
    
    def class2size(self, pred_cls, residual):
        ''' Inverse function to size2class '''
        mean_size = self.type_mean_size[self.class2type[pred_cls]]

        return mean_size + residual
    
    def class2size_eval(self, pred_cls, residual):
        ''' Inverse function to size2class '''
        mean_size = self.type_mean_size_eval[self.class2type_eval[pred_cls]]
        return mean_size + residual
    
    
    def angle2class(self, angle):
        ''' Convert continuous angle to discrete class
            [optinal] also small regression number from  
            class center angle to current angle.
           
            angle is from 0-2pi (or -pi~pi), class center at 0, 1*(2pi/N), 2*(2pi/N) ...  (N-1)*(2pi/N)
            return is class of int32 of 0,1,...,N-1 and a number such that
                class*(2pi/N) + number = angle
        '''
        num_class = self.num_heading_bin
        angle = angle%(2*np.pi)
        assert(angle>=0 and angle<=2*np.pi)
        angle_per_class = 2*np.pi/float(num_class)
        shifted_angle = (angle+angle_per_class/2)%(2*np.pi)
        class_id = int(shifted_angle/angle_per_class)
        residual_angle = shifted_angle - (class_id*angle_per_class+angle_per_class/2)
        return class_id, residual_angle
    
    def class2angle(self, pred_cls, residual, to_label_format=True):
        ''' Inverse function to angle2class '''
        num_class = self.num_heading_bin
        angle_per_class = 2*np.pi/float(num_class)
        angle_center = pred_cls * angle_per_class
        angle = angle_center + residual
        if to_label_format and angle>np.pi:
            angle = angle - 2*np.pi
        return angle

    def param2obb(self, center, heading_class, heading_residual, size_class, size_residual):
        heading_angle = self.class2angle(heading_class, heading_residual)
        box_size = self.class2size(int(size_class), size_residual)
        obb = np.zeros((7,))
        obb[0:3] = center
        obb[3:6] = box_size
        obb[6] = heading_angle*-1
        return obb
    
    def param2obb_eval(self, center, heading_class, heading_residual, size_class, size_residual):
        heading_angle = self.class2angle(heading_class, heading_residual)
        box_size = self.class2size_eval(int(size_class), size_residual)
        obb = np.zeros((7,))
        obb[0:3] = center
        obb[3:6] = box_size
        obb[6] = heading_angle*-1
        return obb
    


