# Running Instructions


## Benchmark Datasets and Preprocessing
Please download datasets from [here](https://zenodo.org/record/7213796#.Y1cO6y8r30o).  and put them in ```DG_data``` folder. 

We can run ```preprocess_data/preprocess_data.py``` for pre-processing the datasets.
For example, to preprocess the *Wikipedia* dataset, we can run the following commands:

```{bash}
cd preprocess_data/
python preprocess_data.py  --dataset_name wikipedia
```
We can also run the following commands to preprocess all the original datasets at once:
```{bash}
cd preprocess_data/
python preprocess_all_data.py
```


## Environments
[PyTorch 1.8.1](https://pytorch.org/), 
[numpy](https://github.com/numpy/numpy),
[pandas](https://github.com/pandas-dev/pandas),
[tqdm](https://github.com/tqdm/tqdm), and 
[tabulate](https://github.com/astanin/python-tabulate)


## Executing Scripts
### Scripts for Dynamic Link Prediction

Dynamic link prediction could be performed on all the thirteen datasets. 
If you want to load the best model configurations determined by the grid search, please set the *load_best_configs* argument to True.

#### Model Training
```{bash}
python train_link_prediction.py --dataset_name wikipedia --model_name RPNet --load_best_configs --num_runs 5 --gpu 0
```
#### Model Evaluation
Three (i.e., random, historical, and inductive) negative sampling strategies can be used for model evaluation.
* Example of evaluating *TPNet* with *random* negative sampling strategy on *Wikipedia* dataset:
```{bash}
python evaluate_link_prediction.py --dataset_name wikipedia --model_name RPNet --load_best_configs --negative_sample_strategy random --num_runs 5 --gpu 0
```
