import random

import numpy as np
import torch


__all__ = [
    "fix_seed"
]

def fix_seed(seed: int):
    # set seed.
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.backends.cudnn.deterministic = True 
