import logging
import sys

sys.path.append("..")

from cvpods.layers import ShapeSpec
from cvpods.modeling.backbone import Backbone
from cvpods.modeling.backbone import build_resnet_backbone
from cvpods.modeling.anchor_generator import DefaultAnchorGenerator

from cvpods.modeling.meta_arch.yolof import YOLOF
from cvpods.modeling.roi_heads.yolof_enc_dec import build_encoder, build_decoder


def build_backbone(cfg, input_shape=None):
    """
    Build a backbone from `cfg.MODEL.BACKBONE.NAME`.
    Returns:
        an instance of :class:`Backbone`
    """
    if input_shape is None:
        input_shape = ShapeSpec(channels=len(cfg.MODEL.PIXEL_MEAN))

    backbone = build_resnet_backbone(cfg, input_shape)
    assert isinstance(backbone, Backbone)
    return backbone


def build_anchor_generator(cfg, input_shape):
    return DefaultAnchorGenerator(cfg, input_shape)


def build_model(cfg):
    cfg.build_backbone = build_backbone
    cfg.build_anchor_generator = build_anchor_generator
    cfg.build_encoder = build_encoder
    cfg.build_decoder = build_decoder
    model = YOLOF(cfg)

    logger = logging.getLogger(__name__)
    logger.info("Model:\n{}".format(model))
    return model
