# Exploring Consistency in Graph Representations:from Graph Kernels to Graph Neural Networks

This repository contains the code of 'Exploring Consistency in Graph Representations:from Graph Kernels to Graph Neural Networks'.



## Environment Setup

To run the code, you need to set up a virtual environment and install the required dependencies.

```cmd
conda env create -f environment.yml
```



## Effectiveness of consistent training

Before the experiments, you need to log in your wandb account or just set `--wandb_disabled`.  

To test the performances of models without consistent learning:

```cmd
bash ./run.sh
```



To test the performances of models with consistent learning:

```cmd
bash ./run_dist.sh
```



To show the results:

```cmd
python show_data.py
```



## Effectiveness of consistency loss

To perform the similarity test, run:

```cmd
python similarity_test.py
```



and then run:

```cmd
python correlation.py
```

to analyze the correlation and generate the results.