import sys
import queue
import copy
import re

f_type_name = {
    "undef" : -1,
    "raw balance" :0,
    "net balance" :1,
    "accrued balance" :2,
    "final balance" :3,
    "compound fee ratio (t)" : 10,
    "transaction fee" :11,
    "simple fee ratio" : 12,
    "transaction fee (n)" : 13,
    "transaction fee (d)" : 14,
    "simple interest ratio" : 20,
    "compound interest ratio" : 21,
    "simple interest": 22,
    "compound interest" : 23,
    "reserve" : 30,
    "price/exchange rate" : 40,
    "debt": 50,
}

f_type_num = {
    -1: "undef",
    0: "raw balance",
    1: "net balance",
    2: "accrued balance",
    3: "final balance",
    10: "compound fee ratio (t)",
    11: "transaction fee",  
    12: "simple fee ratio",
    13: "transaction fee (n)",
    14: "transaction fee (d)",
    20: "simple interest ratio",
    21: "compound interest ratio",
    22: "simple interest",
    23: "compound interest",
    30: "reserve",
    40: "price/exchange rate",
    50: "debt",
}

"""
Trace:{
self.shortfall = LLM_Set
shortfall = LLM_Set
newBalance = Fixed18Lib.from(self.balances[account]).add(amount);
shortfall = self.shortfall.add(newBalance.abs());
ERROR: self.shortfall = self.shortfall.add(shortfall);
}
Dict:{
"self.shortfall":50,
"shortfall":50,
"newBalance":0
}
"""

read_single = True      #Read single variables at a time or not
provide_feedback = False #Resolves chatgpt/user conflicts via providing feedback messages?
rerun = True           #Resolves chatgpt/user conflicts via rerunning message?

IRLLMorTFile = 0
IRGlobal = 1
IRParameter = 2
IRReturned = 3
IRHLCReturned = 4
printFull = True

search_count = 0
llm_requests = 0
used_llm_cache = False
llm_tokens = 0
llm_tokens_2 = 0

def get_llm_tokens():
    global llm_tokens
    return(llm_tokens)

def update_llm_tokens(val):
    global llm_tokens
    llm_tokens += val

def get_llm_requests():
    global llm_requests
    return llm_requests

def update_llm_requests(val = None):
    global llm_requests
    llm_requests+=1
    if val is not None:
        llm_request+=val - 1

def update_llm_tokens_2(val):
    global llm_tokens_2
    llm_tokens_2+=val

def get_llm_tokens_2():
    return(llm_tokens_2)

def set_used_llm_cache(val = None):
    global used_llm_cache
    if val is None:
        used_llm_cache = True
    else:
        used_llm_cache = val

def get_used_llm_cache():
    return used_llm_cache

def increment_search_count(val = None):
    global search_count
    search_count+=1

    if(val):
        search_count+=val-1

def get_search_count():
    return search_count

#USAGE: gets the next llm_cache name
def _get_current_cache_name():
    # Directory where cache files are stored
    directory = './llm_caches'

    if not os.path.exists(directory):
        os.makedirs(directory)
    
    # List all files in the directory
    files = os.listdir(directory)
    
    # Filter files that start with 'llm_cache_'
    cache_files = [file for file in files if file.startswith('llm_cache_')]
    
    if not cache_files:
        # If no cache files exist, return 'llm_cache_1'
        return None
    
    else:
        # Extract numbers appended to 'llm_cache_'
        numbers = [int(file.split('_')[-1]) for file in cache_files]
        
        # Find the maximum number
        max_number = max(numbers)
        
        # Increment the maximum number by one
        new_number = max_number 
        
        # Return the new cache file name
        return f'llm_cache_{new_number}'


def convert_int_ir(ir):
    if not(isinstance(ir, int)):
        return None
    if(ir == 0):
        return "LLM_Set"
    elif(ir == 1):
        return "Global"
    elif(ir == 2):
        return "Parameter"
    elif(ir == 3):
        return("Returned")
    elif(ir == 4):
        return("HLC Returned")
    
def change_print_full(value):
    global printFull
    printFull = value

def _analyze_line(_trace_line):
    trace_type = None
    trace_content = None
    is_leaf = None

    if("= LLM_Set" in _trace_line):
        is_leaf = True

    if(":" in _trace_line):
        trace_line = _trace_line.split(":")
        trace_type = trace_line[0]
        content = trace_line[1].split(" ")
        trace_content = content[1]
    else:
        has_operators = any(op in _trace_line for op in ['=', '+', '-', '*', '/'])
        if has_operators:
            trace_content = _trace_line
        else:
            trace_type = "Bad"

    return(trace_type, trace_content, is_leaf)

def process_source_trace(trace_str):
    _lines = trace_str.split("\n")
    _new_str = ""
    cur_pos = 0
    max_pos = len(_lines) - 1
    last_content = None
    for _line in _lines:
        trace_type, trace_content, is_leaf = _analyze_line(_line)

        #with open("finance_errors.txt", "a") as file:
        #    file.write("Line: {} Trace Content: {} Is leaf: {} Last Content: {}\n".format(trace_type, trace_content, is_leaf, last_content))

        if(trace_type is None or trace_content == None):
            if(is_leaf):
                leaf_name = _line.split(" = LLM_Set")[0]
                if(leaf_name == "None"):
                    if last_content is None:
                        last_line = _lines[cur_pos-1]
                        elements = re.split(r'[=+\-*/%><]', last_line)
                        # Filter out empty strings
                        elements = [elem for elem in elements if elem.strip()]
                        # Return the last element
                        _new_str += elements[-1] + " = LLM_Set\n"
                    else:
                        _new_str += last_content + " = LLM_Set\n"
                    cur_pos+=1
                    continue
            elif(_line == "None"):
                cur_pos+=1
                continue
            _new_str += _line + "\n"
        elif(trace_type == "Bad"):
            cur_pos+=1
            continue
        elif(trace_type == "Parameter"):
            if(trace_content != "None"):
                last_content = trace_content
            if(is_leaf):
                _new_str+=trace_content + ' = LLM_Set\n'
            else:
                _, ntrace_content, nis_leaf = _analyze_line(_lines[cur_pos+1])
                if nis_leaf:
                    leaf_name = _lines[cur_pos+1].split(" = LLM_Set")[0]
                    if(leaf_name == "None"):
                        cur_pos+=1
                        continue
                    else:
                        _new_str+=trace_content + ' = ' + leaf_name + '\n'
                elif(ntrace_content == None or ntrace_content == trace_content):
                    cur_pos+=1
                    continue
                else:
                    _new_str+=trace_content + ' = ' + ntrace_content + '\n'
        elif(trace_type == "Global"):
            _new_str+=trace_content + ' = LLM_Set\n'
            if(trace_content != "None"):
                last_content = trace_content
        elif(trace_type == "Returned"):
            if(trace_content != "None"):
                last_content = trace_content
            pass
        else:
            #Catch leakage, don't know how to handle yet
            eprint(trace_type)
            exit(1)
        cur_pos+=1
    return("Error: " + _new_str)

        
        
        

total_rerun_times = 0
total_feedback_times = 0
total_rerun_failures = 0
total_correctly_classified = 0
total_incorrectly_classified = 0

#USAGE: gets rerun times
def get_correctly_classified():
    global total_correctly_classified
    return total_correctly_classified

#USAGE: updates rerun times by x
def update_correctly_classified(x):
    global total_correctly_classified
    total_correctly_classified+=x

def get_incorrectly_classified():
    global total_incorrectly_classified
    return total_incorrectly_classified

def update_incorrectly_classified(x):
    global total_incorrectly_classified
    total_incorrectly_classified+=x


#USAGE: gets rerun times
def get_rerun_times():
    global total_rerun_times
    return total_rerun_times

#USAGE: updates rerun times by x
def update_rerun_times(x):
    global total_rerun_times
    total_rerun_times+=x

#USAGE: gets rerun failure (after 3) times
def get_rerun_failures():
    global total_rerun_failures
    return total_rerun_failures

#USAGE: updates rerun failures by x
def update_rerun_failures(x):
    global total_rerun_failures
    total_rerun_failures+=x

#USAGE: gets feedback times
def get_feedback_times():
    global total_feedback_times
    return total_feedback_times

#USAGE: updates feedback times by x
def update_feedback_times(x):
    global total_feedback_times
    total_feedback_times+=x

#USAGE: print to system err
def eprint(*args, **kwargs):
    return
    print(*args, file=sys.stderr, **kwargs)

#USAGE: input that has content to system err
def einput(*args, **kwargs):
    eprint(*args, **kwargs)
    return (input())

def extract_operations_source(source, file_name, start_line, end_line):
    possible_ops = []

    with open(file_name, 'r') as file:
        lines = file.readlines()[start_line - 1:end_line]
        #eprint(lines)
        #eprint(variable_names)

        _lines = re.split(r'[;{}]', ''.join(lines))

        # Remove empty strings from the list
        _lines = [_line for _line in _lines if _line]

        for _line in _lines:
            if(source in _line):
                possible_ops.append(_line)

    return possible_ops


def extract_operations(variable_names, file_name, start_line, end_line):
    # Initialize an empty list to store substrings of operations
    substrings = []
    
    # Open the file and read lines within the specified range
    if file_name is None:
        return substrings
    
    with open(file_name, 'r') as file:
        lines = file.readlines()[start_line - 1:end_line]
        #eprint(lines)
        #eprint(variable_names)

        _lines = re.split(r'[;{}]', ''.join(lines))

        # Remove empty strings from the list
        _lines = [_line for _line in _lines if _line]

       # _lines = ''.join(lines).split(';')
        
        #Parameters
        if(len(_lines) > 0):
            parameters = _lines[0]
            contains_all = False
            for var_name in variable_names:
                source_name = var_name.split('.')[0]
                if(not source_name in parameters):
                    contains_all = True
                    break
                if(not contains_all):
                    for var_name in variable_names:
                        substrings.append("{} = LLM_SET/Parameter".format(var_name))


        #v1
        for _line in _lines:
            #eprint(_line)
            assignments = _line.split('=')
            if(len(assignments) > 1):
                contains_all = False
                appears_rhs = False
                for var_name in variable_names:
                    if(not var_name in assignments[0]):
                        contains_all = True
                        break
                    
                    '''
                    else:
                        if(var_name in assignments[1]):
                            #Self set or update, ignore updates for now
                            contains_all = True
                        break
                    '''
                if(not contains_all):
                    substrings.append(_line.strip())
        '''
        # Iterate over the lines
        for line_number, line in enumerate(lines, start=start_line):
            eprint(line)
            # Split the line by the '=' sign to identify assignments
            assignments = line.split('=')
            eprint(assignments)
            # Check if there are any assignments on this line
            if len(assignments) > 1:
                # Iterate over the assignments
                for assignment in assignments[:-1]:  # Exclude the last assignment
                    # Check if any of the variable names are present on the right-hand side
                    if any(var_name in assignment for var_name in variable_names):
                        # Extract the substring containing the operation
                        substrings.append(line.strip())
    '''
    #eprint(f"Possible operations: {substrings}")
    for op in substrings:
        eprint(f"[*] {op}")
    
    return substrings

def view_queue(queue):
    temp_list = []
    str_set = set()
    eprint(queue)
    while not queue.empty():
        #eprint("~")
        item = queue.get()
        if item._expression is not None:
            eprint(item)
            str_set.add(item.__str__())
            temp_list.append(item)

    for item in temp_list:
        queue.put(item)

    return str_set

def copy_queue(original_queue, deepcopy = False):
    # Copy the contents of the original queue to a temporary list
    temp_list = []
    while not original_queue.empty():
        _item = original_queue.get()
        if(deepcopy):
            item = copy.deepcopy(_item)
        else:
            item = _item
        temp_list.append(item)

    # Repopulate the original queue and create a new queue with the same contents
    new_queue = queue.Queue()
    for item in temp_list:
        original_queue.put(item)
        new_queue.put(item)

    return (new_queue)

#USAGE: converts a string to an int, or returns False
def is_convertible_to_int(s):
    try:
        int(s)
        return int(s)
    except ValueError:
        return False
    
#USAGE: determines if a file is empty
def is_file_empty(file_path):
    with open(file_path, 'r') as file:
        return not file.read(1)
    
#USAGE: cat
def cat_file(file_path):
    with open(file_path, "r") as file:
        for line in file:
            eprint(line)

#USAGE: rm rf with mov
import shutil
import subprocess
import os

def move_to_tmp_and_delete(directory_path):
    # Create /tmp directory if it doesn't exist
    tmp_directory = "/tmp"
    if not os.path.exists(tmp_directory):
        os.makedirs(tmp_directory)
    
    # Move directory to /tmp
    shutil.move(directory_path, tmp_directory)

    # Delete directory from /tmp
    subprocess.run(["rm", "-rf", os.path.join(tmp_directory, os.path.basename(directory_path))])