from tcheck_help import f_type_name, f_type_num

assign_types_intro = """
In smart contracts written in Solidity, many variables have a financial meaning. 
Given the following financial labels of: {raw balance, price/exchange rate, simple fee ratio, complex fee ratio, fee, reserve, debt, simple interest ratio, complex interest ratio, or NONE}, 
definitions as well as a number of examples describing variables of each financial meaning will be provided. 
The format of the fewshot is as follows: Definition of financial label, Examples of financial label, where each example is made up of Code, Variables, and the Reason why the Variables have the financial label.
"""
goal =  """Given a snippet of code representing part or the entirity of a Solidity function, please output the likely candidates separated by commas for only the 'raw balance' type if there exists any. If there are more than one, please output all of them. Place priority on the function parameters as well as return values of function calls.
DO NOT MAKE ANY OTHER OUTPUT aside from the names of the relevant variables.
If there are none, output 'NONE'."""
single_goal = """
Given a variable name and a snippet of code representing part or the entirity of a Solidity function, please output the most likey financial label of the given variable as the first token of the output.
Please only output a financial label if the variable is or seems to be an integer. For bools, strings, objects, ..., the first token should be "-1".
Begin the response with the key of the financial label in the provided table.
"""

only_name_goal = """
Only given the name of the variable, return the key of the most appropriate financial label to it financial type.
Provided are some typically features of each type of financial variable:
Raw balance variables typically include in their names: "amount" or "balance".
Reserve variables typically include in their name: "reserve" or "total".
Interest rate variables typically include: "interest", "accumulation", and "rate" or "per"
Fee rate variables typically include: "fee" and "rate" or "per".
Price variables typically include: "price", "ratio", or "to".
Debt variables typically include: "debt" or "shortfall".

If none of these types can be reasonably inferred from their name, simply return "-1".
"""
#Variable name: XXX

##DO NOT MAKE ANY OTHER OUTPUT aside from the name of the single relevant variable.
#DO NOT OUTPUT THE TYPES OF ANY OTHER VARIABLE.
#If there are none, output 'NONE'.
#"""
mark_output = """
Do not make any output until a user prompt with the word BEGIN is received.
The output should be of the form `$financial_label`:`variable_name`, `$financial_label`:`variable_name`, ...
For example, if `varA` is a user balance, output `$user balance`:`varA`.
If `varB` is a fee, output `$fee`:`varB`.
"""
single_mark_output = """
Do not make any output until a user prompt with the word BEGIN is received.
The output should be of the form "financial_label":"variable_name".
For example, if `varA` is a user balance, output "user balance":"varA".
If `varB` is a fee, output "fee":"varB".
"""
clarify_output = """
Do not make any other output aside from the full name of the relevant variable surrounded by '"' characters and its corresponding type separated by a ':' character.
Do not output the reason why a variable is categorized the way it is.
The output should be easily parsable using Python code.
The output should utilize a regular expression of this form: `[raw balance|price/exchange rate|simple fee ratio|reserve|debt|simple interest ratio]":("[Variable Name]",)*END`
For example, lets say that 4 variables are found to have financial labels: VarA is raw balance, VarB is raw balance, VarC is price/exchange rate, VarD is simple fee ratio. There are no other variables with financial meaning in the code.
The output should be:
"raw balance":"VarA","VarB",END\n
"price/exchange rate":"VarC",END\n
"fee":"VarD",END\n
"reserve":END\n
"debt":END\n
"simple interest ratio":END
The variable name should be EXACTLY as it is in the function.
Nothing else should be provided in the output.
"""
single_clarify_output = """
The output should be easily parsable using Python code.
The output should include the number corresponding to one of the financial labels in this financial python dictionary as the FIRST token:
f_type_name = {
    "undef" : -1,
    "raw balance" :0,
    "net balance" :1,
    "compound fee ratio (t)" : 10,
    "simple fee ratio" : 12,
    "simple interest ratio" : 20,
    "compound interest ratio" : 21,
    "reserve" : 30,
    "price/exchange rate" : 40,
    "debt": 50,
}
For example, if the variable is classified as a "raw balance", include the number "0" as the first token of the response like so: "0: Reason ...".
If the variable is classified as a "reserve", include the number "30" as the first token of the response like so "30: Reason ...".
If there are no applicable financial labels, begin the response with the token "-1".
Then, output the reason why a variable is categorized the way it is.
"""

'''
"undef" : -1,
    "raw balance" :0,
    "net balance" :1,
    "accrued balance" :2,
    "final balance" :3,
    "compound fee ratio (t)" : 10,
    "transaction fee" :11,
    "simple fee ratio" : 12,
    "transaction fee (n)" : 13,
    "transaction fee (d)" : 14,
    "simple interest ratio" : 20,
    "compound interest ratio" : 21,
    "simple interest": 22,
    "compound interest" : 23,
    "reserve" : 30,
    "price/exchange rate" : 40,
    "debt": 50,
'''
#Only output the financial label of the single variable after the "Var:" string.
#The variable name should be EXACTLY as is provided.
#"""

#Refine the output such using the following table such that instead of outputing the string of the financial label (i.e. raw balance, fee), the
#corresponding value in the dictionary is output instead:
refine_output = """[H] The output should include the number corresponding to one of the financial labels in the financial label python dictionary as the FIRST token.
Following, the output should include the reason why.
"""
#all_input = assign_types_intro+"."+goal+"."+clarify_output
all_input = assign_types_intro+"."+goal+"."#+mark_output
single_all_input = assign_types_intro+"." + single_goal + "." + single_clarify_output + "."
goal_test =  "Given the name of a solidity variable, please ONLY output the most likely type among the labels of: {user balance, price/exchage rate, simple fee ratio, reserve, debt, and simple interest ratio} or none if none are applicable. If there are more than one, please output all of them. DO NOT MAKE ANY OTHER OUTPUT" #Place priority on the function parameters as well as return values of function calls."
balance_prompt = {
    "name": "Balance prompts",
    "definition": """
    Raw balance variables are integer variables that typically refer to an amount of currency owned by a single user.
    They are typically passed in as parameters, or field of parameters in functions that deposit, withdraw, mint, burn, pay, etc.
    "raw balance" variables typically have names that include keywords: "amount", "balance", and "user".
    """,
    "introp1": "Raw balance generally refers to an amount of some currency owned by a user. This is fundamentally different from reserve, which is an amount of currency owned by the contract or other non-user entities.", #The following are some examples of reserve token types. These should not be categorized as the balance financial type, and therefore should not be output."
    "introp2": "The following are examples of variables of the raw balance financial type. The format of the examples are: a snippet of code containing the variable followed by the name of the variables belonging to the category, followed by the reason it is categorized as such.",
    "ex1": "Code: 'function _deposit(uint256 _amount) internal override {\n// We receive bCVX -> Convert to bCVX\nCVX_VAULT.withdraw(_amount);\nuint256 toDeposit = IERC20Upgradeable(CVX).balanceOf(address(this));\n// Lock tokens for 17 weeks, send credit to strat, always use max boost cause why not?\nLOCKER.lock(address(this), toDeposit, LOCKER.maximumBoostPayment());\n}',\nVariables: '_amount'",
    "ex2": """Code: '/// @dev used to manage the governance and strategist fee on earned rewards, make sure to use it to get paid!
        function _processRewardsFees(uint256 _amount, address _token)
            internal
            returns (uint256 governanceRewardsFee, uint256 strategistRewardsFee)
        {
            governanceRewardsFee = _processFee(
                _token,
                _amount,
                performanceFeeGovernance,
                IController(controller).rewards()
            );

            strategistRewardsFee = _processFee(
                _token,
                _amount,
                performanceFeeStrategist,
                strategist
            );
        }'
        Raw Balance Variables: '_amount'
        Reason: ('_amount') The name '_amount' seems to refer to an amount of a currency. The name does not imply it being a reserve, fee, interest, reward, or debt. It is passed as a parameter instead of being a global variable, so it is not likely to be a reserve amount. 
        A user fee is generated from '_amount()' via the function "processFee()".
        """,
    "ex3": """Code: 'function transferFrom(address sender, address recipient, uint256 amount) public virtual override returns (bool) {
            /// The _balances mapping represents the underlying ibBTC shares ("non-rebased balances")
            /// Some naming confusion emerges due to maintaining original ERC20 var names

            uint256 amountInShares = balanceToShares(amount);

            _transfer(sender, recipient, amountInShares);
            _approve(sender, _msgSender(), _allowances[sender][_msgSender()].sub(amountInShares, "ERC20: transfer amount exceeds allowance"));
            return true;
        }'
        Raw Balance Variables: 'amount', 'amountInShares'
        Reason: ('amount') The name 'amount' seems to refer to an amount of a currency. The name does not imply it being a reserve, fee, interest, reward, or debt. It is passed as a parameter instead of being a global variable, so it is not likely to be a reserve amount. 
        It is converted to a 'raw balance' variable, 'amountInShares', representing an amount of another currency via the function 'balanceOfShares()'. 
        Reason: ('amountInShares') The name `amountInShares' seems to refer to an amount of a currency. The name does not imply it being a reserve, fee, interest, reward, or debt.
        It seems to be converted from the variable 'amount' representing 'raw balance' in the function 'balanceToShares()'.
        It is used in the function '_transfer()', which transfers 'amountInShares' tokens from the 'sender' to the 'recipient'.
        It is decreased from the allowance of the user '_msgSender()'.
        The allowance of the user '_msgSender()' is decreased by 'amountInShares'. 
        """,
    "ex4": """Code: "function deposit(uint256 _amount) external whenNotPaused {
        _depositWithAuthorization(_amount, new bytes32[](0));
        }"
        Raw Balance Variables: "_amount"
        Reason: ('_amount') The name '_amount' seems to refer to an amount of a currency. The name does not imply it being a reserve, fee, interest, reward, or debt. It is passed as a parameter instead of being a global variable, so it is not likely to be a reserve amount.
        It is used in the function '_depositWithAuthorization()', which seems to deposit the '_amount' of a currency.
        """,
    "ex5": """Code: "function _calculateFee(uint256 amount, uint256 feeBps)
                internal
                pure
                returns (uint256)
            {
                if (feeBps == 0) {
                    return 0;
                }
                uint256 fee = (amount * feeBps) / MAX_BPS;
                return fee;
            }"
        Raw Balance Variables: "amount"
        Reason: ('amount') The name 'amount' seems to refer to an amount of a currency. The name does not imply it being a reserve, fee, interest, reward, or debt. It is passed as a parameter instead of being a global variable, so it is not likely to be a reserve amount.
        It is multiplied by 'compound fee ratio' variable 'feeBps' to generate a user fee, 'fee'.
        Compound Fee Ratio Variables: "feeBps"
        Reason: ('feeBps') The name 'feeBps' has the word 'fee' in it, implying it having to do with fees.
        It is multiplied by a raw balance, "amount" to create a user fee, "fee".
        Fee Variables: "fee"
        Reason: ('fee') The name 'fee' implies that it is a fee.
        It is generated by a raw balance, 'amount' being multiplied by the compound fee ratio, 'feeBps'
        """,
    "ex6": """Code:  "function sendFundsToUser(
                address tokenAddress,
                uint256 amount,
                address payable receiver,
                bytes memory depositHash,
                uint256 tokenGasPrice,
                uint256 fromChainId
            ) external nonReentrant onlyExecutor tokenChecks(tokenAddress) whenNotPaused {
                uint256 initialGas = gasleft();
                require(
                    tokenManager.getTransferConfig(tokenAddress).min <= amount &&
                        tokenManager.getTransferConfig(tokenAddress).max >= amount,
                    "Withdraw amnt not in Cap limits"
                );
                require(receiver != address(0), "Bad receiver address");

                (bytes32 hashSendTransaction, bool status) = checkHashStatus(tokenAddress, amount, receiver, depositHash);

                require(!status, "Already Processed");
                processedHash[hashSendTransaction] = true;

                uint256 amountToTransfer = getAmountToTransfer(initialGas, tokenAddress, amount, tokenGasPrice);
                liquidityProviders.decreaseCurrentLiquidity(tokenAddress, amountToTransfer);

                if (tokenAddress == NATIVE) {
                    require(address(this).balance >= amountToTransfer, "Not Enough Balance");
                    (bool success, ) = receiver.call{value: amountToTransfer}("");
                    require(success, "Native Transfer Failed");
                } else {
                    require(IERC20Upgradeable(tokenAddress).balanceOf(address(this)) >= amountToTransfer, "Not Enough Balance");
                    SafeERC20Upgradeable.safeTransfer(IERC20Upgradeable(tokenAddress), receiver, amountToTransfer);
                }

                emit AssetSent(tokenAddress, amount, amountToTransfer, receiver, depositHash, fromChainId);"
        Raw Balance Variables: "amount", "amountToTransfer"
        Reason: ("amount") The name 'amount' seems to refer to an amount of some kind of currency.
        There is a mesage in the first "require()" statement that reads: "Withdraw amnt not in Cap Limits", which is thrown when the variable "amount" does not fall within a certain range.
        It is used in the function "computeAmountToTransfer" to compute "amountToTransfer", which is a raw balance variable, as demonstrated in the next explanation:
        Reason: ("amountToTransfer") The name 'amountToTransfer' seems to refer to an amount of some kind of currency.
        The message from the two "require()" statements comparing 'amountToTransfer' read: "Not Enough Balance", further alluding to its usage as a balance.
        It is used in both a "call()" function, as well as an ERC20.safeTransfer() function, both of which are typically used to transfer balances.
        Reserve Variables: "address(this).balance", "IERC20Upgradeable(tokenAddress).balanceOf(address(this)"
        Reason: ("address(this).balance") The name 'address(this).balance' alludes to the variable representing a balance of some currency.
        However, address(this) represents the address of the contract, not a user.
        Hence, it is not a raw balance, and is more likely to be a reserve.
        """ #TODO?
        ,
    "ex7": """Code: "function safeConcurTransfer(address _to, uint _amount) private {
                uint concurBalance = concur.balanceOf(address(this));
                bool transferSuccess = false;
                if (_amount > concurBalance) {
                    transferSuccess = concur.transfer(_to, concurBalance);
                } else {
                    transferSuccess = concur.transfer(_to, _amount);
                }
                require(transferSuccess, "safeConcurTransfer: transfer failed");
            }"
        Raw Balance Variable: "_amount"
        """,
    "ex8": """Code: "function withdraw(uint256 _amount) external returns (uint256 _retVal) {
                uint256 _supply = totalSupply();
                require(_supply != 0, "ERROR: NO_AVAILABLE_LIQUIDITY");

                uint256 _liquidity = originalLiquidity();
                _retVal = (_amount * _liquidity) / _supply;

                require(
                    marketStatus == MarketStatus.Trading,
                    "ERROR: WITHDRAWAL_PENDING"
                );
                require(
                    withdrawalReq[msg.sender].timestamp +
                        parameters.getLockup(msg.sender) <
                        block.timestamp,
                    "ERROR: WITHDRAWAL_QUEUE"
                );
                require(
                    withdrawalReq[msg.sender].timestamp +
                        parameters.getLockup(msg.sender) +
                        parameters.getWithdrawable(msg.sender) >
                        block.timestamp,
                    "ERROR: WITHDRAWAL_NO_ACTIVE_REQUEST"
                );
                require(
                    withdrawalReq[msg.sender].amount >= _amount,
                    "ERROR: WITHDRAWAL_EXCEEDED_REQUEST"
                );
                require(_amount > 0, "ERROR: WITHDRAWAL_ZERO");
                require(
                    _retVal <= availableBalance(),
                    "ERROR: WITHDRAW_INSUFFICIENT_LIQUIDITY"
                );
                //reduce requested amount
                withdrawalReq[msg.sender].amount -= _amount;

                //Burn iToken
                _burn(msg.sender, _amount);

                //Withdraw liquidity
                vault.withdrawValue(_retVal, msg.sender);

                emit Withdraw(msg.sender, _amount, _retVal); ..."
        Raw Balance Variables: "_amount", "_retVal"
        """,
    "ex9": """Code: " function depositAVAX()
                        external
                        payable
                        isStopped(false)
                        atPhase(Phase.PhaseOne)
                    {
                        require(msg.sender != issuer, "LaunchEvent: issuer cannot participate");
                        require(
                            msg.value > 0,
                            "LaunchEvent: expected non-zero AVAX to deposit"
                        );

                        UserInfo storage user = getUserInfo[msg.sender];
                        uint256 newAllocation = user.balance + msg.value;
                        require(
                            newAllocation <= maxAllocation,
                            "LaunchEvent: amount exceeds max allocation"
                        );

                        uint256 rJoeNeeded;
                        // check if additional allocation is required.
                        if (newAllocation > user.allocation) {
                            // Burn tokens and update allocation.
                            rJoeNeeded = getRJoeAmount(newAllocation - user.allocation);
                            // Set allocation to the current balance as it's impossible
                            // to buy more allocation without sending AVAX too
                            user.allocation = newAllocation;
                        }

                        user.balance = newAllocation;
                        wavaxReserve += msg.value;

                        if (rJoeNeeded > 0) {
                            rJoe.burnFrom(msg.sender, rJoeNeeded);
                        }

                        WAVAX.deposit{value: msg.value}();"
                Raw Balance Variables: "msg.value", "user.balance", "newAllocation"
                Reason ('msg.value'): 'msg.value' is a special variable that represents an amount of currency passed in when calling a payable function.
                It is also added with variable 'user.balance', which can be infered to be a "raw balance" from its name.
                There is a require statement that reverts when 'msg.value' is 0, stating that the "deposited currency must be greater than 0".
                Reason ('user.balance'): The name 'user.balance' implies that the variable is a balance of a user.
                It is used in operations with 'msg.value', which is an amount of currency passed in by the user in a payable function call.
                Reason ('newAllocation'): There is an operation that assigns "user.balance" = "newAllocation".
                "user.balance" is a raw balance, so "newAllocation" must also be a raw balance.
                Reserve Variables: "wavaxReserve"
                Reason ('wavaxReserve'): 'wavaxReserve' is appended by 'msg.value', hence it is an amount of a currency.
                The name 'wavaxReserve' implies that the variable is a reserve, or balance of the contract.
                'wavaxReserve' is a global variable, hence it is not likely to be a user balance.
                

                """,
    "ex10": """Code: " function initiateVaultFillingZcTokenInitiate(Hash.Order calldata o, uint256 a, Sig.Components calldata c) internal {
            // checks order signature, order cancellation and order expiry
            bytes32 hash = validOrderHash(o, c);

            // checks the taker amount passed to amount available in the order
            require(a <= (o.premium - filled[hash]), 'taker amount > available volume');

            // adds the taker amount to the order's filled amount
            filled[hash] += a;

            // calculate principal filled and fee
            uint256 principalFilled = (((a * 1e18) / o.premium) * o.principal) / 1e18;
            uint256 fee = ((principalFilled * 1e18) / fenominator[2]) / 1e18;

            // transfer underlying tokens
            Erc20 uToken = Erc20(o.underlying);
            uToken.transferFrom(msg.sender, o.maker, a);
            uToken.transferFrom(o.maker, address(this), principalFilled);

            // deposit underlying to Compound and mint cTokens
            MarketPlace mPlace = MarketPlace(marketPlace);
            address cTokenAddr = mPlace.cTokenAddress(o.underlying, o.maturity);
            uToken.approve(cTokenAddr, principalFilled);
            require(CErc20(cTokenAddr).mint(principalFilled) == 0, 'minting CToken failed');

            // mint <principalFilled> zcTokens + nTokens and allocate appropriately in marketplace
            require(mPlace.custodialInitiate(o.underlying, o.maturity, o.maker, msg.sender, principalFilled), 'custodial initiate failed');

            // transfer fee in vault notional to swivel (from msg.sender)
            require(mPlace.transferVaultNotionalFee(o.underlying, o.maturity, msg.sender, fee), "notional fee transfer failed");

            emit Initiate(o.key, hash, o.maker, o.vault, o.exit, msg.sender, a, principalFilled);
        }"
        Raw Balance Variable: "a"
        """
    
}

debt_prompt = {
    "definition":"""
    Debt variables represent an amount of currency that a user has borrowed, or the user owes.
    They are commonly found in functions that perform borrowing/lending.
    Keywords include: "debt".
    """,
    "ex1":"""function deposit(address _recipient, uint _pid, uint _amount) external nonReentrant onlyDepositor {
        PoolInfo storage pool = poolInfo[_pid];
        UserInfo storage user = userInfo[_pid][_msgSender()];
        updatePool(_pid);

        if(user.amount > 0) {
            uint pending = user.amount * pool.accConcurPerShare / _concurShareMultiplier - user.rewardDebt;
            if (pending > 0) {
                safeConcurTransfer(_recipient, pending);
            }
        }

        if (_amount > 0) {
            if (pool.depositFeeBP > 0) {
                uint depositFee = _amount.mul(pool.depositFeeBP).div(_perMille);
                user.amount = SafeCast.toUint128(user.amount + _amount - depositFee);
            } else {
                user.amount = SafeCast.toUint128(user.amount + _amount);
            }
        }

        user.rewardDebt = SafeCast.toUint128(user.amount * pool.accConcurPerShare / _concurShareMultiplier);
        emit Deposit(_recipient, _pid, _amount);
            }"
        Reason("user.rewardDebt"): "user.rewardDebt" is decreased from the raw balance, "_amount" in the deposit function. Intuitively, it seems to be decrementing the amount owned by a user.
        """ 
        ,
        "ex2":"""function pendingRJoe(address _user) external view returns (uint256) {
        UserInfo storage user = userInfo[_user];
        uint256 joeSupply = joe.balanceOf(address(this));
        uint256 _accRJoePerShare = accRJoePerShare;

        if (block.timestamp > lastRewardTimestamp && joeSupply != 0) {
            uint256 multiplier = block.timestamp - lastRewardTimestamp;
            uint256 rJoeReward = multiplier * rJoePerSec;
            _accRJoePerShare += (rJoeReward * PRECISION) / joeSupply;
        }
        return (user.amount * _accRJoePerShare) / PRECISION - user.rewardDebt;
    } Reason("user.rewardDebt"): The name seems to apply that the varialbe represents a debt. Furthermore, the debt is decremented from user.amount, which appears to be a raw balance, hence representing a user paying off some owed amount""",

    "ex3":""""function payOff(address _user, uint256 amount) external nonReentrant returns (uint256){
                if(amount > userDebt[_user]){
                    _deposit(_user, amount - userDebt[_user]);
                    userDebt[_user] = 0;
                }       
                else{
                    userDebt[_user] -= amount;
                }
                return(userDebt[_user])
    }" Reason ("userDebt"): "userDebt seems to keep track of the amount of debt owned by a user. As evidence, the function name 'payoff' appears to mean that some debt is being paid off. Furthermore, the userDebt is decreased by the raw balance, amount that is passed as a parameter.
"""
}

#PRICE
price_prompt = {
    "definition":"""
    Price variables represent a price to convert an amount of one currency to another.
    They are typically multiplied/divided by "raw balance" variables.
    Alternatively, they can be created by dividing two "raw balance" variables.
    Keywords that may identify price variables include: "price", "AToB", and "APerB", where A and B are names of currencies.
    """
    ,
    "ex1": """Code: "function allocateCredit(uint256 _credit)
        external
        override
        returns (uint256 _pending)
    {
        require(
            IRegistry(registry).isListed(msg.sender),
            "ERROR: ALLOCATE_CREDIT_BAD_CONDITIONS"
        );
        IndexInfo storage _index = indicies[msg.sender];
        uint256 _rewardPerCredit = rewardPerCredit;
        if (_index.exist == false) {
            _index.exist = true;
            indexList.push(msg.sender);
        } else if (_index.credit > 0) {
            _pending = _sub(
                (_index.credit * _rewardPerCredit) / MAGIC_SCALE_1E6,
                _index.rewardDebt
            );
            if (_pending > 0) {
                vault.transferAttribution(_pending, msg.sender);
                attributionDebt -= _pending;
            }
        }
        if (_credit > 0) {
            totalCredit += _credit;
            _index.credit += _credit;
            emit CreditIncrease(msg.sender, _credit);
        }
        _index.rewardDebt =
            (_index.credit * _rewardPerCredit) /
            MAGIC_SCALE_1E6;
    }"
    Raw Balance Variable: "_credit"
    Reason ("_credit"): The name "_credit", and the variable being a "uint256" integer implies that it is an amount of a currency.
    It is multiplied by a "price" variable, "_reservePerCredit", and the result is used in a "transfer" function, "transferAttribution()".
    Price Variable: "_reservePerCredit"
    Reason "_reservePerCredit": The name "_reservePerCredit" contains the word "Per", implying that it is an amount of currency per another amount of currency, i.e. a price.
    It is multiplied by a "raw balance" variable, "_credit".
    Reserve Variable: "totalCredit"
    Reason "totalCredit": The variable "totalCredit" is a global variable.
    It is increased by "_credit" in the function, which represents an increase to the total amount of currency stored in the various acounts in the contract.
    """
    ,
    "ex2":"""Code: ""function _withdrawSome(uint256 _amount)
        internal
        override
        returns (uint256)
    {
        uint256 max = IERC20Upgradeable(want).balanceOf(address(this));

        if (withdrawalSafetyCheck) {
            uint256 bCVXToCVX = CVX_VAULT.getPricePerFullShare(); // 18 decimals
            require(bCVXToCVX > 10**18, "Loss Of Peg"); // Avoid trying to redeem for less / loss of peg
            require(
                max >= _amount.mul(9_980).div(MAX_BPS),
                "Withdrawal Safety Check"
            ); // 20 BP of slippage
        }

        if (max < _amount) {
            return max;
        }

        return _amount;
    }"
    Raw Balance Variable: "_amount"
    Reason ("_amount"): The name "_amount", and the variable being a "uint256" integer implies that it is an amount of a currency.
    The fuction appears to perform a withdraw operation, evidenced by it's name: "_withdrawSome", and the variable "_amount" seems to represent the amount of currency to withdraw.
    Price Variable: "bCXToCVX"
    Reason ("bCXToCVX"): The name "bCXToCVX" implies that it is a price variable due to it including the word "to".
    Additionally, it is obtained by calling the function "CVX.getPricePerFullShare()", which also implies that it is a price, more specifically, for the CVX currency.
    """
    ,
    "ex3":"""function balanceOfToken(address addr) external view override returns (uint256 mAssets) {
        uint256 exchangeRate = savings.exchangeRate();
        mAssets = (imBalances[addr] * exchangeRate) / 1e18;
    }
    Raw Balance Variable: "imBalances[]"
    Reason ("imBalances[]"): The name of "imBalances[]" implies that is used to store "balances". 
    Additionally, it is observed that "imBalances[]" takes as keys addresses, hence the array is likely to hold the "balance" of an "address", and is likely to store user balances.
    Price Variable: "exchangeRate"
    Reason("exchangeRate"): The name "exchangeRate" implies that the variable is an exchange rate from one currency to another, and hence a price.
    Additionally, it is obtained by calling the function "savings.exchangeRate()", which supports the idea of it being a price.
    """
    ,
    "ex4":"""
    """
}

#SIMPLE FEE RATIO
simple_fee_prompt = {
    "definition": """
    Fee Rate Variables are variables that refer to the percentage of a "balance" variable that is collected by the contract.
    Typical signs of "fee rate" variables are the word "fee" appearing in the variable name.
    Simple fee rates result in a "balance" variable after they are applied, while complex fee rates result in an intermediate "fee"value that is eventually added or subtracted from a "balance".
    """,
    "ex1": """Code:
    function calculatingFee(uint256 amount) public view returns (uint256) {
        return (originationFee * amount) / WAD;
    }
    Raw Balance Variable: "amount"
    Reason ("amount"): The name "amount" implies that it is an amount of a currency.
    Fee Rate Variable: "originationFee"
    Reason ("originationFee"): The name "originationFee" implies that it has relation to a "fee".
    Additionally, it is multiplied by a raw balance variable, hence providing evidence that it is a ratio or rate, and hence the variable is a fee ratio variable.
    """
    ,
    "ex2":"""Code:
    function repay(uint256 tokenId, bool skim) public returns (uint256 amount) {
        TokenLoan memory loan = tokenLoan[tokenId];
        require(loan.status == LOAN_OUTSTANDING, "NFTPair: no loan");
        TokenLoanParams memory loanParams = tokenLoanParams[tokenId];
        require(
            // Addition is safe: both summands are smaller than 256 bits
            uint256(loan.startTime) + loanParams.duration > block.timestamp,
            "NFTPair: loan expired"
        );

        uint128 principal = loanParams.valuation;

        // No underflow: loan.startTime is only ever set to a block timestamp
        // Cast is safe: if this overflows, then all loans have expired anyway
        uint256 interest = calculateInterest(principal, uint64(block.timestamp - loan.startTime), loanParams.annualInterestBPS).to128();
        uint256 fee = (interest * PROTOCOL_FEE_BPS) / BPS;
        amount = principal + interest;

        uint256 totalShare = bentoBox.toShare(asset, amount, false);
        uint256 feeShare = bentoBox.toShare(asset, fee, false);

        address from;
        if (skim) {
            require(bentoBox.balanceOf(asset, address(this)) >= (totalShare + feesEarnedShare), "NFTPair: skim too much");
            from = address(this);
            // No overflow: result fits in BentoBox
        } else {
            bentoBox.transfer(asset, msg.sender, address(this), feeShare);
            from = msg.sender;
        }
        // No underflow: PROTOCOL_FEE_BPS < BPS by construction.
        feesEarnedShare += feeShare;
        delete tokenLoan[tokenId];

        bentoBox.transfer(asset, from, loan.lender, totalShare - feeShare);
        collateral.transferFrom(address(this), loan.borrower, tokenId);

        emit LogRepay(from, tokenId);
    }
    """,
    "ex3":"""Code:
    function redeem(uint256 _longAmount, uint256 _shortAmount) external override nonReentrant {
    require(longToken.balanceOf(msg.sender) >= _longAmount, "Insufficient long tokens");
    require(shortToken.balanceOf(msg.sender) >= _shortAmount, "Insufficient short tokens");

    uint256 _collateralAmount;
    if (finalLongPayout <= MAX_PAYOUT) {
      uint256 _shortPayout = MAX_PAYOUT - finalLongPayout;
      _collateralAmount = (finalLongPayout * _longAmount + _shortPayout * _shortAmount) / MAX_PAYOUT;
    } else {
      require(_longAmount == _shortAmount, "Long and Short must be equal");
      _collateralAmount = _longAmount;
    }

    uint256 _actualFee;
    uint256 _expectedFee = (_collateralAmount * redemptionFee) / FEE_DENOMINATOR;
    if (redemptionFee > 0) { require(_expectedFee > 0, "fee = 0"); }
    else { require(_collateralAmount > 0, "amount = 0"); }
    if (address(_redeemHook) != address(0)) {
      collateral.approve(address(_redeemHook), _expectedFee);
      uint256 _collateralAllowanceBefore = collateral.allowance(address(this), address(_redeemHook));
      _redeemHook.hook(msg.sender, _collateralAmount, _collateralAmount - _expectedFee);
      _actualFee = _collateralAllowanceBefore - collateral.allowance(address(this), address(_redeemHook));
      collateral.approve(address(_redeemHook), 0);
    } else { _actualFee = 0; }

    longToken.burnFrom(msg.sender, _longAmount);
    shortToken.burnFrom(msg.sender, _shortAmount);
    uint256 _collateralAfterFee = _collateralAmount - _actualFee;
    collateral.transfer(msg.sender, _collateralAfterFee);

    emit Redemption(msg.sender, _collateralAfterFee, _actualFee);
  }
    """
}

#SIMPLE INTEREST RATIO
interest_prompt = {
    "definition":"""
    Interest Rate Variables are variables that refer to the interest rate applied to a "debt" or "balance" variable.
    They are often used together with variables that represent a "balance" to create interest.
    Typically, debt is accrued as time passes, and interest rate variables store the rate.
    Simple interest rates directly result in a "debt" or "balance" variable after they are applied, while complex interest rates results in an intermediate "interest" value that is eventually added or subtracted from a "debt" or "balance" variable.
    In the event that simple/complex is not able to be determined, assume complex.
    """,
    "definition_v2":"""
    Interest Rate Variables are integer variables that define an "interest" taken from a "debt" or "balance" variable.
    They are rates, which means that their operations consist of a pair of a numerator and a denominator.
    However, the denominator should not be treated as another interest rate variable.
    They also have, or are used in functions or operations with other variables that have the word "interest" in them.
    Interest Rates can be added or subtracted to other interest rates.
    Balance variables (integer variables that store an amount of a currency or token) are multiplied or divided by Interest Rate Variables.
    Interest Rate Variables are either Simple or Complex.
    When Balance variables are multiplied by Simple Interest Variables, the result is a "Balance" variable.
    Sometimes this function can be done using a "*=" operation.
    When Balance variables are multiplied by Complex Interest Variables, the result is a "Interest" variable.
    "Interest" Variables are added or subtracted from a "Balance" variable, usually in a later operation.
    They often have the word "interest" in their names.
    """,
    "ex1": """Code: "function interestPerSecond(uint256 _principal) public view returns (uint256) {
        uint256 _interest = ((_principal).mul(poolConstants.borrowRate)).div(365 days);
        return _interest;
    }"
    Raw Balance: "_principal"
    Reason ("_principal"): The name "_principal" implies that it is an amount of a currency.
    Additionally, "_principal" is used to generate the variable "_interest" by multiplying by a variable "poolConstants.borrowRate", which seems to be an "interest rate" variable.
    This means that "_principal" previously had not had interest applied to it, and hence should be a "raw balance".
    Complex Interest Rate: "poolConstants.borrowRate": The name implies that the variable represents a rate.
    The value "365 days" can be treated as the denominator of the rate pair, along with "poolConstants.borrowRate".
    It is used to multiply the variable "_principal" in order to create the variable "_interest".
    The the name of the result "_interest" implies that "poolConstants.borrowRate" has relation to "Interest".
    Hence, it can be inferred that the variable "poolConstants.borrowRate" is an "Interest Rate" Variable.
    """
    ,
    "ex2":"""Code: "function _deposit(uint256 yieldTokenAmount, address recipient)
        internal
        returns (
            uint256 mintedShares,
            uint256 depositedBT,
            uint256 fee,
            uint256 rate
        )
    {
        require(!matured, "Maturity reached.");
        rate = updateInterestRate();
        require(rate >= initialInterestRate, "Negative yield!");

        // Collect fees if they are set, reducing the number of tokens for the sender
        // thus leaving more YBT in the TempusPool than there are minted TPS/TYS
        uint256 tokenAmount = yieldTokenAmount;
        uint256 depositFees = feesConfig.depositPercent;
        if (depositFees != 0) {
            fee = tokenAmount.mulfV(depositFees, yieldBearingONE);
            tokenAmount -= fee;
            totalFees += fee;
        }

        // Issue appropriate shares
        depositedBT = numAssetsPerYieldToken(tokenAmount, rate);
        mintedShares = numSharesToMint(depositedBT, rate);

        PrincipalShare(address(principalShare)).mint(recipient, mintedShares);
        YieldShare(address(yieldShare)).mint(recipient, mintedShares);
    }"
    Raw Balance: "tokenAmount"
    Interest Rate: "rate", "initialInterestRate"
    Reason ("rate"): The variable "rate" is implied to be a rate from the name.
    It is set as the result of the function "updateInterestRate()", hence has relation to "Interest".
    Additionally, it is compared to a variable "initialInterestRate", which from the name, is implied to be an interest rate.
    It is used as a parameter in the function "numAssetsPerYieldToken()", along with "tokenAmount", which is a "raw balance".
    It can be infered that this function is applying the interest rate to the raw balanace.
    It is used as a parameter in the function "numSharesToMint()", along with "depositedBT", which is a "raw balance".
    It can be infered that this function is applying the interest rate to the raw balanace.
    However, simple/complex cannot be determined from the code, as the two functions are not included.
    Fee Rate: depositFees
    """
    ,
    "ex3":"""Code: "function _accrueInterest(address _token) internal {
        uint blocksElapsed = block.number - lastBlockAccrued;
        uint newInterest = _borrowRatePerBlock(_token) * blocksElapsed;
        cumulativeInterestRate[_token] += newInterest;
    }"
    Interest Rate: "cumulativeInterestRate"
    Reason ("cumulativeInterestRate"): The name implies that the variable is an interest rate.
    Additionally, it is added with variable "newInterst", which is an interest rate.
    """
    ,
    "ex4":"""Code: function getSupplyRate(uint256 reserveFactorMantissa) public view override returns (uint256) {
        require(reserveFactorMantissa <= 1e18, "reserveFactorMantissa error");
        uint256 ratio = uint256(1e18) - reserveFactorMantissa;
        return (interestRatePerBlock * ratio) / 1e18;
    }
    Interest Rate: "interestRateperBlock"
    Reason ("interestRatePerBlock"): The name implies that the variable is used as an interest rate.
    """
    ,
    "ex5":"""Code:
    function getRedemptionAmounts(
        uint256 principalAmount,
        uint256 yieldAmount,
        uint256 currentRate
    )
        private
        view
        returns (
            uint256 redeemableYieldTokens,
            uint256 redeemableBackingTokens,
            uint256 redeemFeeAmount,
            uint256 interestRate
        )
    {
        interestRate = effectiveRate(currentRate);

        if (interestRate < initialInterestRate) {
            redeemableBackingTokens = (principalAmount * interestRate) / initialInterestRate;
        } else {
            uint256 rateDiff = interestRate - initialInterestRate;
            // this is expressed in percent with exchangeRate precision
            uint256 yieldPercent = rateDiff.divfV(initialInterestRate, exchangeRateONE);
            uint256 redeemAmountFromYieldShares = yieldAmount.mulfV(yieldPercent, exchangeRateONE);

            // TODO: Scale based on number of decimals for tokens
            redeemableBackingTokens = principalAmount + redeemAmountFromYieldShares;

            // after maturity, all additional yield is being collected as fee
            if (matured && currentRate > interestRate) {
                uint256 additionalYieldRate = currentRate - interestRate;
                uint256 feeBackingAmount = yieldAmount.mulfV(
                    additionalYieldRate.mulfV(initialInterestRate, exchangeRateONE),
                    exchangeRateONE
                );
                redeemFeeAmount = numYieldTokensPerAsset(feeBackingAmount, currentRate);
            }
        }

        redeemableYieldTokens = numYieldTokensPerAsset(redeemableBackingTokens, currentRate);

        uint256 redeemFeePercent = matured ? feesConfig.matureRedeemPercent : feesConfig.earlyRedeemPercent;
        if (redeemFeePercent != 0) {
            uint256 regularRedeemFee = redeemableYieldTokens.mulfV(redeemFeePercent, yieldBearingONE);
            redeemableYieldTokens -= regularRedeemFee;
            redeemFeeAmount += regularRedeemFee;

            redeemableBackingTokens = numAssetsPerYieldToken(redeemableYieldTokens, currentRate);
        }
    }
    """
    ,
    "ex6":"""Code:
    """
    ,
    "ex7":"""Code:
    """
    ,
    "ex8":"""Code:
    """
    ,
    "ex9":"""Code:
    """
    ,
    "ex10":"""Code:
    """
}

#RESERVE
reserve_prompt = {
    "definition":"""
    Reserve Variables represent the total amount of a currency owned by a contract.
    They are typically integer global variables.
    They are typically incremented/decremented in functions that deposit/withdraw currency, respectively.
    """,
    "ex1": """Code: " function timelockDepositTo(
    address to,
    uint256 amount,
    address controlledToken
  )
    external
    onlyControlledToken(controlledToken)
    canAddLiquidity(amount)
    nonReentrant
  {
    address operator = _msgSender();
    _mint(to, amount, controlledToken, address(0));
    _timelockBalances[operator] = _timelockBalances[operator].sub(amount);
    timelockTotalSupply = timelockTotalSupply.sub(amount);

    emit TimelockDeposited(operator, to, controlledToken, amount); "
    Raw Balance Variables: "amount", "_timelockBalances"
    Reason ("amount"): The name "amount" implies that the integer is an amount of a currency.
    It is a parameter, hence is not likely to be a "reserve" variable.
    It is used in a mint operation, "_mint()" to mint the amount to a user.
    Reason ("_timelockBalances"): The name of the array includes the word "Balances", and takes as key the variable "operator".
    Hence, it can be implied to store the balance of all of the users.
    As the balance is stored per user, and there are no fees applied to the balance, it is a "raw balance".
    
    Reserve Variables: "timelockTotalSupply"
    Raw Balance Variables: "amount", "_timelockBalaces[]"
    """
    ,
    "ex2":"""Code:
    function fund(address[] calldata _recipient, uint256[] calldata _amount) external nonReentrant {
        require(!initialised, "initialised already");

        uint256 totalAmount = 0;
        for (uint256 i = 0; i < _recipient.length; i++) {
            uint256 amount = _amount[i];

            totalLocked[_recipient[i]] += amount;
            totalAmount += amount;

            emit Funded(_recipient[i], amount);
        }
        rewardToken.safeTransferFrom(msg.sender, address(this), totalAmount);
        initialised = true;
    }
    """
    ,
    "ex3":"""Code:
    function processWithdrawals() external {
        uint reserve = reserveToken.balanceOf(address(this));
        require(reserve >= withdrawals[start].amount, 'Cannot process withdrawals at this time: Not enough balance');
        uint i = start;
        while (i < withdrawals.length && (i - start) <= maxWithdrawalProcesses) {
            Withdrawal memory withdrawal = withdrawals[i];
            if (reserve < withdrawal.amount) {
                break;
            }
            reserveToken.safeTransfer(withdrawal.usr, withdrawal.amount);
            reserve -= withdrawal.amount;
            i += 1;
        }
        start = i;
    }
    """
}

#source_mapping

"""dafad
ddfdaf"""

#Preprocess prompt:
special_case_prompt = """[H] Here are some special cases of which if the conditions are met, return the specified prompt.

1) First, parse the name of the variable.

2) Second, see if any special conditions are applicable. Please note that the special cases are applicable even if they are not a direct match (i.e. Case 2B is applicable if the substring is "amount", or "Amount" etc.)

2A) Determine whether any substring of the variable name contains the string "bound" or "cap". If so, it should be classified to undef or "-1". 

2B) Determine whether any substring of the variable name contains the string "amount", "_amount", "_amounts", "_shares", or "shares". If so, it should be classified to raw balance or "0". 

2C1) Determine whether any substring of the variable name contains the string "MAX". If so, it should be classified as under or "-1"

2C2) Determine whether any substring of the variable name contains the string "max", "total", or "reserve". If so,  should be classified as reserve or "30"

2D) Determine whether any substring of the variable name contains the string "collateral". If so, it should be classified as raw balance or "0".

2E) Determine whether any substring of the variable name contains the string "share". If so, it should be classified as raw balance or "0".

2F) Determine whether any substring of the variable name contains the string "id". If so, it should be classified as undef or "-1".

2G) Determine whether any substring of the variable name contins the string "time" or "epoch", or if the variable seems to be in units of time or represent a length of time (i.e. days, months, years, epochs...). If so, it should be classified as under of "-1".

2H) Determine whether any substring of the variable name contains the string "excess" or "Excess". If so, it should be classified as "-1".

2I) Determine whether any substring of the variable name contains the string "principal". If so, it should be classified as raw balance or "0".

2J) Determine whether any substring of the variable name contains the string "gas". If so, it should be classified as undef or "-1".


3) Generate a reply based on:

3A) If the variable meets a special condition, reply with the integer classification (i.e. "-1", "0", "30", ...). Also provide an explanation of why the special condition is met.

3B) If the variable does not meet any of the special conditions, reply with "-2" instead of "-1". Also reply with the string "SANCHK". 

3C) Finally, List each special condition (2A, 2B, 2C, ... 2J) and explain why it is or is not applicable in the reply.

Format the response with the following RE: r'-?\d+:.+', with the integer being the classification (i.e., -1, -2, 0, 30, ...) and the string being any necessary strings (i.e. the explanation, SANCHK). 
"""

#Remedy prompts
remedy_sys_prompt = """You are an assistant used to determine the financial type of Solidity variables in smart contracts.

Your task is as follows: Given a trace of Solidity operations as well as a Python dictionary of variables with their corresponding financial type:

In particular, the types of financial variables are: ("raw balance", "net balance", "compound fee ratio", "simple fee ratio", "compound interest ratio", "reserve", "price/exchange rate", "debt", or "undef").

Provided is a Python dictionary that contains each of the types, as well as its associated key. 

{
    "undef" : -1,
    "raw balance" :0,
    "compound fee ratio (t)" : 10,
    "simple fee ratio" : 12,
    "simple interest ratio" : 20,
    "compound interest ratio" : 21,
    "reserve" : 30,
    "price/exchange rate" : 40,
    "debt": 50,
}

A brief definition of each type is provided below:

- Raw balance variables are integer variables that typically refer to an amount of currency owned by a single user.
    They are typically passed in as parameters, or field of parameters in functions that deposit, withdraw, mint, burn, pay, etc.
    "raw balance" variables typically have names that include: amount, balance, and user.

- Price variables represent a price to convert an amount of one currency to another.
    They are typically multiplied/divided by "raw balance" variables.
    Alternatively, they can be created by dividing two "raw balance" variables.
    Keywords in the name that are strong indicators of price variables include: "price", "AToB", and "APerB", where A and B are names of cryptocurrencies (like USDC or WETH).

- Fee Rate Variables are variables that refer to the percentage of a "balance" variable that is collected by the contract.
    Typical signs of "fee rate" variables are the word "fee" appearing in the variable name.
    Simple fee rates result in a "balance" variable after they are applied, while complex fee rates result in an intermediate "fee"value that is eventually added or subtracted from a "balance".

- Interest Rate Variables are variables that refer to the interest rate applied to a "debt" or "balance" variable.
    They are often used together with variables that represent a "balance" to create interest.
    Typically, debt is accrued as time passes, and interest rate variables store the rate.
    Simple interest rates directly result in a "debt" or "balance" variable after they are applied, while complex interest rates results in an intermediate "interest" value that is eventually added or subtracted from a "debt" or "balance" variable.
    In the event that simple/complex is not able to be determined, assume complex.

- Reserve Variables represent the total amount of a currency owned by a contract, instead of a user.
    They are typically integer global variables.
    They are typically incremented/decremented in functions that deposit/withdraw currency, respectively.

You will be provided a trace of Solidity operations. 
In particular, a BNF of the trace is defined as follows:

<Trace> ::= "Trace{" <Content> "}"
<Content> ::= <Element> | <Element> <Content>
<Element> ::= <Assignment> | <Operation> | <Terminal> | <NonTerminal>
<Assignment> ::= <var_name> "= LLM_SET" | <var_name> "=" <var_name> "[]" | <var_name> "=" <var_name> "." <field_name> | <var_name> "=" <var_name>
<Operation> ::= <var_name> "=" <_operation>
<BadOperation> ::= "ERROR: " <var_name> "=" <_operation>
<Terminal> ::= Any valid terminal symbol
<NonTerminal> ::= Any valid non-terminal symbol
<var_name> ::= Any valid Solidity variable name
<field_name> ::= Any valid Solidity field name
<_operation> ::= An operation containing at least two Solidity variables


The assignment <var_name> "=LLM_SET means that this variable was directly set by an LLM. Pay particular attention to these variables. If it is appended by "(Global)", it means that this variable is a global variable.

The assignment <var_name> "=" <var_name>" means that the type of the LHS variable was directly copied from the RHS variable.

The assignment <var_name> "=" <var_name>" [] represent that the type of the RHS variable is an array, and the LHS variable is an object of the array.

The assignment <var_name> "=" <var_name> " . <field_name> represents the type of the RHS variable is an object, and the LHS variable is a field of the RHS variable.

The operation <var_name> "=" <_operation> represents that the LHS variable is the result of the operations on the RHS.

The operation "ERROR:" <var_name> "=" <_operation> represents that operation that is not allowed due to the financial rules included below.

Dictionaries of the rules of correct financial type operations is provided below. The rules follow the following format: (keyA, keyB) = keyA. The meaning of the rule is that when a variable with the financial type with key keyA is used in an appropriate operation with a variable with the financial type with key keyB, the result is valid and has financial type keyC.

It is ok if keyA, keyB, or keyC do not belong to the financial type dictionary provided above, ignore these variables when performing analysis

"add_rules" contain the rules allowed for addition, "sub_rules" contain the rules allowed for subtraction, "mul_rules" contains the rules allowed for multiplication, and "div_rules" contains the rules allowed for division.

add_rules = {
(0, 0): 0,  #raw balance + raw balance = raw blaance
    (1, 1): 1,  
    (2, 2): 2,  
    (0, 23): 1, #compound interest + balance = net balance
    (23, 0): 1, #...
    (1, 23) : 3, 
    (23, 1) : 3,
    (10, 10) : 10, 
    (12, 12) : 12, 
    (13, 13) : 13, 
    (30, 0): 30,
    (0, 30): 30,
    (30, 1): 30,
    (1, 30): 30,
    (30, 30): 30,
    (30, 2): 30,
    (30, 3): 30,
    (40, 40): 40,
    (11, 50): 50, 
    (50, 11): 50, 
    (23, 11): 23,
    (23, 50): 50, 
    (23, 23): 23, 
    (50, 0): 50,
    (0, 50): 50,
    (50, 1): 50,
    (1, 50): 50,
    (50, 2): 50,
    (2, 50): 50,
    (50, 3): 50,
    (3, 50): 50,
    (60, 0): 3, 
    (0, 60):3,
    (1, 60): 3,
    (60, 1): 3
}

sub_rules = {
(0, 0): 0,  #raw balance - raw balance = raw blaance
    (1, 1): 1,  #net balance - net balance = net balance
    (2, 2): 2,  
    (0, 11): 1, 
    (0, 13): 1, 
    (0,14) : 1, 
    (0, 50): 0, 
    (1, 50): 1,
    (2, 50): 2, 
    (11, 11): 11,
    (11, 60): 11, 
    (10, 10) : 10, 
    (12, 12) : 12, 
    (30, 0): 30,#reserve - any balance
    (30, 1): 30,
    (30, 2): 30,
    (30, 3): 30,
    (30, 30): 30,
    (30, 60): 30,
    (50, 0): 50, #debt - any balance
    (50, 1): 50,
    (50, 2): 50,
    (50, 3): 50,
    (60, 11): 60, 
    (60, 60): 60, 
}

mul_rules = {
(0, 0): 0,
    (1, 1): 1, #net bal / net bal (?)
    (0, 10) : 13, #raw balance * compound fee ratio (t)= transaction fee (n)
    (10, 0) : 13,
    (2, 10) : 13, #accrued balance * compound fee ratio (t) = transaction fee (n)
    (10, 2) : 13,
    (14, 10):11, #transaction fee (d) * compound fee ratio = transaction fee
    (10, 14):11,
    (0, 12):1, #raw balance * simple fee ratio = net balance
    (0, 12):1,
    (0, 20):2, #simple interest ratio * raw balance = accrued balance
    (20, 0):2,
    (1, 20):3, #net balance * simple interest ratio = final balance
    (20, 1):3,
    (0, 21):23, #compound interest ratio * raw balance = compound interest
    (21, 0):23,
    (22, 20):22, #simple intrest * simple interest ratio = simple interest
    (20, 22):22,
    (30, 30):30,
    (23, 21):23, #compound interest * compound interest ratio = compound interest
    (21, 23): 23, 
    (40, 0) : 0, #price/exchange rate * any balance = corresponding balance
    (0, 40) : 0, 
    (40, 1) : 1,
    (1, 40) : 1,
    (40, 2) : 2,
    (1, 40) : 2,
    (40, 3) : 3,
    (3, 40) : 3,    
    (60, 40) : 40,
    (40, 60) : 40, 
    (40, 30) : 30, 
    (30, 40) : 30
}

div_rules = {
(0, 0) : 40,
    (1, 1): 40, #net bal / net bal (?)
    (2, 2): 40,
    (0, 10) : 14, #raw balance / c. fee ratio (t)= transaction fee (d)
    (2, 10) : 14, #accrued balance / c. fee ratio (t) = transaction fee (d)
    (13, 10): 11, #t. fee (n) / fee ratio = t. fee
    (0, 12):1, #raw balance / simple fee ratio = net balance
    (0, 20):2, #simple interest ratio * raw balance = accrued balance
    (20, 0):2,
    (1, 20):3, #net balance * simple interest ratio = final balance
    (20, 1):3,
    (0, 21):23, #compound interest ratio * raw balance = compound interest
    (21, 0):23,
    (22, 20):22, #simple intrest * simple interest ratio = simple interest
    (20, 22):22,
    (23, 21):23, #compound interest * compound interest ratio = compound interest
    (21, 23): 23, 
    (40, 0) : 0, #price/exchange rate * any balance = corresponding balance
    (0, 40) : 0,
    (30, 30): 30,
    (0, 30): 0,
    (40, 1) : 1,
    (1, 40) : 1,
    (40, 2) : 2,
    (1, 40) : 2,
    (40, 3) : 3,
    (3, 40) : 3,    
    (30, 40): 30 
}

Do not create any new rules. 

The end of the trace will always be an operation that is incorrect.

When "..." appears in a trace, it means that some operations are not provided. Please perform inference based on the provided operations.


Strictly follow these steps when given a prompt. 
1):Create a list of all the variables within "Dict". 
2): For each variable, determine whether it is a global or local variable, find the length of each variable name, 
2A): Determine any special cases regarding variable names like addendum rule 2 regarding variables representing "bound" and "cap", or addendum rule 11 regarding variables containing "amount".
3): Determine if there are variables within the list that has been misclassified. Restate the rules in the addendum. Pay attention to addendum rule 2.
4): For every variable within the list that was misclassified: 
4A): Print its name in the following format: "Name:<name>". If the name is not in the dictionary, do not continue 
4B): Determine the initial financial type of the variable. Print in this format: "IFType:<initial finance type>" 
4C): Determine what is the correct type for the variable. Print in this format: "NFType:<key of new finance type>". The key should be an integer. 
4D): Provide an explanation of the reason that the correct type is such. Print in this format: "Reason:<reason>" 
5): Provide a Python dictionary named "New_Dict" that is a dictionary containing the keys of the financial meanings of the corrected variables. 

Addendum:
1) Try not to reclassify a variable to undef (-1).
2) Variables that represent a "bound" or "cap" should have financial meaning of undef or "-1". Keywords in the name are: "bound", "cap", "limit", etc. If they are classified as anything else, reclassify these. "bound" is not the same as "bond".
3) Variables that have "bond" in the name are likely to have the financial meaning of debt or "50".
4) Perform step 2 before every reclassification
5) Variables that represent a "fee" should have financial meaning of "fee" or "11". Keywords in the name include "fee", "fees"
6) Variable that represent a "fee rate" should have financial meaning of 12 or 13. Refer to the definition of fee rate above. Keywords in the name include "feeRate"
7) The name of the variable is a big help to determining its type.
8) Only attempt to reclassify variables with LLM_SET.  If no reclassification makes sense, it is ok to leave every variable as is.
9) Variables that have "reserve" in the name should have financial meaning of reserve or "30". Keywords in the name that determine these variables are: "reserve" etc.  
10) Variables with "reserve" in the name should not be classified as raw balance or "0".
11) Variables with "amount" or "Amount" in the name should not be classified as undef or "-1", as they usually have some financial meaning. A likely correct classification is raw balance ("0")
12) Variables with "rate" in the name should not be classified as undef or "-1", as they usually have some financial meaning. Likely classifications are: price ("40") or fee rate 
13) Variables with  "excess" or "Excess" in the name should be  classified as undef or "-1".
14) Variable that represent a time (i.e. currentBlock, currentMonth), or a duration of time (i.e. timeFrame, epochLength) should be classified as undef or "-1".
15) Variables with "gas" or "Gas" in the name should be classified as under or "-1".
16) If no reclassification is requrested, return the string "NOMIS" for step 3.
"""

undefined_type_net_prompt = """
You are an assistant used to determine the financial type of Solidity variables in smart contracts.

Your task is as follows: Given a trace of Solidity operations as well as a Python list of variable names, for each variable in the list, determine if it falls into one of the categories listed below.

You will be provided a trace of Solidity operations. 
In particular, a BNF of the trace is defined as follows:

<Trace> ::= "Trace{" <Content> "}"
<Content> ::= <Element> | <Element> <Content>
<Element> ::= <Assignment> | <Operation> | <Terminal> | <NonTerminal>
<Assignment> ::= <var_name> "= LLM_SET" | <var_name> "=" <var_name> "[]" | <var_name> "=" <var_name> "." <field_name> | <var_name> "=" <var_name>
<Operation> ::= <var_name> "=" <_operation>
<BadOperation> ::= "ERROR: " <var_name> "=" <_operation>
<Terminal> ::= Any valid terminal symbol
<NonTerminal> ::= Any valid non-terminal symbol
<var_name> ::= Any valid Solidity variable name
<field_name> ::= Any valid Solidity field name
<_operation> ::= An operation containing at least two Solidity variables


The assignment <var_name> "=LLM_SET means that this variable was directly set by an LLM. Pay particular attention to these variables. If it is appended by "(Global)", it means that this variable is a global variable.

The assignment <var_name> "=" <var_name>" means that the type of the LHS variable was directly copied from the RHS variable.

The assignment <var_name> "=" <var_name>" [] represent that the type of the RHS variable is an array, and the LHS variable is an object of the array.

The assignment <var_name> "=" <var_name> " . <field_name> represents the type of the RHS variable is an object, and the LHS variable is a field of the RHS variable.

The operation <var_name> "=" <_operation> represents that the LHS variable is the result of the operations on the RHS.

The operation "ERROR:" <var_name> "=" <_operation> represents that operation that is not allowed due to the financial rules included below.

You will also be given a python list containing the names of the target variables.

Given the trace and the variable name, perform the following for every variable in the list:

1) Parse the variable name.

2) Determine whether or not it falls into one of the following categories. Provide an explanation of why or why not for each category.

2A) Liquidity. Variables belong in this category if they contain the word "liquidity" in the name, and seemingly fit the definition. Permutations such as "Liquidity", "_liquidity", etc belong in the category as well.

2B) Collateral. Variable belong in this category if they contain the word "collateral" in the name, and seemingy fit the definition. Permutations such as "Collateral", "_collateral", "xxxcollateral", etc blong in the category as well.

2C) Time. Variables belong in this category if they are related to time, or a duration of time. Keywords include days, months, epochs, phaseStart, timelock, duration...

2D) Gas. Variable belong in this category if they are relayed to gas calculation. Keywords include "gas" and "_gas"

3) Produce a response. The format is given as <3A)>":::"<3B)>":::"<3C>:

3A)  If a variable within the list falls into one or more of the categories, begin the response with "[XXX]", where XXX stands for the first three letters of the category. If the category is Liquidity, return [LIQ]. If the category is Collateral, return [COL]. If no variables belong in the categories, return [NON]

3B)  Add the variable name to the respons

3B)  Return the text reasons generated in step 2 following the result of 3A).

Example responses:
1. [GAS]:::gasUsed:::gasUsed seems to be a variable which has relation to gas, hence falls into 2D)
2. [NON]:::None:::No variable appear to fall under any of the special categories.
3. [TIM]:::phaseDuration:::phaseDuration seems to be a variable representing a duration of time, hence falls into category 2C)
"""


#Trying question prompts


class QuestionPrompts:

    #0
    is_amount_or_ratio = """
    Given the three options provided, please ONLY output the number that most corresponds to the variable in the code:
    1) It is an amount/balance of a certain currency,
    2) It is a ratio or a price,
    -1) It is none of the above or cannot be determined
    """

    #1
    is_balance_reward_or_debt = """
    Given the five options provided, please ONLY output the number that most corresponds to the variable in the code:
    1) It is an amount of currency that is owned by a user or a contract (an user/account balance or reserve)
    2) It is an amount of currency that is owed by a user (a debt)
    3) It is an amount of currency not yet distributed to a user (a reward)
    4) It is an amount of currency representing an intermediate amount used in a calculation
    -1) It is none of the above or cannot be determined
    """

    #1,2
    is_balance_or_reserve = """
    Given the two options provided, please ONLY output the number that most corresponds to the variable in the code:
    1) It is an amount owned by a user or contract that is not the owner or the currenct contract (a user/account balance)
    2) It is an amount owned by the owner or the contract itself (a contract reserve)
    """

    #2
    is_price_or_ratio = """
    Given the four options provided, please ONLY output the number that most corresponds to the variable in the code:
    1) It is a price to convert one currency to another
    2) It is a ratio to determine a fee
    3) It is a ratio used to determine an interest
    -1) It is none of the above or cannot be determined
    """

    #2,2, 2,3
    is_simple_or_compound = """
    Given the two options provided, please ONLY output the number that most corresponds to the variable in the code:
    1) It is a simple ratio
    2) It is a compound ratio
    """

    #Given a char[] code, return the corresponding output
    def get_prompt(self, code):
        prompt = None

        if(len(code) == 0):
            prompt = self.is_amount_or_ratio

        elif(len(code) == 1):
            if(code[0] == 1):
                #1 -> amount/balance -> balance, reserve, reward,debt
                prompt = self.is_balance_reward_or_debt

            elif(code[0] == 2):
                #2 -> price/ratio 
                prompt = self.is_price_or_ratio


        elif(len(code) == 2):

            if(code[0] == 1):
                if(code[1] == 1):
                    prompt = self.is_balance_or_reserve

            if(code[0] == 2):
                if(code[1] == 2 or code[1] == 3):
                    prompt = self.is_simple_or_compound

        
        return(prompt, code)

    #Given a code, return the corresponding element
    def get_type(self, code):
        for elem in code:
            if(elem == -1):
                #Signal the user for help
                return -404

        if(self.compare_lists(code, [1, 1, 1])):
            #User balance
            return 0

        elif(self.compare_lists(code, [1, 1, 2])):
            #Reserve
            return 1

        elif(self.compare_lists(code, [1, 2])):
            #Debt
            return 50

        elif(self.compare_lists(code, [1, 3])):
            #Reward (TODO NOT IMPLEMENTED YET)
            return 60

        elif(self.compare_lists(code, [1, 4])):
            #Intermediate value, should be propogated
            return -405

        elif(self.compare_lists(code, [2, 1])):
            #Price, also ask here for "price of what"
            return 40

        elif(self.compare_lists(code, [2, 2, 1])):
            #Simple fee ratio
            return 12

        elif(self.compare_lists(code, [2, 2, 2])):
            #Compound fee ratio
            return 10

        elif(self.compare_lists(code, [2, 3, 1])):
            #Simple interest ratio
            return 22

        elif(self.compare_lists(code, [2, 3, 2])):
            #Compound interest ratio
            return 21

        #If none above the above, ask for help
        return -404

    #Helper function to compare two strings
    def compare_lists(self, list1, list2):
        # Check if the lengths of the lists are the same
        if len(list1) != len(list2):
            return False  # Lists are not equal if lengths are different
        
        # Iterate through corresponding elements and compare
        for elem1, elem2 in zip(list1, list2):
            if elem1 != elem2:
                return False  # Lists are not equal if any elements are different
        
        return True  # Lists are equal if all corresponding elements are equal
