# Supplemental Material, NeurIPS 2024, Using Noise to Infer Aspects of Simplicity Without Learning

## Data

Data for zero one loss experiments can be found in the `datasets` folder.
Data for the exponential loss experiments is found in the `exponential_loss_csvs/csvs` folder.
The `binarized` subfolder contains the fully processed data used in the zero_one_loss experiments, including GOSDT+Guesses thresholding.
The other subfolders group data by domain, and have missing values removed but few other changes.
Data licenses and sources can be found in the appendix of the paper.

## Environment

A conda environment for this project can be created and activated with 

`conda env create -f environment.yml`

and

`conda activate rashomon`.

## Code

The code may be run using the SLURM scripts provided in each folder.
As of now, this code is set up only to run on SLURM clusters.
Code to generate plots is sometimes in Python scripts, and sometimes in notebooks.
They rely on results generated from running files, as described below.


To run the grounded model experiments, run 
`sbatch run_grounded_models.sh`
from inside the `grounded_models` directory.


To run the zero one loss experiments, run
`sbatch run_expected_noise.sh` and `sbatch run_noisy_rset.sh`
from inside the `zero_one_loss` directory.
The expected noise experiments will take awhile (~10 hours) to finish.


To run the exponential loss experiments, first run
`sbatch prepare_data.sh` 
from inside the `exponential_loss` directory.
Once this is finished, run
`python experiment_runner.py` from inside the same directory.
One or two of the datasets in this experiment will take awhile (several hours) to finish.