from itertools import product

def joint_density_estimation(data):
    keys = [(a, b, c, d) for a, b, c, d in product([0, 1], [0, 1], [0, 1], [0, 1])]
    density = dict.fromkeys(keys, 0)
    nenvs = len(data['x1'])
    for i in range(nenvs):
        density[(data['x1'][i], data['x2'][i], data['y1'][i], data['y2'][i])] += 1
    for key in keys:
        density[key] = density[key] / nenvs
    return density