## Starting experiments
There are two simple ways of training neural wave functions:
1) Using the CLI to start a single experiment.
2) Using [`seml`](https://github.com/TUM-DAML/seml) to start job arrays on a SLURM cluster.

### CLI
The CLI is a simple way to start a single experiment. You can provide additional configuration files or overwrite parameters.
For instance, to train a model on the N2 PES:
```bash
python train_many.py with configs/systems/n2.yaml
```
If you now want to increase the number of determinants, simply overwrite the parameter:
```bash
python train_many.py with configs/systems/n2.yaml globe.determinants=32
```

To run the experiment with Pfaffians run:
```bash
python train_many.py with configs/systems/n2.yaml pfaffian_minimal
```

### seml
To schedule multiple jobs, we recommend to use [`seml`](https://github.com/TUM-DAML/seml). `seml` takes a configuration file with defined parameter spaces and schedules a separate slurm job for each experiment. For instance, to train on both tinymol datasets, simply run:
```bash
seml globe_hydrogen add configs/seml/train_tinymol_id_ood.yaml
```

## Acknowledgements
This source code is based on the official [GitHub implementation](https://github.com/n-gao/globe) of "Generalizing Neural Wave Functions" by Gao and Günnemann, 2023.
