def add_args(parser):
    parser.add_argument(
        "--pretrained_model_name_or_path",
        type=str,
        default="glenn2/stable-diffusion-2-flax",
        required=False,
        help="Path to pretrained model or model identifier from huggingface.co/models.",
    )
    parser.add_argument(
        "--revision",
        type=str,
        default=None,
        required=False,
        help="Revision of pretrained model identifier from huggingface.co/models.",
    )
    parser.add_argument(
        "--tokenizer_name",
        type=str,
        default=None,
        help="Pretrained tokenizer name or path if not the same as model_name",
    )
    parser.add_argument(
        "--reference_data_dir",
        type=str,
        default=None,
        required=True,
        help="A folder containing the training data of reference images.",
    )
    parser.add_argument(
        "--generated_data_dir",
        type=str,
        default=None,
        required=False,
        help="A folder containing the training data of generated images.",
    )
    parser.add_argument(
        "--prompt",
        type=str,
        default="A photo of [V] dog",
        help="The prompt with identifier specifying the reference",
    )
    parser.add_argument(
        "--class_token",
        type=str,
        default="dog",
        help="The specific class with this subject",
    )
    parser.add_argument(
        "--subject",
        type=str,
        default="dog",
        help="The subject folder of the dreambooth dataset.",
    )
    parser.add_argument(
        "--num_generated_images",
        type=int,
        default=8,
        help="The number of generated images to be used for training per device.",
    )
    parser.add_argument(
        "--reward_lambda",
        type=float,
        default=0.3,
        help="The lambda hyperparameter used in validation reward model.",
    )
    parser.add_argument("--beta", type=float, default=1.0, help="The weight of KL divergence")
    parser.add_argument(
        "--savepath",
        type=str,
        default="models/dpo",
        help="The output directory where the model predictions and checkpoints will be written.",
    )
    parser.add_argument(
        "--savesamples",
        type=str,
        default="samples/dpo",
        help="The output directory where the samples will be saved.",
    )
    parser.add_argument("--save_steps", type=int, default=10, help="Save a checkpoint every X steps.")
    parser.add_argument("--eval_steps", type=int, default=10, help="Evaluate the model every X steps.")
    parser.add_argument("--seed", type=int, default=0, help="A seed for reproducible training.")
    parser.add_argument(
        "--resolution",
        type=int,
        default=512,
        help=(
            "The resolution for input images, all the images in the train/validation dataset will be resized to this"
            " resolution"
        ),
    )
    parser.add_argument(
        "--center_crop",
        default=False,
        action="store_true",
        help=(
            "Whether to center crop the input images to the resolution. If not set, the images will be randomly"
            " cropped. The images will be resized to the resolution first before cropping."
        ),
    )
    parser.add_argument("--train_text_encoder", action="store_true", help="Whether to train the text encoder")
    parser.add_argument(
        "--train_batch_size", type=int, default=1, help="Batch size (per device) for the training dataloader."
    )
    parser.add_argument(
        "--sample_batch_size", type=int, default=1, help="Batch size (per device) for sampling images."
    )
    parser.add_argument("--num_train_epochs", type=int, default=1)
    parser.add_argument(
        "--max_train_steps",
        type=int,
        default=1000,
        help="Total number of training steps to perform.  If provided, overrides num_train_epochs.",
    )
    parser.add_argument(
        "--learning_rate",
        type=float,
        default=5e-6,
        help="Initial learning rate (after the potential warmup period) to use.",
    )
    parser.add_argument(
        "--scale_lr",
        action="store_true",
        default=False,
        help="Scale the learning rate by the number of GPUs, gradient accumulation steps, and batch size.",
    )
    parser.add_argument("--adam_beta1", type=float, default=0.9, help="The beta1 parameter for the Adam optimizer.")
    parser.add_argument("--adam_beta2", type=float, default=0.999, help="The beta2 parameter for the Adam optimizer.")
    parser.add_argument("--adam_weight_decay", type=float, default=1e-2, help="Weight decay to use.")
    parser.add_argument("--adam_epsilon", type=float, default=1e-08, help="Epsilon value for the Adam optimizer")
    parser.add_argument("--max_grad_norm", default=1.0, type=float, help="Max gradient norm.")
    parser.add_argument("--push_to_hub", action="store_true", help="Whether or not to push the model to the Hub.")
    parser.add_argument("--hub_token", type=str, default=None, help="The token to use to push to the Model Hub.")
    parser.add_argument(
        "--hub_model_id",
        type=str,
        default=None,
        help="The name of the repository to keep in sync with the local `output_dir`.",
    )
    parser.add_argument(
        "--logging_dir",
        type=str,
        default="logs",
        help=(
            "[TensorBoard](https://www.tensorflow.org/tensorboard) log directory. Will default to"
            " *output_dir/runs/**CURRENT_DATETIME_HOSTNAME***."
        ),
    )
    parser.add_argument(
        "--mixed_precision",
        type=str,
        default="no",
        choices=["no", "fp16", "bf16"],
        help=(
            "Whether to use mixed precision. Choose"
            "between fp16 and bf16 (bfloat16). Bf16 requires PyTorch >= 1.10."
            "and an Nvidia Ampere GPU."
        ),
    )
    parser.add_argument("--local_rank", type=int, default=-1, help="For distributed training: local_rank")
    parser.add_argument("--bucket", type=str, default="dpo_booth_bucket", help="Google Cloud Bucket to store the data.")
    # NEED A NEW BUCKET
    args = parser.parse_args()

    return args