#PACKAGES -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

using Optim, Plots, DelimitedFiles, LinearAlgebra, Random, StatsBase, FiniteDifferences, LaTeXStrings , EasyFit, Printf, FFTW, Pkg, Noise, Clustering, Dierckx, BSplineKit, MultivariateStats, Flux, Combinatorics, Bigsimr, DataFrames, JLD, Distributions, FFTW, Statistics

#FUNCTIONS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Functions for Todorov's and Numerical GD algorithms (1D)
cd(@__DIR__)#to go back to the directory of the script
include("../../MyFunctions/functions_TOD_and_GD_1D.jl")

#Functions for full GD algorithms (1D and multiple dimensions)
cd(@__DIR__)#to go back to the directory of the script
include("../../MyFunctions/functions_full_GD_algorithms.jl")

#TASK PARAMETERS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Σ_x_0 = 0.0  # one of these two variances (note that they're variances) must be set at zero [probably we should always have Σ_z_0 = 0 to be consisten with (Todorov, 2005)--> see point (A) in "TO BE EXPLORED" session in the file "functions_full_GD_algorithms.jl"]
Σ_z_0 = 0.0
μ_x_0 = 1.0  # these two variables, the initial means of the state and state estimate, should be the same
μ_z_0 = μ_x_0
x_z_0_mean = μ_x_0
T =  100 #Note that T must be T>2 to have a non-trivial problem and to make the scripts run (with T=2 there is no estimation problem to solve)
q = 1
q_T = 20 #q_T is the weight of the terminal state in the cost function, higher than q to make the terminal state more important (being the task relevant cost in most of the cases)
r = 1
a = 1.0
b = 1.0
m = a
n = b
H = 1
σ_ξ = 0.5
σ_ϵ_control_dep_noise = 0.5
σ_ω_add_sensory_noise = 0.5
σ_ρ_mult_sensory_noise = 0.5 
σ_η_internal_noise = 0.0

σ_ξ_values = [0.5]
σ_ϵ_control_dep_noise_values = [0.5]
σ_ω_add_sensory_noise_values = [0.5]
σ_ρ_mult_sensory_noise_values = [0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0]
σ_η_internal_noise_values = [0.0] 

#Loading data -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Folder
cd(@__DIR__)#to go back to the directory of the script
folder_location = "../../Data/1D_problem_fixing_L_and_K"

#Todorov
file_name_L_TOD = "1D_problem_l_opt_TOD_fixing_K.jld"
file_path_L_TOD = folder_location * "/" * file_name_L_TOD
l_opt_TOD = load(file_path_L_TOD, "l_opt_TOD");

file_name_MC_cost_TOD = "1D_problem_MC_cost_TOD_fixing_K.jld"
file_path_MC_cost_TOD = folder_location * "/" * file_name_MC_cost_TOD
MC_cost_TOD = load(file_path_MC_cost_TOD, "MC_cost_TOD");

file_name_MC_error_cost_TOD = "1D_problem_MC_error_cost_TOD_fixing_K.jld"
file_path_MC_error_cost_TOD = folder_location * "/" * file_name_MC_error_cost_TOD
MC_error_cost_TOD = load(file_path_MC_error_cost_TOD, "MC_error_cost_TOD");

#GD
file_name_L_GD = "1D_problem_l_opt_GD_fixing_K.jld"
file_path_L_GD = folder_location * "/" * file_name_L_GD
l_opt_GD = load(file_path_L_GD, "l_opt_GD");

file_name_MC_cost_GD = "1D_problem_MC_cost_GD_fixing_K.jld"
file_path_MC_cost_GD = folder_location * "/" * file_name_MC_cost_GD
MC_cost_GD = load(file_path_MC_cost_GD, "MC_cost_GD");

file_name_MC_error_cost_GD = "1D_problem_MC_error_cost_GD_fixing_K.jld"
file_path_MC_error_cost_GD = folder_location * "/" * file_name_MC_error_cost_GD
MC_error_cost_GD = load(file_path_MC_error_cost_GD, "MC_error_cost_GD");

#OPTIONS TO SAVE PLOTS ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

name_plots = ""

cd(@__DIR__)#to go back to the directory of the script
full_folder_save_plots = "../1D_Plots/Figures"

dpi_value = 500 # A higher dpi value will result in a sharper image but may also increase the file size.
default(dpi=dpi_value)

#------------------- (1) Suboptimality of Todorov: comparison between Todorov and GD performances ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

plt_costs_TOD_and_GD = plot(σ_ρ_mult_sensory_noise_values[:], MC_cost_TOD[1,1,1,:,1], ribbon = MC_error_cost_TOD[1,1,1,:,1], label = "TOD", title = "", titlefont = font(12,"Computer Modern"), xlabel = L"$D$", ylabel = L"$\mathbb{E}[J(D)]$", lw = 3, grid = false, color = cgrad(:Blues_5, 21)[end])
plot!(plt_costs_TOD_and_GD, σ_ρ_mult_sensory_noise_values[:], MC_cost_GD[1,1,1,:,1], ribbon = MC_error_cost_GD[1,1,1,:,1], label = "GD", lw = 3, color = cgrad(:BuGn_5, 21)[end], yscale =:log)

plt_costs_TOD_and_GD = plot(plt_costs_TOD_and_GD, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.2, size = (1300, 600))

name_and_path_plot = full_folder_save_plots * "/Cost_TOD_GD_fixing_K" * name_plots * ".pdf" 
savefig(plt_costs_TOD_and_GD, name_and_path_plot)
