#PACKAGES -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

using Optim, Plots, DelimitedFiles, LinearAlgebra, Random, StatsBase, FiniteDifferences, LaTeXStrings , EasyFit, Printf, FFTW, Pkg, Noise, Clustering, Dierckx, BSplineKit, MultivariateStats, Flux, Combinatorics, Bigsimr, DataFrames, JLD, Distributions, FFTW, Statistics

#FUNCTIONS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Functions for Todorov's and Numerical GD algorithms (1D)
cd(@__DIR__)#to go back to the directory of the script
include("../../MyFunctions/functions_TOD_and_GD_1D.jl")

#Functions for full GD algorithms (1D and multiple dimensions)
cd(@__DIR__)#to go back to the directory of the script
include("../../MyFunctions/functions_full_GD_algorithms.jl")

#------------------- PLOTS FOR NEURIPS PAPER ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Loading data

#Folder
cd(@__DIR__)#to go back to the directory of the script
folder_location = "../../Data/1D_problem_changing_internal_noise"

#Parameters
file_name_parameters = "1D_problem_data_parameters.jld2"
file_path_parameters = folder_location * "/" * file_name_parameters
params_loaded = load(file_path_parameters)

#Here we unfold the dictionary to extract all the variables and plot them
my_dict_params = params_loaded["params_dict"]

# Iterate through the dictionary and assign values to variables
for (key, value) in my_dict_params
    # Create a symbol from the key
    symbol_key = Symbol(key)
    # Assign the value to the symbol
    eval(:($symbol_key = $value))
end

σ_η_vec = my_dict_params["σ_η_internal_noise_min"]:my_dict_params["Δ_σ_η_internal_noise"]:my_dict_params["σ_η_internal_noise_max"]

#Accumulated cost: performance
file_name_save_study_cost = "1D_problem_data_changing_internal_noise.jld2"
file_path_save_study_cost = folder_location * "/" *file_name_save_study_cost
data_study_cost = load(file_path_save_study_cost)

#Here we unfold the dictionary to extract all the variables and plot them
my_dict_study_cost = data_study_cost["dict_to_save_study_cost"]

# Iterate through the dictionary and assign values to variables
for (key, value) in my_dict_study_cost
    # Create a symbol from the key
    symbol_key = Symbol(key)
    # Assign the value to the symbol
    eval(:($symbol_key = $value))
end

#Adaptability to external noise
file_name_save_adaptability = "1D_problem_data_adaptability.jld2"
file_path_save_adaptability = folder_location * "/" * file_name_save_adaptability
data_adaptability = load(file_path_save_adaptability)

#Here we unfold the dictionary to extract all the variables and plot them
my_dict_adaptability = data_adaptability["dict_to_save_adaptability"]

# Iterate through the dictionary and assign values to variables
for (key, value) in my_dict_adaptability
    # Create a symbol from the key
    symbol_key = Symbol(key)
    # Assign the value to the symbol
    eval(:($symbol_key = $value))
end

#OPTIONS TO SAVE PLOTS ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

name_plots = ""

cd(@__DIR__)#to go back to the directory of the script
full_folder_save_plots = "../1D_Plots/Figures"

dpi_value = 500 # A higher dpi value will result in a sharper image but may also increase the file size.
default(dpi=dpi_value)

#------------------- (1) Suboptimality of Todorov: comparison between Todorov and GD performances while varying the internal noise ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

plt_costs_TOD_and_GD = plot(σ_η_vec[:], MC_cost_TOD_optim[:], ribbon = MC_std_cost_TOD_optim[:], label = L"TOD", title = "", titlefont = font(12,"Computer Modern"), xlabel = L"$\sigma_{\eta}$", ylabel = L"$\mathbb{E}[J(\sigma_{\eta})]$", lw = 3, grid = false, color = cgrad(:Blues_5, length(σ_η_vec))[end])
plot!(plt_costs_TOD_and_GD, σ_η_vec[:], MC_cost_GD_optim[:], ribbon = MC_std_cost_GD_optim[:], label = L"GD", lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[end], yscale=:log)

plt_costs_TOD_and_GD = plot(plt_costs_TOD_and_GD, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.2, size = (1300, 600))

name_and_path_plot = full_folder_save_plots * "/Cost_TOD_GD" * name_plots * ".pdf" 
savefig(plt_costs_TOD_and_GD, name_and_path_plot)

#------------------- (2) Comparison between optimal solutions ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#title = "Filters - TOD", titlefont = font(14,"Computer Modern")
plt_TOD_solutions_k = plot(k_opt_TOD[1,:], title = L"TOD", titlefont = font(14,"Computer Modern"), ylabel = L"$K_t$", xlabel = L"$t$", lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[1])
plt_GD_solutions_k = plot(k_opt_GD[1,:], title = L"GD", titlefont = font(14,"Computer Modern"), ylabel = "", xlabel = L"$t$", lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[1], yticks = [])

#title = "Control gains - TOD", titlefont = font(14,"Computer Modern")
plt_TOD_solutions_l = plot(l_opt_TOD[1,:], ylabel = L"$L_t$", title = L"TOD", titlefont = font(14,"Computer Modern"), xlabel = L"$t$", lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[1], yticks = [-0.1,-0.3,-0.5,-0.7])
plt_GD_solutions_l = plot(l_opt_GD[1,:], title = L"GD", titlefont = font(14,"Computer Modern"), ylabel = "", xlabel = L"$t$", lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[1], yticks = [])

for i in 2:length(σ_η_vec)

    plot!(plt_TOD_solutions_k, k_opt_TOD[i,:], lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[i])
    plot!(plt_GD_solutions_k, k_opt_GD[i,:], lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[i])

    plot!(plt_TOD_solutions_l, l_opt_TOD[i,:], lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[i])
    plot!(plt_GD_solutions_l, l_opt_GD[i,:], lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[i])

end

layout_sol = @layout [a b]

#plt_optimal_sol_TOD = plot(plt_TOD_solutions_k, plt_TOD_solutions_l, layout = layout_sol, leg = false, grid = false)
plt_filters_TOD_GD = plot(plt_TOD_solutions_k, plt_GD_solutions_k, layout = layout_sol, leg = false, grid = false, ylims = (minimum([minimum(k_opt_TOD),minimum(k_opt_GD)]),maximum([maximum(k_opt_TOD),maximum(k_opt_GD)])))
plt_filters_TOD_GD = plot(plt_filters_TOD_GD, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), leg = false, grid = false)

name_and_path_plot = full_folder_save_plots * "/optimal_filters_TOD_GD_" * name_plots * ".pdf" 
savefig(plt_filters_TOD_GD, name_and_path_plot)

# plt_optimal_sol_GD = plot(plt_GD_solutions_k, plt_GD_solutions_l, layout = layout_sol, leg = false, grid = false, thickness_scaling=2, size = (1300, 600))
# plt_optimal_sol_GD = plot(plt_optimal_sol_GD, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), leg = false, grid = false)

plt_controls_TOD_GD = plot(plt_TOD_solutions_l, plt_GD_solutions_l, layout = layout_sol, leg = false, grid = false)
plt_controls_TOD_GD = plot(plt_controls_TOD_GD, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), leg = false, grid = false, ylims = (minimum([minimum(l_opt_TOD),minimum(l_opt_GD)]),maximum([maximum(l_opt_TOD),maximum(l_opt_GD)])))

name_and_path_plot = full_folder_save_plots * "/optimal_controls_TOD_GD_" * name_plots * ".pdf" 
savefig(plt_controls_TOD_GD, name_and_path_plot)

#------------------- (2.1) Proof that Iterative-GD exactly matches numerical GD solutions ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

ylims_min_k_it_GD = minimum([minimum(k_opt_GD),minimum(k_opt_iterative_GD)])
ylims_max_k_it_GD = maximum([maximum(k_opt_GD),maximum(k_opt_iterative_GD)])

ylims_min_l_it_GD = minimum([minimum(l_opt_GD),minimum(l_opt_iterative_GD)])
ylims_max_l_it_GD = maximum([maximum(l_opt_GD),maximum(l_opt_iterative_GD)])

plt_iterative_GD_solutions_k = plot(k_opt_iterative_GD[1,:], title = L"\mathrm{Iterative}-GD", titlefont = font(14,"Computer Modern"), ylabel = L"$K_t$", xlabel = L"$t$", lw = 3, color = cgrad(:Reds_5, length(σ_η_vec))[1], ylims = (ylims_min_k_it_GD, ylims_max_k_it_GD))
plt_GD_solutions_k = plot(k_opt_GD[1,:], title = L"GD", titlefont = font(14,"Computer Modern"), ylabel = "", xlabel = L"$t$", lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[1], ylims = (ylims_min_k_it_GD, ylims_max_k_it_GD), yticks = [])

plt_iterative_GD_solutions_l = plot(l_opt_iterative_GD[1,:], ylabel = L"$L_t$", title = L"\mathrm{Iterative}-GD", titlefont = font(14,"Computer Modern"), xlabel = L"$t$", lw = 3, color = cgrad(:Reds_5, length(σ_η_vec))[1], ylims = (ylims_min_l_it_GD, ylims_max_l_it_GD), yticks = [-0.1,-0.3,-0.5,-0.7])
plt_GD_solutions_l = plot(l_opt_GD[1,:], title = L"GD", titlefont = font(14,"Computer Modern"), ylabel = "", xlabel = L"$t$", lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[1], yticks = [], ylims = (ylims_min_l_it_GD, ylims_max_l_it_GD))

for i in 2:length(σ_η_vec)

    plot!(plt_iterative_GD_solutions_k, k_opt_iterative_GD[i,:], lw = 3, color = cgrad(:Reds_5, length(σ_η_vec))[i])
    plot!(plt_GD_solutions_k, k_opt_GD[i,:], lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[i])

    plot!(plt_iterative_GD_solutions_l, l_opt_iterative_GD[i,:], lw = 3, color = cgrad(:Reds_5, length(σ_η_vec))[i])
    plot!(plt_GD_solutions_l, l_opt_GD[i,:], lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[i])

end

layout_sol = @layout [a b]

#plt_optimal_sol_iterative_GD = plot(plt_iterative_GD_solutions_k, plt_iterative_GD_solutions_l, layout = layout_sol, leg = false, grid = false)
plt_filters_iterative_GD_GD = plot(plt_iterative_GD_solutions_k, plt_GD_solutions_k, layout = layout_sol, leg = false, grid = false)
plt_filters_iterative_GD_GD = plot(plt_filters_iterative_GD_GD, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), leg = false, grid = false)

name_and_path_plot = full_folder_save_plots * "/optimal_filters_iterative_GD_GD_" * name_plots * ".pdf" 
savefig(plt_filters_iterative_GD_GD, name_and_path_plot)

# plt_optimal_sol_GD = plot(plt_GD_solutions_k, plt_GD_solutions_l, layout = layout_sol, leg = false, grid = false, thickness_scaling=2, size = (1300, 600))
# plt_optimal_sol_GD = plot(plt_optimal_sol_GD, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), leg = false, grid = false)

plt_controls_iterative_GD_GD = plot(plt_iterative_GD_solutions_l, plt_GD_solutions_l, layout = layout_sol, leg = false, grid = false)
plt_controls_iterative_GD_GD = plot(plt_controls_iterative_GD_GD, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), leg = false, grid = false)

name_and_path_plot = full_folder_save_plots * "/optimal_controls_iterative_GD_GD_" * name_plots * ".pdf" 
savefig(plt_controls_iterative_GD_GD, name_and_path_plot)

#costs
error_difference = sqrt.(MC_std_cost_iterative_GD_optim[:].^2 .+ MC_std_cost_GD_optim[:].^2)
plt_costs_iterative_GD_and_GD = plot(σ_η_vec[:], MC_cost_GD_optim[:].- MC_cost_iterative_GD_optim[:], ribbon = error_difference, title = "", titlefont = font(12,"Computer Modern"), xlabel = L"$\mathrm{internal \ noise}\ \sigma_{\eta}$", ylabel = L"$\mathbb{E}[J_{GD}-J_{It-GD}]$", lw = 3, grid = false, color =:brown2, ylims = (-10,10))
plt_costs_iterative_GD_and_GD = plot(plt_costs_iterative_GD_and_GD, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), leg=:false)

name_and_path_plot = full_folder_save_plots * "/Cost_iterative_GD_GD" * name_plots * ".pdf" 
savefig(plt_costs_iterative_GD_and_GD, name_and_path_plot)

#------------------- (3) Understanding Todorov's problem: an eigenvector study ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Here we run a further analysis in which we consider the 2x2 matrix for the evolution of the vector x,x_hat and compute the eigenvalues per each time step

#Note that the eigenvalues should be alwasy real (by looking at the math). Nonetheless, this doesn't mean that oscillatory behaviour cannot take place, given that the linear system 
#dynamics changes over time (therefore we have time-dependent eigenvalues that could give rise to fluctuations, even if they're real)

#NOTE: The eigenvectros and eigenvalues are computed analytically: check that evertything's correct by computing them also numerically (using eigen function in julia: look at the script "study_eigenvectors")

#Useful functions for this section

#Funtion to compute eigenvalues and eigenvectors for the 2x2 dynamics matrix 
function eigen_vectors_and_values_1D_case(a,b,H,k_t,l_t)
    
    eigenvector_identity = [1,1]
    eigenvalue_identity = a+b*l_t

    eigenvector_second = [-b*l_t/(H*k_t), 1]
    eigenvalue_second = a-H*k_t
    
    return eigenvector_identity, eigenvector_second, eigenvalue_identity, eigenvalue_second

end

#The function gives as output the anbgle between two vectors. if reset_180 == 1 the output is between 0 and 180 degrees: all the angles shifted by 180 degrees represent the same angle.
#The default is reset_180 = 0.
#Note that if one of the two vectors has zero length, then the output is set to zero. 
function angle_between_vectors(vector1, vector2, reset_180 = 0)
    """
    Calculate the angle between two vectors in degrees.

    Parameters:
    - vector1: The first vector.
    - vector2: The second vector.

    Returns:
    - The angle between the vectors in degrees. Returns 0 if either vector is a null vector.
    """
    
    # Calculate the magnitudes (lengths) of the vectors
    magnitude1 = sqrt(sum(vector1 .^ 2))
    magnitude2 = sqrt(sum(vector2 .^ 2))
    
    # Check if either vector is a null vector
    if magnitude1 == 0.0 || magnitude2 == 0.0
        return 0.0
    end
    
    # Calculate the dot product of the two vectors
    dot_product = dot(vector1, vector2)
    
    # Calculate the cosine of the angle using the dot product and magnitudes
    cosine_value = dot_product / (magnitude1 * magnitude2)
        
    # Ensure that the cosine value is within the valid range of -1 to 1 [we add these lines to be sure we don't exceed the constraint due to numerical errors]
    cosine_value = max(-1.0, min(1.0, cosine_value))
    
    # Calculate the angle in radians using the adjusted cosine value
    angle_radians = acos(cosine_value)    

    # Convert the angle to degrees
    angle_degrees = rad2deg(angle_radians)
    
    # Map angles between 180 and 360 degrees to the corresponding angles between 0 and 180 degrees
    if reset_180 == 1
        
        if angle_degrees >= 180.0
            angle_degrees = angle_degrees - 180.0
        end

    end

    return angle_degrees
    
end

#Variables for the analytical solutions; NOTE that here, for example, eigenvectors_TOD[:,1,j,i] always stands for the identity eigenvector (the first eigenvector is always the 
#identity one for simplicity) at the time step j, for the noise level i (for Todorov's approach in this case).
eigenvalues_TOD = zeros(2,T-1,length(σ_η_vec))
eigenvectors_TOD = zeros(2,2,T-1,length(σ_η_vec))

eigenvalues_GD = zeros(2,T-1,length(σ_η_vec))
eigenvectors_GD = zeros(2,2,T-1,length(σ_η_vec))

eigenvalues_iterative_GD = zeros(2,T-1,length(σ_η_vec))
eigenvectors_iterative_GD = zeros(2,2,T-1,length(σ_η_vec))

eigenvalues_HEUR_GD = zeros(2,T-1,length(σ_η_vec))
eigenvectors_HEUR_GD = zeros(2,2,T-1,length(σ_η_vec))

#Angles between eigenvectors in the three algorithms
angles_between_eigen_TOD = zeros(1,T-1,length(σ_η_vec))
angles_between_eigen_GD = zeros(1,T-1,length(σ_η_vec))
angles_between_eigen_iterative_GD = zeros(1,T-1,length(σ_η_vec))
angles_between_eigen_HEUR_GD = zeros(1,T-1,length(σ_η_vec))

#Variables for the numerical solutions; NOTE that here, for example, eigenvectors_TOD[:,1,j,i] always stands for the eigenvector with lowest eigenvalue (the function eigen should
#give the eigenvectros and eigenvalues in decreasing order) at the time step j, for the noise level i (for Todorov's approach in this case).
eigenvalues_TOD_num = zeros(2,T-1,length(σ_η_vec))
eigenvectors_TOD_num = zeros(2,2,T-1,length(σ_η_vec))
matrix_dyanimcs_TOD_tmp = zeros(2,2)

eigenvalues_GD_num = zeros(2,T-1,length(σ_η_vec))
eigenvectors_GD_num = zeros(2,2,T-1,length(σ_η_vec))
matrix_dyanimcs_GD_tmp = zeros(2,2)

eigenvalues_iterative_GD_num = zeros(2,T-1,length(σ_η_vec))
eigenvectors_iterative_GD_num = zeros(2,2,T-1,length(σ_η_vec))
matrix_dyanimcs_iterative_GD_tmp = zeros(2,2)

#Angles between eigenvectors in the three algorithms
angles_between_eigen_TOD_num = zeros(1,T-1,length(σ_η_vec))
angles_between_eigen_GD_num = zeros(1,T-1,length(σ_η_vec))
angles_between_eigen_iterative_GD_num = zeros(1,T-1,length(σ_η_vec))

#variable for the function to compute angles: the output angles will be between 0 and 180 degrees for visualization purposes
reset_180 = 1

#Computing eigenvectors, eigenvalues, angles ...
for i in 1:length(σ_η_vec)
    
    for j in 1:T-1
        
        #Analytical solutions

        #TODOROV
        eigenvectors_TOD[:,1,j,i], eigenvectors_TOD[:,2,j,i], eigenvalues_TOD[1,j,i], eigenvalues_TOD[2,j,i] = eigen_vectors_and_values_1D_case(a,b,H,k_opt_TOD[i,j],l_opt_TOD[i,j])

        #Numerical GD
        eigenvectors_GD[:,1,j,i], eigenvectors_GD[:,2,j,i], eigenvalues_GD[1,j,i], eigenvalues_GD[2,j,i] = eigen_vectors_and_values_1D_case(a,b,H,k_opt_GD[i,j],l_opt_GD[i,j])

        #Iterative-GD
        eigenvectors_iterative_GD[:,1,j,i], eigenvectors_iterative_GD[:,2,j,i], eigenvalues_iterative_GD[1,j,i], eigenvalues_iterative_GD[2,j,i] = eigen_vectors_and_values_1D_case(a,b,H,k_opt_iterative_GD[i,j],l_opt_iterative_GD[i,j])

        #Angles: angles always between the identity eigenvector and the remaining one
        angles_between_eigen_TOD[1,j,i] = angle_between_vectors(eigenvectors_TOD[:,1,j,i], eigenvectors_TOD[:,2,j,i], reset_180)
        angles_between_eigen_GD[1,j,i] = angle_between_vectors(eigenvectors_GD[:,1,j,i], eigenvectors_GD[:,2,j,i], reset_180)
        angles_between_eigen_iterative_GD[1,j,i] = angle_between_vectors(eigenvectors_iterative_GD[:,1,j,i], eigenvectors_iterative_GD[:,2,j,i], reset_180)
        angles_between_eigen_HEUR_GD[1,j,i] = angle_between_vectors(eigenvectors_HEUR_GD[:,1,j,i], eigenvectors_HEUR_GD[:,2,j,i], reset_180)

        #Numerical solutions (as a check)
        
        #TODOROV
        matrix_dyanimcs_TOD_tmp[1,:] = [a, b*l_opt_TOD[i,j]]
        matrix_dyanimcs_TOD_tmp[2,:] = [k_opt_TOD[i,j]*H, a+b*l_opt_TOD[i,j]-k_opt_TOD[i,j]*H]

        # Compute eigenvalues and eigenvectors
        eigen_results_TOD = eigen(matrix_dyanimcs_TOD_tmp)

        # Access eigenvalues and eigenvectors (note that eigenvectors are column vectors, therefore the first eigenvector at time j with internal noise level i is eigenvectors_TOD[:,1,j,i], while the second is eigenvectors_TOD[:,2,j,i], while the first eigenvalue is eigenvalues_TOD[1,j,i] and eigenvalues_TOD[2,j,i] the second)
        eigenvalues_TOD_num[:,j,i] = real.(eigen_results_TOD.values)
        eigenvectors_TOD_num[:,:,j,i] = real.(eigen_results_TOD.vectors)

        #GD
        matrix_dyanimcs_GD_tmp[1,:] = [a, b*l_opt_GD[i,j]]
        matrix_dyanimcs_GD_tmp[2,:] = [k_opt_GD[i,j]*H, a+b*l_opt_GD[i,j]-k_opt_GD[i,j]*H]

        # Compute eigenvalues and eigenvectors
        eigen_results_GD = eigen(matrix_dyanimcs_GD_tmp)

        # Access eigenvalues and eigenvectors (note that eigenvectors are column vectors, therefore the first eigenvector at time j with internal noise level i is eigenvectors_GD[:,1,j,i], while the second is eigenvectors_GD[:,2,j,i], while the first eigenvalue is eigenvalues_GD[1,j,i] and eigenvalues_GD[2,j,i] the second)
        eigenvalues_GD_num[:,j,i] = real.(eigen_results_GD.values)
        eigenvectors_GD_num[:,:,j,i] = real.(eigen_results_GD.vectors) 

        #Iterative GD
        matrix_dyanimcs_iterative_GD_tmp[1,:] = [a, b*l_opt_iterative_GD[i,j]]
        matrix_dyanimcs_iterative_GD_tmp[2,:] = [k_opt_iterative_GD[i,j]*H, a+b*l_opt_iterative_GD[i,j]-k_opt_iterative_GD[i,j]*H]

        # Compute eigenvalues and eigenvectors
        eigen_results_iterative_GD = eigen(matrix_dyanimcs_iterative_GD_tmp)

        # Access eigenvalues and eigenvectors (note that eigenvectors are column vectors, therefore the first eigenvector at time j with internal noise level i is eigenvectors_iterative_GD[:,1,j,i], while the second is eigenvectors_iterative_GD[:,2,j,i], while the first eigenvalue is eigenvalues_iterative_GD[1,j,i] and eigenvalues_iterative_GD[2,j,i] the second)
        eigenvalues_iterative_GD_num[:,j,i] = real.(eigen_results_iterative_GD.values)
        eigenvectors_iterative_GD_num[:,:,j,i] = real.(eigen_results_iterative_GD.vectors)    

        #Angles between eigenvectors 
        angles_between_eigen_TOD_num[1,j,i] = angle_between_vectors(eigenvectors_TOD_num[:,1,j,i], eigenvectors_TOD_num[:,2,j,i], reset_180)
        angles_between_eigen_GD_num[1,j,i] = angle_between_vectors(eigenvectors_GD_num[:,1,j,i], eigenvectors_GD_num[:,2,j,i], reset_180)
        angles_between_eigen_iterative_GD_num[1,j,i] = angle_between_vectors(eigenvectors_iterative_GD_num[:,1,j,i], eigenvectors_iterative_GD_num[:,2,j,i], reset_180)

    end

end

#(3.1): Angles between eigenvectors: comparison between Todorov and GD 

#common ylims 
# ylim_min_angles = minimum([minimum(angles_between_eigen_iterative_GD[1,:,:]),minimum(angles_between_eigen_GD[1,:,:]),minimum(angles_between_eigen_TOD[1,:,:])]) 
# ylim_max_angles = maximum([maximum(angles_between_eigen_iterative_GD[1,:,:]),maximum(angles_between_eigen_GD[1,:,:]),maximum(angles_between_eigen_TOD[1,:,:])]) 

#ylim_min_angles = minimum([minimum(angles_between_eigen_GD[1,:,:]),minimum(angles_between_eigen_TOD[1,:,:])]) 
ylim_min_angles = -5
ylim_max_angles = maximum([maximum(angles_between_eigen_GD[1,2:end,:]),maximum(angles_between_eigen_TOD[1,2:end,:])]) 

plt_iterative_GD_all_angles = plot(angles_between_eigen_iterative_GD[1,2:end,1], title = L"\mathrm{Iterative}-GD", titlefont = font(14,"Computer Modern"), xlabel = L"$t$", lw = 3, color = cgrad(:Oranges_5, length(σ_η_vec))[1], ylims = (ylim_min_angles, ylim_max_angles))
plt_TOD_all_angles = plot(angles_between_eigen_TOD[1,2:end,1], title = L"TOD", titlefont = font(14,"Computer Modern"), ylabel = L"$\theta(t)$", xlabel = L"$t$", lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[1], ylims = (ylim_min_angles, ylim_max_angles))
plt_GD_all_angles = plot(angles_between_eigen_GD[1,2:end,1], title = L"GD", titlefont = font(14,"Computer Modern"), xlabel = L"$t$", lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[1], ylims = (ylim_min_angles, ylim_max_angles), yticks = [])

for i in 2:length(σ_η_vec)

    plot!(plt_iterative_GD_all_angles, angles_between_eigen_iterative_GD[1,2:end,i], lw = 3, color = cgrad(:Oranges_5, length(σ_η_vec))[i])
    plot!(plt_TOD_all_angles, angles_between_eigen_TOD[1,2:end,i], lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[i])
    plot!(plt_GD_all_angles, angles_between_eigen_GD[1,2:end,i], lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[i])

end

#layout_all_angles = @layout [a b c]
layout_all_angles = @layout [a b]

#plt_all_angles = plot(plt_TOD_all_angles, plt_GD_all_angles, plt_iterative_GD_all_angles, layout = layout_all_angles, leg = false, grid = false, size = (700, 400))

plt_all_angles = plot(plt_TOD_all_angles, plt_GD_all_angles, layout = layout_all_angles, leg = false, grid = false)
plt_all_angles = plot(plt_all_angles, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), leg = false, grid = false)

name_and_path_plot = full_folder_save_plots * "/all_angles_comparison_TOD_GD" * name_plots * ".pdf" 
savefig(plt_all_angles, name_and_path_plot)

#------------------- (4) Plot of the quantities Ω_t, Γ_t and e_t ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Function to compute the quantities Ω_t, Γ_t and |e_t| given the moments over time
function compute_Omega_Gamma_and_absolute_error_given_moments(moments_over_time)
    #Note that moments_over_time is a 3D array with dimensions (3,T), where the first dimension is the vector w = [<x_t*x_t>, <z_t*z_t>, <x_t*z_t>]
    #Ω_t = <z_t*z_t> - <x_t*z_t> 
    #Γ_t = <x_t*x_t> - <x_t*z_t> 
    #|e_t| = sqrt(<x_t*x_t> + <z_t*z_t> - 2<x_t*z_t>)

    Ω_t = zeros(T)
    Γ_t = zeros(T)
    absolute_error_t = zeros(T)

    for j in 1:T
        Ω_t[j] = moments_over_time[2,j] - moments_over_time[3,j]
        Γ_t[j] = moments_over_time[1,j] - moments_over_time[3,j]
        absolute_error_t[j] = sqrt(moments_over_time[1,j] + moments_over_time[2,j] - 2*moments_over_time[3,j])
    end

    return Ω_t, Γ_t, absolute_error_t
end

Omega_t_GD = zeros(T,length(σ_η_vec))
Gamma_t_GD = zeros(T,length(σ_η_vec))
absolute_error_t_GD = zeros(T,length(σ_η_vec))
Omega_t_TOD = zeros(T,length(σ_η_vec))
Gamma_t_TOD = zeros(T,length(σ_η_vec))
absolute_error_t_TOD = zeros(T,length(σ_η_vec))
Omega_t_iterative_GD = zeros(T,length(σ_η_vec))
Gamma_t_iterative_GD = zeros(T,length(σ_η_vec))
absolute_error_t_iterative_GD = zeros(T,length(σ_η_vec))

for i in 1:length(σ_η_vec)
    moments_over_time_GD = propagation_of_moments(Σ_x_0, Σ_z_0, μ_x_0, μ_z_0, T, a, b, m, n, H, k_opt_GD[i,:], l_opt_GD[i,:], σ_ξ, σ_ϵ_control_dep_noise, σ_ω_add_sensory_noise, σ_ρ_mult_sensory_noise, σ_η_vec[i])
    Omega_t_GD[:,i], Gamma_t_GD[:,i], absolute_error_t_GD[:,i] = compute_Omega_Gamma_and_absolute_error_given_moments(moments_over_time_GD)
    moments_over_time_TOD = propagation_of_moments(Σ_x_0, Σ_z_0, μ_x_0, μ_z_0, T, a, b, m, n, H, k_opt_TOD[i,:], l_opt_TOD[i,:], σ_ξ, σ_ϵ_control_dep_noise, σ_ω_add_sensory_noise, σ_ρ_mult_sensory_noise, σ_η_vec[i])
    Omega_t_TOD[:,i], Gamma_t_TOD[:,i], absolute_error_t_TOD[:,i] = compute_Omega_Gamma_and_absolute_error_given_moments(moments_over_time_TOD)
    moments_over_time_iterative_GD = propagation_of_moments(Σ_x_0, Σ_z_0, μ_x_0, μ_z_0, T, a, b, m, n, H, k_opt_iterative_GD[i,:], l_opt_iterative_GD[i,:], σ_ξ, σ_ϵ_control_dep_noise, σ_ω_add_sensory_noise, σ_ρ_mult_sensory_noise, σ_η_vec[i])
    Omega_t_iterative_GD[:,i], Gamma_t_iterative_GD[:,i], absolute_error_t_iterative_GD[:,i] = compute_Omega_Gamma_and_absolute_error_given_moments(moments_over_time_iterative_GD)
end

#average over time to get the mean values 
Omega_mean_GD = mean(Omega_t_GD, dims = 1)
Omega_mean_TOD = mean(Omega_t_TOD, dims = 1)
Gamma_mean_GD = mean(Gamma_t_GD, dims = 1)
Gamma_mean_TOD = mean(Gamma_t_TOD, dims = 1)
absolute_error_mean_GD = mean(absolute_error_t_GD, dims = 1)
absolute_error_mean_TOD = mean(absolute_error_t_TOD, dims = 1)

#plots 
plt_TOD_GD_Omega = plot(σ_η_vec, Omega_mean_TOD[1,:], title = "", titlefont = font(14,"Computer Modern"), ylabel = L"$\langle \Omega \rangle$", xlabel = L"$\sigma_{\eta}^{optim}$", lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[end])
plot!(plt_TOD_GD_Omega, σ_η_vec, Omega_mean_GD[1,:], lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[end])

plt_Omega_TOD_GD = plot(plt_TOD_GD_Omega, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), leg = false, grid = false)

plt_TOD_GD_Gamma = plot(σ_η_vec, Gamma_mean_TOD[1,:], title = "", titlefont = font(14,"Computer Modern"), ylabel = L"$\langle \Gamma \rangle$", xlabel = L"$\sigma_{\eta}^{optim}$", lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[end])
plot!(plt_TOD_GD_Gamma, σ_η_vec, Gamma_mean_GD[1,:], lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[end])

plt_Gamma_TOD_GD = plot(plt_TOD_GD_Gamma, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), leg = false, grid = false)

plt_TOD_GD_absolute_error = plot(σ_η_vec, absolute_error_mean_TOD[1,:], title = "", titlefont = font(14,"Computer Modern"), ylabel = L"$\langle |e_t| \rangle$", xlabel = L"$\sigma_{\eta}^{optim}$", lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[end])
plot!(plt_TOD_GD_absolute_error, σ_η_vec, absolute_error_mean_GD[1,:], lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[end])

plt_absolute_error_TOD_GD = plot(plt_TOD_GD_absolute_error, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), leg = false, grid = false)

name_and_path_plot = full_folder_save_plots * "/Omega_t_TOD_GD_" * name_plots * ".pdf" 
savefig(plt_Omega_TOD_GD, name_and_path_plot)

name_and_path_plot = full_folder_save_plots * "/Gamma_t_TOD_GD_" * name_plots * ".pdf" 
savefig(plt_Gamma_TOD_GD, name_and_path_plot)

name_and_path_plot = full_folder_save_plots * "/absolute_error_t_TOD_GD_" * name_plots * ".pdf" 
savefig(plt_absolute_error_TOD_GD, name_and_path_plot)

#------------------- (5) Adaptability to different levels of internal noise ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

σ_η_vec_adaptability = my_dict_params["σ_η_internal_noise_min_adaptability"]:my_dict_params["Δ_σ_η_internal_noise_adaptability"]:my_dict_params["σ_η_internal_noise_max_adaptability"]

# min_noise_adapt = minimum([minimum(MC_cost_iterative_GD_noise_adapt[:,:]), minimum(MC_cost_TOD_noise_adapt[:,:]), minimum(MC_cost_GD_noise_adapt[:,:]), minimum(MC_cost_HEUR_GD_noise_adapt[:,:])])
# max_noise_adapt = maximum([maximum(MC_cost_iterative_GD_noise_adapt[:,:]), maximum(MC_cost_TOD_noise_adapt[:,:]), maximum(MC_cost_GD_noise_adapt[:,:]), maximum(MC_cost_HEUR_GD_noise_adapt[:,:])])

min_noise_adapt = minimum([minimum(MC_cost_TOD_noise_adapt[:,:]), minimum(MC_cost_GD_noise_adapt[:,:])])
max_noise_adapt = maximum([maximum(MC_cost_TOD_noise_adapt[:,:]), maximum(MC_cost_GD_noise_adapt[:,:])])

clims_noise_adapt = (min_noise_adapt, max_noise_adapt)
heatmapd_iterative_GD = heatmap(σ_η_vec, σ_η_vec_adaptability, MC_cost_iterative_GD_noise_adapt, color =:thermal, clims = clims_noise_adapt, title = L"\mathrm{Iterative}-GD", titlefont = font(14,"Computer Modern"), xlabel = L"\sigma_{\eta}^{optim}", yticks = [], colorbar=false, xticks = [0,2])
heatmapd_TOD = heatmap(σ_η_vec, σ_η_vec_adaptability, MC_cost_TOD_noise_adapt, color =:thermal, colorbar=false, clims = clims_noise_adapt, title = L"TOD", titlefont = font(14,"Computer Modern"), xlabel = L"\sigma_{\eta}^{optim}", ylabel = L"\sigma_{\eta}^{test}", xticks = [0,2])
heatmapd_GD = heatmap(σ_η_vec, σ_η_vec_adaptability, MC_cost_GD_noise_adapt, color =:thermal, colorbar=false, clims = clims_noise_adapt, title = L"GD", titlefont = font(14,"Computer Modern"), xlabel = L"\sigma_{\eta}^{optim}", yticks = [], xticks = [0,1,2])

h2 = plot([0,0], [0,0], zcolor=[0,3], clims=clims_noise_adapt, xlims=(0.2,0.3), label="", c=:thermal, colorbar_title = L"$\ \ J$", framestyle=:none, seriestype=:scatter, right_margin = 3Plots.mm, markersize = 0)

h3 = plot([0,0], [0,0], zcolor=[0,3], clims=(0.0,2.0), xlims=(0.2,0.3), label="", c=:Greys_5, colorbar_title = "", framestyle=:none, seriestype=:scatter, right_margin = 3Plots.mm, markersize = 0)

name_and_path_plot = full_folder_save_plots * "/color_code" * name_plots * ".pdf" 
savefig(h3, name_and_path_plot)

#plot([0,0], [0,0], zcolor=[0,3], clims=clims_noise_adapt, xlims=(0.0,0.3), label="", c=:thermal, colorbar_title = "\ncost", framestyle=:none, seriestype=:scatter, right_margin = 3Plots.mm, markersize = 0, xticks = [250,2250])


# layout_noise_adapt = @layout [grid(1, 4) a{0.035w}]

# plt_heatmap_all = plot(heatmapd_TOD, heatmapd_GD, heatmapd_HEUR_GD, heatmapd_iterative_GD, h2, layout=layout_noise_adapt, thickness_scaling=2, size = (1300, 600))
# plt_heatmap_all = plot(plt_heatmap_all, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), grid = false)

layout_noise_adapt = @layout [grid(1, 2) a{0.035w}]

plt_heatmap_all = plot(heatmapd_TOD, heatmapd_GD, h2, layout=layout_noise_adapt, thickness_scaling=2, size = (1300, 600))
plt_heatmap_all = plot(plt_heatmap_all, xtickfontsize=12, ytickfontsize=12, xguidefontsize=18, yguidefontsize=18, thickness_scaling=2.0, size = (1300, 600), grid = false)


name_and_path_plot = full_folder_save_plots * "/adaptability_to_external_noise_" * name_plots * ".pdf" 
savefig(plt_heatmap_all, name_and_path_plot)

#------------------- OTHER USEFUL PLOTS  ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

# #(3.2): First and second eigenvalue as a function of time, for different levels of internal noise --> show "fluctuations"

# #common ylims 
# # ylim_min_first_eigen = minimum([minimum(eigenvalues_iterative_GD[1,:,:]),minimum(eigenvalues_GD[1,:,:]),minimum(eigenvalues_TOD[1,:,:])]) 
# # ylim_max_first_eigen = maximum([maximum(eigenvalues_iterative_GD[1,:,:]),maximum(eigenvalues_GD[1,:,:]),maximum(eigenvalues_TOD[1,:,:])]) 

# ylim_min_first_eigen = minimum([minimum(eigenvalues_GD[1,:,:]),minimum(eigenvalues_TOD[1,:,:])]) 
# ylim_max_first_eigen = maximum([maximum(eigenvalues_GD[1,:,:]),maximum(eigenvalues_TOD[1,:,:])]) 

# # ylim_min_second_eigen = minimum([minimum(eigenvalues_iterative_GD[2,:,:]),minimum(eigenvalues_GD[2,:,:]),minimum(eigenvalues_TOD[2,:,:])]) 
# # ylim_max_second_eigen = maximum([maximum(eigenvalues_iterative_GD[2,:,:]),maximum(eigenvalues_GD[2,:,:]),maximum(eigenvalues_TOD[2,:,:])]) 

# ylim_min_second_eigen = -1.5
# ylim_max_second_eigen = 1.5

# plt_iterative_GD_first_eigenvalue = plot(eigenvalues_iterative_GD[1,:,1], title = "Coordinate Descent", titlefont = font(12,"Computer Modern"), lw = 3, color = cgrad(:Oranges_5, length(σ_η_vec))[1], ylims = (ylim_min_first_eigen, ylim_max_first_eigen))
# plt_TOD_first_eigenvalue = plot(eigenvalues_TOD[1,:,1], title = "TODOROV", titlefont = font(12,"Computer Modern"), ylabel = L"$\lambda_1(t)$", lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[1], ylims = (ylim_min_first_eigen, ylim_max_first_eigen))
# plt_GD_first_eigenvalue = plot(eigenvalues_GD[1,:,1], title = "GD", titlefont = font(12,"Computer Modern"), lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[1], ylims = (ylim_min_first_eigen, ylim_max_first_eigen))

# #horizontal lines to see the region of stability
# hline!(plt_iterative_GD_first_eigenvalue, [1], linestyle=:dash, color =:black, lw = 2)
# hline!(plt_iterative_GD_first_eigenvalue, [-1], linestyle=:dash, color =:black, lw = 2)

# hline!(plt_GD_first_eigenvalue, [1], linestyle=:dash, color =:black, lw = 2)
# hline!(plt_GD_first_eigenvalue, [-1], linestyle=:dash, color =:black, lw = 2)

# hline!(plt_TOD_first_eigenvalue, [1], linestyle=:dash, color =:black, lw = 2)
# hline!(plt_TOD_first_eigenvalue, [-1], linestyle=:dash, color =:black, lw = 2)

# plt_iterative_GD_second_eigenvalue = plot(eigenvalues_iterative_GD[2,:,1], title = "", titlefont = font(12,"Computer Modern"), xlabel = L"$t$", lw = 3, color = cgrad(:Oranges_5, length(σ_η_vec))[1], ylims = (ylim_min_second_eigen, ylim_max_second_eigen))
# plt_TOD_second_eigenvalue = plot(eigenvalues_TOD[2,:,1], title = "", titlefont = font(12,"Computer Modern"), ylabel = L"$\lambda_2(t)$", xlabel = L"$t$", lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[1], ylims = (ylim_min_second_eigen, ylim_max_second_eigen))
# plt_GD_second_eigenvalue = plot(eigenvalues_GD[2,:,1], title = "", titlefont = font(12,"Computer Modern"), xlabel = L"$t$", lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[1], ylims = (ylim_min_second_eigen, ylim_max_second_eigen))

# hline!(plt_iterative_GD_second_eigenvalue, [1], linestyle=:dash, color =:black, lw = 2, ylims = (ylim_min_second_eigen, ylim_max_second_eigen))
# hline!(plt_iterative_GD_second_eigenvalue, [-1], linestyle=:dash, color =:black, lw = 2, ylims = (ylim_min_second_eigen, ylim_max_second_eigen))

# hline!(plt_GD_second_eigenvalue, [1], linestyle=:dash, color =:black, lw = 2, ylims = (ylim_min_second_eigen, ylim_max_second_eigen))
# hline!(plt_GD_second_eigenvalue, [-1], linestyle=:dash, color =:black, lw = 2, ylims = (ylim_min_second_eigen, ylim_max_second_eigen))

# hline!(plt_TOD_second_eigenvalue, [1], linestyle=:dash, color =:black, lw = 2, ylims = (ylim_min_second_eigen, ylim_max_second_eigen))
# hline!(plt_TOD_second_eigenvalue, [-1], linestyle=:dash, color =:black, lw = 2, ylims = (ylim_min_second_eigen, ylim_max_second_eigen))

# for i in 2:length(σ_η_vec)

#     plot!(plt_iterative_GD_first_eigenvalue, eigenvalues_iterative_GD[1,:,i], lw = 3, color = cgrad(:Oranges_5, length(σ_η_vec))[i])
#     plot!(plt_TOD_first_eigenvalue, eigenvalues_TOD[1,:,i], lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[i])
#     plot!(plt_GD_first_eigenvalue, eigenvalues_GD[1,:,i], lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[i])

#     plot!(plt_iterative_GD_second_eigenvalue, eigenvalues_iterative_GD[2,:,i], lw = 3, color = cgrad(:Oranges_5, length(σ_η_vec))[i])
#     plot!(plt_TOD_second_eigenvalue, eigenvalues_TOD[2,:,i], lw = 3, color = cgrad(:Blues_5, length(σ_η_vec))[i])
#     plot!(plt_GD_second_eigenvalue, eigenvalues_GD[2,:,i], lw = 3, color = cgrad(:BuGn_5, length(σ_η_vec))[i])

# end

# layout_all_eigenvalues = @layout [a b c; d e f]

# #plt_all_eigenvalues = plot(plt_TOD_first_eigenvalue, plt_GD_first_eigenvalue, plt_iterative_GD_first_eigenvalue, plt_TOD_second_eigenvalue, plt_GD_second_eigenvalue, plt_iterative_GD_second_eigenvalue, layout = layout_all_eigenvalues, leg = false, grid = false, size = (700, 400))
# #name_and_path_plot = full_folder_save_plots * "/all_eigenvalues_comparison_" * name_plots * ".png" 

# layout_all_eigenvalues_TOD_GD = @layout [a b; c d]

# plt_all_eigenvalues_TOD_GD = plot(plt_TOD_first_eigenvalue, plt_GD_first_eigenvalue, plt_TOD_second_eigenvalue, plt_GD_second_eigenvalue, layout = layout_all_eigenvalues_TOD_GD, leg = false, grid = false, size = (700, 400))
# name_and_path_plot = full_folder_save_plots * "/all_eigenvalues_comparison_TOD_GD" * name_plots * ".png" 
# savefig(plt_all_eigenvalues_TOD_GD, name_and_path_plot)


#------------------- (5) Study oscillations with vector fields visualization ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

# # --> We should explain why we get better results with Coordinate descent!

# #(5.1): Improvement in performances --> compare GD and It-GD
# plt_cost_It_GD = plot(σ_η_vec, MC_cost_GD_optim .- MC_cost_iterative_GD_optim, ribbon = sqrt.(MC_std_cost_GD_optim.^2 .+ MC_std_cost_iterative_GD_optim.^2), title = "", titlefont = font(12,"Computer Modern"), xlabel = L"$\sigma_{\eta}$", ylabel = L"$C_{GD} - C_{CD}$", lw = 3, leg = false, grid = false, size = (700, 400))

# name_and_path_plot = full_folder_save_plots * "/costs_GD_It_GD_" * name_plots * ".png" 
# savefig(plt_cost_It_GD, name_and_path_plot)

# #(5.2): Optimal solutions
# plt_iterative_GD_solutions_k = plot(k_opt_iterative_GD[1,:], title = "Optimal filters - CD", titlefont = font(12,"Computer Modern"), ylabel = L"$k(t)$", xlabel = L"$t$", lw = 3, color = cgrad(:Oranges_5, length(σ_η_vec))[1])
# plt_iterative_GD_solutions_l = plot(l_opt_iterative_GD[1,:], title = "Optimal controller - CD", titlefont = font(12,"Computer Modern"), ylabel = L"$l(t)$", xlabel = L"$t$", lw = 3, color = cgrad(:Oranges_5, length(σ_η_vec))[1])

# for i in 2:length(σ_η_vec)

#     plot!(plt_iterative_GD_solutions_k, k_opt_iterative_GD[i,:], lw = 3, color = cgrad(:Oranges_5, length(σ_η_vec))[i])
#     plot!(plt_iterative_GD_solutions_l, l_opt_iterative_GD[i,:], lw = 3, color = cgrad(:Oranges_5, length(σ_η_vec))[i])
    
# end

# layout_sol = @layout [a b]

# plt_optimal_sol_It_GD = plot(plt_iterative_GD_solutions_k, plt_iterative_GD_solutions_l, layout = layout_sol, leg = false, grid = false, size = (700, 400))
# name_and_path_plot = full_folder_save_plots * "/optimal_sol_It_GD_" * name_plots * ".png" 
# savefig(plt_optimal_sol_It_GD, name_and_path_plot)

# #(5.3): Understanding oscillatory behaviour (and improvement in performances for CD) for large internal noise: vector field plots

# #Here we study the vector fields over time in the three approaches, as a complement of the previous studies.

# function plot_vector_field(a, b, l_t, k_t, time_step, T, eigenvector_1, eigenvector_2, eigenvalue_1, eigenvalue_2, x_lims_plt, y_lims_plt, title_text, ylabel_on, xlabel_on)
    
#     matrix_dynamics_tmp = zeros(2,2)
#     matrix_dynamics_tmp[1,:] = [a, b*l_t]
#     matrix_dynamics_tmp[2,:] = [k_t, a+b*l_t-k_t]

#     x_0 = 0
#     y_0 = 0

#     x_1_eigen_1 = eigenvector_1[1] 
#     y_1_eigen_1 = eigenvector_1[2] 

#     x_1_eigen_2 = eigenvector_2[1] 
#     y_1_eigen_2 = eigenvector_2[2]

#     #x_values_plt = collect(x_lims_plt[1]:0.001:x_lims_plt[2])
    
#     x_values_plt = collect(-2:0.25:2)
#     y_values_plt = collect(-2:0.25:2)

#     x_parametric_eigen_1 = x_0 .+ x_values_plt .* (x_1_eigen_1 - x_0)
#     y_parametric_eigen_1 = y_0 .+ x_values_plt .* (y_1_eigen_1 - y_0)

#     x_parametric_eigen_2 = x_0 .+ x_values_plt .* (x_1_eigen_2 - x_0)
#     y_parametric_eigen_2 = y_0 .+ x_values_plt .* (y_1_eigen_2 - y_0)

#     # Create a grid of points
#     point_grid = [(x, y) for x in x_values_plt, y in y_values_plt]

#     # Initialize an empty array to store vectors
#     vectors = []
    
#     # Compute vector values based on A(t) for each point on the grid at the chosen time step
#     push!(vectors, [(matrix_dynamics_tmp * [x, y]) for (x, y) in point_grid])

#     point_grid_index = [(i, j) for i in 1:length(x_values_plt), j in 1:length(y_values_plt)]

#     if ylabel_on == 1 && xlabel_on == 1
#         plt = plot(title = title_text, titlefont = font(12,"Computer Modern"), grid = false, xlabel = L"$ \hat{x} $", ylabel = L"$ x $", xlims = (x_lims_plt[1], x_lims_plt[2]), ylims = (y_lims_plt[1], y_lims_plt[2]))
#     elseif ylabel_on == 0 && xlabel_on == 1
#         plt = plot(title = title_text, titlefont = font(12,"Computer Modern"), grid = false, xlabel = L"$ \hat{x} $", ylabel = "", xlims = (x_lims_plt[1], x_lims_plt[2]), ylims = (y_lims_plt[1], y_lims_plt[2]))
#     elseif ylabel_on == 1 && xlabel_on == 0
#         plt = plot(title = title_text, titlefont = font(12,"Computer Modern"), grid = false, xlabel = "", ylabel = L"$ x $", xlims = (x_lims_plt[1], x_lims_plt[2]), ylims = (y_lims_plt[1], y_lims_plt[2]))
#     elseif ylabel_on == 0 && xlabel_on == 0
#         plt = plot(title = title_text, titlefont = font(12,"Computer Modern"), grid = false, xlabel = "", ylabel = "", xlims = (x_lims_plt[1], x_lims_plt[2]), ylims = (y_lims_plt[1], y_lims_plt[2]))
#     end
    
#     plot!(plt, x_parametric_eigen_1, y_parametric_eigen_1, lw = 4, label = L"$ 1st$ eigen, $\lambda_1 =$" *string(round(eigenvalue_1, digits=2)), line =:dash)
#     plot!(plt, x_parametric_eigen_2, y_parametric_eigen_2, lw = 4, label = L"$ 2nd$ eigen, $\lambda_2 =$" *string(round(eigenvalue_2, digits=2)), line =:dash)

#     for (i,j) in point_grid_index
#         Plots.quiver!(plt, [x_values_plt[i]], [y_values_plt[j]], quiver=([vectors[1][i, j][1]], [vectors[1][i, j][2]]), color = cgrad(:Accent_3, T-1)[time_step])
#     end    

#     return plt

# end

# # Define the grid of points
# x_lims_plt = [-1.5,1.5]
# y_lims_plt = [-1.5,1.5]

# time_step_vector_field = 10
# noise_lev_vector_field = 11

# number_eigenvector_1 = 1
# number_eigenvector_2 = 2

# σ_η_tmp = σ_η_vec[noise_lev_vector_field]

# title_text_iterative_GD_1 = latexstring("\$ CD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $time_step_vector_field\$")
# title_text_iterative_GD_2 = latexstring("\$ CD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $(time_step_vector_field+1)\$")
# title_text_iterative_GD_3 = latexstring("\$ CD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $(time_step_vector_field+2)\$")
# title_text_iterative_GD_4 = latexstring("\$ CD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $(time_step_vector_field+3)\$")

# l_t_iterative_GD_1 = l_opt_iterative_GD[noise_lev_vector_field,time_step_vector_field]
# k_t_iterative_GD_1 = k_opt_iterative_GD[noise_lev_vector_field,time_step_vector_field]

# l_t_iterative_GD_2 = l_opt_iterative_GD[noise_lev_vector_field,time_step_vector_field+1]
# k_t_iterative_GD_2 = k_opt_iterative_GD[noise_lev_vector_field,time_step_vector_field+1]

# l_t_iterative_GD_3 = l_opt_iterative_GD[noise_lev_vector_field,time_step_vector_field+2]
# k_t_iterative_GD_3 = k_opt_iterative_GD[noise_lev_vector_field,time_step_vector_field+2]

# l_t_iterative_GD_4 = l_opt_iterative_GD[noise_lev_vector_field,time_step_vector_field+3]
# k_t_iterative_GD_4 = k_opt_iterative_GD[noise_lev_vector_field,time_step_vector_field+3]

# eigenvector_1_iterative_GD_1 = eigenvectors_iterative_GD[:,number_eigenvector_1,time_step_vector_field,noise_lev_vector_field]
# eigenvector_2_iterative_GD_1 = eigenvectors_iterative_GD[:,number_eigenvector_2,time_step_vector_field,noise_lev_vector_field]

# eigenvalue_1_iterative_GD_1 = eigenvalues_iterative_GD[number_eigenvector_1,time_step_vector_field,noise_lev_vector_field]
# eigenvalue_2_iterative_GD_1 = eigenvalues_iterative_GD[number_eigenvector_2,time_step_vector_field,noise_lev_vector_field]

# eigenvector_1_iterative_GD_2 = eigenvectors_iterative_GD[:,number_eigenvector_1,time_step_vector_field + 1,noise_lev_vector_field]
# eigenvector_2_iterative_GD_2 = eigenvectors_iterative_GD[:,number_eigenvector_2,time_step_vector_field + 1,noise_lev_vector_field]

# eigenvalue_1_iterative_GD_2 = eigenvalues_iterative_GD[number_eigenvector_1,time_step_vector_field + 1,noise_lev_vector_field]
# eigenvalue_2_iterative_GD_2 = eigenvalues_iterative_GD[number_eigenvector_2,time_step_vector_field + 1,noise_lev_vector_field]

# eigenvector_1_iterative_GD_3 = eigenvectors_iterative_GD[:,number_eigenvector_1,time_step_vector_field + 2,noise_lev_vector_field]
# eigenvector_2_iterative_GD_3 = eigenvectors_iterative_GD[:,number_eigenvector_2,time_step_vector_field + 2,noise_lev_vector_field]

# eigenvalue_1_iterative_GD_3 = eigenvalues_iterative_GD[number_eigenvector_1,time_step_vector_field + 2,noise_lev_vector_field]
# eigenvalue_2_iterative_GD_3 = eigenvalues_iterative_GD[number_eigenvector_2,time_step_vector_field + 2,noise_lev_vector_field]

# eigenvector_1_iterative_GD_4 = eigenvectors_iterative_GD[:,number_eigenvector_1,time_step_vector_field + 3,noise_lev_vector_field]
# eigenvector_2_iterative_GD_4 = eigenvectors_iterative_GD[:,number_eigenvector_2,time_step_vector_field + 3,noise_lev_vector_field]

# eigenvalue_1_iterative_GD_4 = eigenvalues_iterative_GD[number_eigenvector_1,time_step_vector_field + 3,noise_lev_vector_field]
# eigenvalue_2_iterative_GD_4 = eigenvalues_iterative_GD[number_eigenvector_2,time_step_vector_field + 3,noise_lev_vector_field]

# ylabel_on_iterative_GD_1 = 1
# ylabel_on_iterative_GD_2 = 0
# ylabel_on_iterative_GD_3 = 1
# ylabel_on_iterative_GD_4 = 0

# xlabel_on_iterative_GD_1 = 0
# xlabel_on_iterative_GD_2 = 0
# xlabel_on_iterative_GD_3 = 1
# xlabel_on_iterative_GD_4 = 1

# plt_iterative_GD_1 = plot_vector_field(a, b, l_t_iterative_GD_1, k_t_iterative_GD_1, time_step_vector_field, T, eigenvector_1_iterative_GD_1, eigenvector_2_iterative_GD_1, eigenvalue_1_iterative_GD_1, eigenvalue_2_iterative_GD_1, x_lims_plt, y_lims_plt, title_text_iterative_GD_1, ylabel_on_iterative_GD_1, xlabel_on_iterative_GD_1)
# plt_iterative_GD_2 = plot_vector_field(a, b, l_t_iterative_GD_2, k_t_iterative_GD_2, time_step_vector_field + 1, T, eigenvector_1_iterative_GD_2, eigenvector_2_iterative_GD_2, eigenvalue_1_iterative_GD_2, eigenvalue_2_iterative_GD_2, x_lims_plt, y_lims_plt, title_text_iterative_GD_2, ylabel_on_iterative_GD_2, xlabel_on_iterative_GD_2)
# plt_iterative_GD_3 = plot_vector_field(a, b, l_t_iterative_GD_3, k_t_iterative_GD_3, time_step_vector_field + 2, T, eigenvector_1_iterative_GD_3, eigenvector_2_iterative_GD_3, eigenvalue_1_iterative_GD_3, eigenvalue_2_iterative_GD_3, x_lims_plt, y_lims_plt, title_text_iterative_GD_3, ylabel_on_iterative_GD_3, xlabel_on_iterative_GD_3)
# plt_iterative_GD_4 = plot_vector_field(a, b, l_t_iterative_GD_4, k_t_iterative_GD_4, time_step_vector_field + 3, T, eigenvector_1_iterative_GD_4, eigenvector_2_iterative_GD_4, eigenvalue_1_iterative_GD_4, eigenvalue_2_iterative_GD_4, x_lims_plt, y_lims_plt, title_text_iterative_GD_4, ylabel_on_iterative_GD_4, xlabel_on_iterative_GD_4)

# layout_vector_fields = @layout [a b; c d]

# plt_it_GD_vector_field = plot(plt_iterative_GD_1, plt_iterative_GD_2, plt_iterative_GD_3, plt_iterative_GD_4, layout = layout_vector_fields, size = (700, 400))
# name_and_path_plot = full_folder_save_plots * "/vector_field_It_GD_" * name_plots * ".png" 
# savefig(plt_it_GD_vector_field, name_and_path_plot)


# #TODOROV

# title_text_TOD_1 = latexstring("\$ TOD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $time_step_vector_field\$")
# title_text_TOD_2 = latexstring("\$ TOD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $(time_step_vector_field+1)\$")
# title_text_TOD_3 = latexstring("\$ TOD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $(time_step_vector_field+2)\$")
# title_text_TOD_4 = latexstring("\$ TOD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $(time_step_vector_field+3)\$")

# l_t_TOD_1 = l_opt_TOD[noise_lev_vector_field,time_step_vector_field]
# k_t_TOD_1 = k_opt_TOD[noise_lev_vector_field,time_step_vector_field]

# l_t_TOD_2 = l_opt_TOD[noise_lev_vector_field,time_step_vector_field+1]
# k_t_TOD_2 = k_opt_TOD[noise_lev_vector_field,time_step_vector_field+1]

# l_t_TOD_3 = l_opt_TOD[noise_lev_vector_field,time_step_vector_field+2]
# k_t_TOD_3 = k_opt_TOD[noise_lev_vector_field,time_step_vector_field+2]

# l_t_TOD_4 = l_opt_TOD[noise_lev_vector_field,time_step_vector_field+3]
# k_t_TOD_4 = k_opt_TOD[noise_lev_vector_field,time_step_vector_field+3]

# eigenvector_1_TOD_1 = eigenvectors_TOD[:,number_eigenvector_1,time_step_vector_field,noise_lev_vector_field]
# eigenvector_2_TOD_1 = eigenvectors_TOD[:,number_eigenvector_2,time_step_vector_field,noise_lev_vector_field]

# eigenvalue_1_TOD_1 = eigenvalues_TOD[number_eigenvector_1,time_step_vector_field,noise_lev_vector_field]
# eigenvalue_2_TOD_1 = eigenvalues_TOD[number_eigenvector_2,time_step_vector_field,noise_lev_vector_field]

# eigenvector_1_TOD_2 = eigenvectors_TOD[:,number_eigenvector_1,time_step_vector_field + 1,noise_lev_vector_field]
# eigenvector_2_TOD_2 = eigenvectors_TOD[:,number_eigenvector_2,time_step_vector_field + 1,noise_lev_vector_field]

# eigenvalue_1_TOD_2 = eigenvalues_TOD[number_eigenvector_1,time_step_vector_field + 1,noise_lev_vector_field]
# eigenvalue_2_TOD_2 = eigenvalues_TOD[number_eigenvector_2,time_step_vector_field + 1,noise_lev_vector_field]

# eigenvector_1_TOD_3 = eigenvectors_TOD[:,number_eigenvector_1,time_step_vector_field + 2,noise_lev_vector_field]
# eigenvector_2_TOD_3 = eigenvectors_TOD[:,number_eigenvector_2,time_step_vector_field + 2,noise_lev_vector_field]

# eigenvalue_1_TOD_3 = eigenvalues_TOD[number_eigenvector_1,time_step_vector_field + 2,noise_lev_vector_field]
# eigenvalue_2_TOD_3 = eigenvalues_TOD[number_eigenvector_2,time_step_vector_field + 2,noise_lev_vector_field]

# eigenvector_1_TOD_4 = eigenvectors_TOD[:,number_eigenvector_1,time_step_vector_field + 3,noise_lev_vector_field]
# eigenvector_2_TOD_4 = eigenvectors_TOD[:,number_eigenvector_2,time_step_vector_field + 3,noise_lev_vector_field]

# eigenvalue_1_TOD_4 = eigenvalues_TOD[number_eigenvector_1,time_step_vector_field + 3,noise_lev_vector_field]
# eigenvalue_2_TOD_4 = eigenvalues_TOD[number_eigenvector_2,time_step_vector_field + 3,noise_lev_vector_field]

# ylabel_on_TOD_1 = 1
# ylabel_on_TOD_2 = 0
# ylabel_on_TOD_3 = 1
# ylabel_on_TOD_4 = 0

# xlabel_on_TOD_1 = 0
# xlabel_on_TOD_2 = 0
# xlabel_on_TOD_3 = 1
# xlabel_on_TOD_4 = 1

# plt_TOD_1 = plot_vector_field(a, b, l_t_TOD_1, k_t_TOD_1, time_step_vector_field, T, eigenvector_1_TOD_1, eigenvector_2_TOD_1, eigenvalue_1_TOD_1, eigenvalue_2_TOD_1, x_lims_plt, y_lims_plt, title_text_TOD_1, ylabel_on_TOD_1, xlabel_on_TOD_1)
# plt_TOD_2 = plot_vector_field(a, b, l_t_TOD_2, k_t_TOD_2, time_step_vector_field + 1, T, eigenvector_1_TOD_2, eigenvector_2_TOD_2, eigenvalue_1_TOD_2, eigenvalue_2_TOD_2, x_lims_plt, y_lims_plt, title_text_TOD_2, ylabel_on_TOD_2, xlabel_on_TOD_2)
# plt_TOD_3 = plot_vector_field(a, b, l_t_TOD_3, k_t_TOD_3, time_step_vector_field + 2, T, eigenvector_1_TOD_3, eigenvector_2_TOD_3, eigenvalue_1_TOD_3, eigenvalue_2_TOD_3, x_lims_plt, y_lims_plt, title_text_TOD_3, ylabel_on_TOD_3, xlabel_on_TOD_3)
# plt_TOD_4 = plot_vector_field(a, b, l_t_TOD_4, k_t_TOD_4, time_step_vector_field + 3, T, eigenvector_1_TOD_4, eigenvector_2_TOD_4, eigenvalue_1_TOD_4, eigenvalue_2_TOD_4, x_lims_plt, y_lims_plt, title_text_TOD_4, ylabel_on_TOD_4, xlabel_on_TOD_4)

# plt_TOD_vector_field = plot(plt_TOD_1, plt_TOD_2, plt_TOD_3, plt_TOD_4, layout = layout_vector_fields, size = (700, 400))
# name_and_path_plot = full_folder_save_plots * "/vector_field_TOD_" * name_plots * ".png" 
# savefig(plt_TOD_vector_field, name_and_path_plot)

# #Heuristic GD

# title_text_HEUR_GD_1 = latexstring("\$ H-GD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $time_step_vector_field\$")
# title_text_HEUR_GD_2 = latexstring("\$ H-GD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $(time_step_vector_field+1)\$")
# title_text_HEUR_GD_3 = latexstring("\$ H-GD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $(time_step_vector_field+2)\$")
# title_text_HEUR_GD_4 = latexstring("\$ H-GD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $(time_step_vector_field+3)\$")

# l_t_HEUR_GD_1 = l_opt_HEUR_GD[noise_lev_vector_field,time_step_vector_field]
# k_t_HEUR_GD_1 = k_opt_HEUR_GD[noise_lev_vector_field,time_step_vector_field]

# l_t_HEUR_GD_2 = l_opt_HEUR_GD[noise_lev_vector_field,time_step_vector_field+1]
# k_t_HEUR_GD_2 = k_opt_HEUR_GD[noise_lev_vector_field,time_step_vector_field+1]

# l_t_HEUR_GD_3 = l_opt_HEUR_GD[noise_lev_vector_field,time_step_vector_field+2]
# k_t_HEUR_GD_3 = k_opt_HEUR_GD[noise_lev_vector_field,time_step_vector_field+2]

# l_t_HEUR_GD_4 = l_opt_HEUR_GD[noise_lev_vector_field,time_step_vector_field+3]
# k_t_HEUR_GD_4 = k_opt_HEUR_GD[noise_lev_vector_field,time_step_vector_field+3]

# eigenvector_1_HEUR_GD_1 = eigenvectors_HEUR_GD[:,number_eigenvector_1,time_step_vector_field,noise_lev_vector_field]
# eigenvector_2_HEUR_GD_1 = eigenvectors_HEUR_GD[:,number_eigenvector_2,time_step_vector_field,noise_lev_vector_field]

# eigenvalue_1_HEUR_GD_1 = eigenvalues_HEUR_GD[number_eigenvector_1,time_step_vector_field,noise_lev_vector_field]
# eigenvalue_2_HEUR_GD_1 = eigenvalues_HEUR_GD[number_eigenvector_2,time_step_vector_field,noise_lev_vector_field]

# eigenvector_1_HEUR_GD_2 = eigenvectors_HEUR_GD[:,number_eigenvector_1,time_step_vector_field + 1,noise_lev_vector_field]
# eigenvector_2_HEUR_GD_2 = eigenvectors_HEUR_GD[:,number_eigenvector_2,time_step_vector_field + 1,noise_lev_vector_field]

# eigenvalue_1_HEUR_GD_2 = eigenvalues_HEUR_GD[number_eigenvector_1,time_step_vector_field + 1,noise_lev_vector_field]
# eigenvalue_2_HEUR_GD_2 = eigenvalues_HEUR_GD[number_eigenvector_2,time_step_vector_field + 1,noise_lev_vector_field]

# eigenvector_1_HEUR_GD_3 = eigenvectors_HEUR_GD[:,number_eigenvector_1,time_step_vector_field + 2,noise_lev_vector_field]
# eigenvector_2_HEUR_GD_3 = eigenvectors_HEUR_GD[:,number_eigenvector_2,time_step_vector_field + 2,noise_lev_vector_field]

# eigenvalue_1_HEUR_GD_3 = eigenvalues_HEUR_GD[number_eigenvector_1,time_step_vector_field + 2,noise_lev_vector_field]
# eigenvalue_2_HEUR_GD_3 = eigenvalues_HEUR_GD[number_eigenvector_2,time_step_vector_field + 2,noise_lev_vector_field]

# eigenvector_1_HEUR_GD_4 = eigenvectors_HEUR_GD[:,number_eigenvector_1,time_step_vector_field + 3,noise_lev_vector_field]
# eigenvector_2_HEUR_GD_4 = eigenvectors_HEUR_GD[:,number_eigenvector_2,time_step_vector_field + 3,noise_lev_vector_field]

# eigenvalue_1_HEUR_GD_4 = eigenvalues_HEUR_GD[number_eigenvector_1,time_step_vector_field + 3,noise_lev_vector_field]
# eigenvalue_2_HEUR_GD_4 = eigenvalues_HEUR_GD[number_eigenvector_2,time_step_vector_field + 3,noise_lev_vector_field]

# ylabel_on_HEUR_GD_1 = 1
# ylabel_on_HEUR_GD_2 = 0
# ylabel_on_HEUR_GD_3 = 1
# ylabel_on_HEUR_GD_4 = 0

# xlabel_on_HEUR_GD_1 = 0
# xlabel_on_HEUR_GD_2 = 0
# xlabel_on_HEUR_GD_3 = 1
# xlabel_on_HEUR_GD_4 = 1

# plt_HEUR_GD_1 = plot_vector_field(a, b, l_t_HEUR_GD_1, k_t_HEUR_GD_1, time_step_vector_field, T, eigenvector_1_HEUR_GD_1, eigenvector_2_HEUR_GD_1, eigenvalue_1_HEUR_GD_1, eigenvalue_2_HEUR_GD_1, x_lims_plt, y_lims_plt, title_text_HEUR_GD_1, ylabel_on_HEUR_GD_1, xlabel_on_HEUR_GD_1)
# plt_HEUR_GD_2 = plot_vector_field(a, b, l_t_HEUR_GD_2, k_t_HEUR_GD_2, time_step_vector_field + 1, T, eigenvector_1_HEUR_GD_2, eigenvector_2_HEUR_GD_2, eigenvalue_1_HEUR_GD_2, eigenvalue_2_HEUR_GD_2, x_lims_plt, y_lims_plt, title_text_HEUR_GD_2, ylabel_on_HEUR_GD_2, xlabel_on_HEUR_GD_2)
# plt_HEUR_GD_3 = plot_vector_field(a, b, l_t_HEUR_GD_3, k_t_HEUR_GD_3, time_step_vector_field + 2, T, eigenvector_1_HEUR_GD_3, eigenvector_2_HEUR_GD_3, eigenvalue_1_HEUR_GD_3, eigenvalue_2_HEUR_GD_3, x_lims_plt, y_lims_plt, title_text_HEUR_GD_3, ylabel_on_HEUR_GD_3, xlabel_on_HEUR_GD_3)
# plt_HEUR_GD_4 = plot_vector_field(a, b, l_t_HEUR_GD_4, k_t_HEUR_GD_4, time_step_vector_field + 3, T, eigenvector_1_HEUR_GD_4, eigenvector_2_HEUR_GD_4, eigenvalue_1_HEUR_GD_4, eigenvalue_2_HEUR_GD_4, x_lims_plt, y_lims_plt, title_text_HEUR_GD_4, ylabel_on_HEUR_GD_4, xlabel_on_HEUR_GD_4)

# plt_HEUR_GD_vector_field = plot(plt_HEUR_GD_1, plt_HEUR_GD_2, plt_HEUR_GD_3, plt_HEUR_GD_4, layout = layout_vector_fields, size = (700, 400))
# name_and_path_plot = full_folder_save_plots * "/vector_field_HEUR_GD_" * name_plots * ".png" 
# savefig(plt_HEUR_GD_vector_field, name_and_path_plot)
# #GD

# title_text_GD_1 = latexstring("\$ GD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $time_step_vector_field\$")
# title_text_GD_2 = latexstring("\$ GD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $(time_step_vector_field+1)\$")
# title_text_GD_3 = latexstring("\$ GD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $(time_step_vector_field+2)\$")
# title_text_GD_4 = latexstring("\$ GD \\ \\ \\ \\ \\sigma_{\\eta} = $σ_η_tmp \\ \\ \\ \\ t = $(time_step_vector_field+3)\$")

# l_t_GD_1 = l_opt_GD[noise_lev_vector_field,time_step_vector_field]
# k_t_GD_1 = k_opt_GD[noise_lev_vector_field,time_step_vector_field]

# l_t_GD_2 = l_opt_GD[noise_lev_vector_field,time_step_vector_field+1]
# k_t_GD_2 = k_opt_GD[noise_lev_vector_field,time_step_vector_field+1]

# l_t_GD_3 = l_opt_GD[noise_lev_vector_field,time_step_vector_field+2]
# k_t_GD_3 = k_opt_GD[noise_lev_vector_field,time_step_vector_field+2]

# l_t_GD_4 = l_opt_GD[noise_lev_vector_field,time_step_vector_field+3]
# k_t_GD_4 = k_opt_GD[noise_lev_vector_field,time_step_vector_field+3]

# eigenvector_1_GD_1 = eigenvectors_GD[:,number_eigenvector_1,time_step_vector_field,noise_lev_vector_field]
# eigenvector_2_GD_1 = eigenvectors_GD[:,number_eigenvector_2,time_step_vector_field,noise_lev_vector_field]

# eigenvalue_1_GD_1 = eigenvalues_GD[number_eigenvector_1,time_step_vector_field,noise_lev_vector_field]
# eigenvalue_2_GD_1 = eigenvalues_GD[number_eigenvector_2,time_step_vector_field,noise_lev_vector_field]

# eigenvector_1_GD_2 = eigenvectors_GD[:,number_eigenvector_1,time_step_vector_field + 1,noise_lev_vector_field]
# eigenvector_2_GD_2 = eigenvectors_GD[:,number_eigenvector_2,time_step_vector_field + 1,noise_lev_vector_field]

# eigenvalue_1_GD_2 = eigenvalues_GD[number_eigenvector_1,time_step_vector_field + 1,noise_lev_vector_field]
# eigenvalue_2_GD_2 = eigenvalues_GD[number_eigenvector_2,time_step_vector_field + 1,noise_lev_vector_field]

# eigenvector_1_GD_3 = eigenvectors_GD[:,number_eigenvector_1,time_step_vector_field + 2,noise_lev_vector_field]
# eigenvector_2_GD_3 = eigenvectors_GD[:,number_eigenvector_2,time_step_vector_field + 2,noise_lev_vector_field]

# eigenvalue_1_GD_3 = eigenvalues_GD[number_eigenvector_1,time_step_vector_field + 2,noise_lev_vector_field]
# eigenvalue_2_GD_3 = eigenvalues_GD[number_eigenvector_2,time_step_vector_field + 2,noise_lev_vector_field]

# eigenvector_1_GD_4 = eigenvectors_GD[:,number_eigenvector_1,time_step_vector_field + 3,noise_lev_vector_field]
# eigenvector_2_GD_4 = eigenvectors_GD[:,number_eigenvector_2,time_step_vector_field + 3,noise_lev_vector_field]

# eigenvalue_1_GD_4 = eigenvalues_GD[number_eigenvector_1,time_step_vector_field + 3,noise_lev_vector_field]
# eigenvalue_2_GD_4 = eigenvalues_GD[number_eigenvector_2,time_step_vector_field + 3,noise_lev_vector_field]

# ylabel_on_GD_1 = 1
# ylabel_on_GD_2 = 0
# ylabel_on_GD_3 = 1
# ylabel_on_GD_4 = 0

# xlabel_on_GD_1 = 0
# xlabel_on_GD_2 = 0
# xlabel_on_GD_3 = 1
# xlabel_on_GD_4 = 1

# plt_GD_1 = plot_vector_field(a, b, l_t_GD_1, k_t_GD_1, time_step_vector_field, T, eigenvector_1_GD_1, eigenvector_2_GD_1, eigenvalue_1_GD_1, eigenvalue_2_GD_1, x_lims_plt, y_lims_plt, title_text_GD_1, ylabel_on_GD_1, xlabel_on_GD_1)
# plt_GD_2 = plot_vector_field(a, b, l_t_GD_2, k_t_GD_2, time_step_vector_field + 1, T, eigenvector_1_GD_2, eigenvector_2_GD_2, eigenvalue_1_GD_2, eigenvalue_2_GD_2, x_lims_plt, y_lims_plt, title_text_GD_2, ylabel_on_GD_2, xlabel_on_GD_2)
# plt_GD_3 = plot_vector_field(a, b, l_t_GD_3, k_t_GD_3, time_step_vector_field + 2, T, eigenvector_1_GD_3, eigenvector_2_GD_3, eigenvalue_1_GD_3, eigenvalue_2_GD_3, x_lims_plt, y_lims_plt, title_text_GD_3, ylabel_on_GD_3, xlabel_on_GD_3)
# plt_GD_4 = plot_vector_field(a, b, l_t_GD_4, k_t_GD_4, time_step_vector_field + 3, T, eigenvector_1_GD_4, eigenvector_2_GD_4, eigenvalue_1_GD_4, eigenvalue_2_GD_4, x_lims_plt, y_lims_plt, title_text_GD_4, ylabel_on_GD_4, xlabel_on_GD_4)

# plt_GD_vector_field = plot(plt_GD_1, plt_GD_2, plt_GD_3, plt_GD_4, layout = layout_vector_fields, size = (700, 400))
# name_and_path_plot = full_folder_save_plots * "/vector_field_GD_" * name_plots * ".png" 
# savefig(plt_GD_vector_field, name_and_path_plot)
