# UrbanKGent: A Unified Large Language Model Agent Framework for Urban Knowledge Graph Construction

<p align="center">

![Testing Status](https://img.shields.io/badge/docs-in_progress-green)
![Testing Status](https://img.shields.io/badge/pypi_package-in_progress-green)
![Testing Status](https://img.shields.io/badge/license-MIT-blue)
</p>

<p align="center">

| **[1 Introduction](#introduction)** 
| **[2 Requirements](#requirements)**
| **[3 Usage](#usage)**

</p>

<a id="introduction"></a>
## 1 Introduction

Official code for article UrbanKGent: A Unified Large Language Model Agent Framework for Urban Knowledge Graph Construction.

Urban knowledge graph has recently worked as an emerging building block to distill critical knowledge from multi-sourced urban data for diverse urban application scenarios. Despite its promising benefits, urban knowledge graph construction (UrbanKGC) still heavily relies on manual effort, hindering its potential advancement. This paper presents UrbanKGent, a unified large language model agent framework, for urban knowledge graph construction.

<a id="requirements"></a>
## 2 Requirements

`python=3.8`,`torch=2.1.1`, `transformers=4.35.2`, `accelerate=0.25.0`, `geographiclib=2.0`, `request=2.31.0`,  `geopy=2.4.1`, `geohash2=1.1`

<a id="usage"></a>

## 3 Usage

### Agent Inference
To run OpenAI LLM agent, you need to set your key in `main_TE/KGC.py`:

```
python main_KGC/TE.py
```

To run the official Llama-2 LLM agent, you should put your LLMs model into the '/data/llm_models', and then open the Llama-2 inference local-host request: 

```
python utils/open_llm_api.py
python main_KGC/TE.py
```
To run the fine-tuned Llama-2 LLM agent, you should put your LLMs model into the '/data/llm_models', and put your LLM adapter into the '/data/llm_model/', and then open the finetuned Llama-2 inference local-host request: 
```
python utils/llama_lora_api.py
python main_KGC/TE.py
```

### Agent Fine-tuning
To fine-tune tailored LLM agent, you need to prepare instruction set and put them into './sft_data/', and then finetune the model with LoRA architecture:
```
python finetune.py
```
The instruction tuning dataset is consist of trajectory generated in UrbanKGent Inferrence. We provide the example in './sft_data/', and you can construct tailored instruction tuning dataset with the similar format and process.
