"""
Produces the result for underresolved Kuramoto-Sivashinsky in 2D.

Full prediction learning with one-step supervised training.
"""
CONFIGS = [
    {
        "scenario": "diff_ks",
        "task": "predict",
        "net": net,
        "train": "one",
        "start_seed": s,
        "num_seeds": 10,
        "num_spatial_dims": 2,
        "num_points": 32,
    }
    for s in [0, 10]
    for net in [
        "Conv;26;11;relu",  # 61'595 params, 12 receptive field per direction
        "UNet;10;2;relu",  # 55'661 params, 29 receptive field per direction
        "Res;26;5;relu",  # 61'179 params, 10 receptive field per direction
        "FNO;10;6;4;gelu",  # 57'787 params, inf receptive field per direction
        "Dil;2;26;2;relu",  # 61'699 params, 20 receptive field per direction
    ]
]
