import pickle

def save_experiment(
    fun, fs, dys, val, true_jac, theta, x0, legends, n_iter, n_samples, batch_size, custom_name=None
):
    data = {
        "objective": fun.__name__,
        "iterates": fs,
        "derivatives": dys,
        "val": val,
        "true_jac": true_jac,
        "theta": theta,
        "x0": x0,
        "legends": legends,
        "n_iter": n_iter,
        "n_samples": n_samples,
        "batch_size": batch_size,
    }
    custom_name = f"-{custom_name}" if custom_name is not None else ""
    filename = f"results/{fun.__name__}_T-{n_iter}_n-{n_samples}_bs-{batch_size}{custom_name}.pickle"
    with open(filename, "wb") as f:
        pickle.dump(data, f)
    print(f"Saved to {filename}")
