# Differentiable Structure Learning with Partial Orders

This is the codes of method implementation and evaluations of tha paper "Differentiable Structure Learning with Partial Orders".
The required environments are available in `requirement.txt`, and you can use command `pip install -r requirements.txt` to install the required packages.

## Implementation codes

- `order_notears/linear.py` - Linear NOTEARS and DAGMA with partial orders, you can uncomment the corresponding lines in function `_h(W)` to use DAGMA.
- `order_notears/nonlinear.py` - NOTEARS-MLP with partial orders.
- `order_notears/transitive.py` - Manuplations on transitivities of orders and other used functions.
- `order_notears/locally_connected.py` - special layer structure used for MLP.
- `order_notears/lbfgsb_scipy.py` - wrapper for scipy's LBFGS-B.
- `order_notears/trace_expm.py` - h function for NOTEARS-MLP.
- `order_notears/utils.py` - graph simulation, data simulation, and accuracy evaluation.

## Test codes

- `PPO_notears_test.py` - interface for testing synthetic data
- `PPO_real_test.py` - interface for testing the real world dataset "sach"
- `sach.sh` - shell commands of testing sach dataset
- `singlechain_linear_notears.sh` - shell commands of testing linear NOTEARS and DAGMA (you should manually use DAGMA) with single-chained ordering
- `singlechain_notears_mlp.sh` - shell commands of testing NOTEARS-MLP with single-chained ordering
- `multichain_linear_notears.sh` - shell commands of testing linear NOTEARS and DAGMA (you should manually use DAGMA) with multi-chained ordering
- `multichain_notears_mlp.sh` - shell commands of testing NOTEARS-MLP with multi-chained ordering

## Real-world data

- `real_data/sach_853.csv` - csv file of the sach data samples
- `real_data/sach_853.txt` - txt file of the sach data samples
- `real_data/sach_graph.txt` - adjacent matrix of the sach structure
- `real_data/sach.mapping` - match the node index to the variable meaning

## Post-process codes

- `parse_result.py` - parse the output of synthetic results to csv file
- `sach_parse_result.py` - parse the output of real-world results to csv file