package ceka.KFNN;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

import ceka.consensus.MajorityVote;
import ceka.converters.FileLoader;
import ceka.core.Dataset;
import ceka.utils.PerformanceStatistic;

public class Test_R_Ablation {
	
	private static String dataSetArffDir = "./test/ceka/KFNN/real-world/";

	private static String[] dataSetArddFix = {"Income94L10"};

	private static String runDir = "./test/ceka/KFNN/KFNN-results/";
	
	private static int times = 1;
	
	
	public static void main(String[] args) throws Exception {
		
		File testDir = new File(runDir);
		if (!testDir.exists())
			testDir.mkdirs();

		// write the result to a file
		FileOutputStream f_i = new FileOutputStream(new File(runDir + "result_F1.txt"));
		PrintStream result_i = new PrintStream(f_i);

		result_i.format("%-10s	%-10s	%-10s	%-10s	%-10s", "dataset","KFNN1","KFNN2","KFNN3","KFNN4");
		result_i.println();
		
		double F1_kfnn1_all_sum = 0.0;
		double F1_kfnn2_all_sum = 0.0;
		double F1_kfnn3_all_sum = 0.0;
		double F1_kfnn4_all_sum = 0.0;
		
		for (int index = 0; index < dataSetArddFix.length; index++) {
			
			String arffxPath = dataSetArffDir + dataSetArddFix[index] + ".arff";
			String responsePath=dataSetArffDir + dataSetArddFix[index] + ".response.txt";
			String goldPath=dataSetArffDir + dataSetArddFix[index] + ".gold.txt";		
			Dataset dataset = FileLoader.loadFile(responsePath, goldPath, arffxPath);
			
			System.out.println(dataSetArddFix[index]);
			
			double F1_kfnn1 = 0.0;
			double F1_kfnn2 = 0.0;
			double F1_kfnn3 = 0.0;
			double F1_kfnn4 = 0.0;
					
			for (int counts = 0; counts < times; counts++) {
				// KFNN
				Dataset datasetKFNN = CekaUtils.datasetCopy(dataset);
				KFNN KFNN = new KFNN();
				KFNN.doInference(datasetKFNN);
				PerformanceStatistic reporter = new PerformanceStatistic();
				reporter.stat(datasetKFNN);
				F1_kfnn1 += CekaUtils.calF1(datasetKFNN);

				// KFNN2
				Dataset datasetKFNN2 = CekaUtils.datasetCopy(dataset);
				KFNN_noKF KFNN2 = new KFNN_noKF();
				KFNN2.doInference(datasetKFNN2);
				reporter = new PerformanceStatistic();
				reporter.stat(datasetKFNN2);
				F1_kfnn2 += CekaUtils.calF1(datasetKFNN2);
				
				// KFNN3
				Dataset datasetKFNN3 = CekaUtils.datasetCopy(dataset);
				KFNN_noLDE KFNN3 = new KFNN_noLDE();
				KFNN3.doInference(datasetKFNN3);
				reporter = new PerformanceStatistic();
				reporter.stat(datasetKFNN3);
				F1_kfnn3 += CekaUtils.calF1(datasetKFNN3);
				
				// KFNN3
				Dataset datasetKFNN4 = CekaUtils.datasetCopy(dataset);
				MajorityVote KFNN4 = new MajorityVote();
				KFNN4.doInference(datasetKFNN4);
				reporter = new PerformanceStatistic();
				reporter.stat(datasetKFNN4);
				F1_kfnn4 += CekaUtils.calF1(datasetKFNN4);
			}
			
			F1_kfnn1_all_sum += F1_kfnn1 / times;
			F1_kfnn2_all_sum += F1_kfnn2 / times;
			F1_kfnn3_all_sum += F1_kfnn3 / times;
			F1_kfnn4_all_sum += F1_kfnn4 / times;

			result_i.format("%-25s	%-10.2f	%-10.2f	%-10.2f	%-10.2f", dataSetArddFix[index],
					F1_kfnn1 / times, F1_kfnn2 / times, 
					F1_kfnn3 / times, F1_kfnn4 / times);
			result_i.println();

		}
		result_i.format("%-25s	%-10.2f	%-10.2f	%-10.2f	%-10.2f", "Average",
				F1_kfnn1_all_sum / dataSetArddFix.length,
				F1_kfnn2_all_sum / dataSetArddFix.length,
				F1_kfnn3_all_sum / dataSetArddFix.length,
				F1_kfnn4_all_sum / dataSetArddFix.length);
		result_i.close();
	}

}
