from generative_agents.persona.cognition import ReflectComponent
from generative_agents.persona.common import ChatObservation, PersonaIdentity
from generative_agents.utils import ModelWandbWrapper

from .reflect_prompts import (
    prompt_insight_and_evidence,
    prompt_memorize_from_conversation,
    prompt_planning_thought_on_conversation,
)


class PollutionReflectComponent(ReflectComponent):

    def __init__(self, model: ModelWandbWrapper):
        super().__init__(model)
        self.prompt_insight_and_evidence = prompt_insight_and_evidence
        self.prompt_planning_thought_on_conversation = (
            prompt_planning_thought_on_conversation
        )
        self.prompt_memorize_from_conversation = prompt_memorize_from_conversation
