import json
import time

from openai import OpenAI
import yaml

with open('../keys/openai_key', 'r') as f:
    api_key = f.readline().strip()

with open('../keys/openai_org_id', 'r') as f:
    organization = f.readline().strip()

client = OpenAI(api_key=api_key, organization=organization)

#sys_message = {
#    'evaluate': 'You are a helpful and precise assistant for checking the quality of the AI assistant\'s responses in conversations.',
#    'conversation': 'You are an AI assistant trying to choose correct answer to the given question. Please ask sub-questions if you do notunderstand the question or cannot directly answer the question. Otherwise, please only output your choice in the A, B, C, and D.'
#}

def call_chat(messages, model='gpt-3.5-turbo-1106', max_tokens=500):
    while True:
        try:
            response = client.chat.completions.create(
                            model=model,
                            messages=messages,
                            max_tokens=max_tokens,
                            temperature=0.2
                            )
            break
        except Exception as e:
            time.sleep(2)
            print('Errrrrrrrrrrrrrrrrrr', str(e))
            print(messages)

    prediction = response.choices[0].message.content

    return prediction

def call_completion(prompt, model='text-davinci-001', max_tokens=100):
    while True:
        try:
            response = client.completions.create(
                            model=model,
                            prompt=prompt,
                            max_tokens=max_tokens,
                            temperature=0.2
                            )
            break
        except Exception as e:
            time.sleep(2)
            print('Errrrrrrrrrrrrrrrrrr', str(e))
            print(prompt)

    prediction = response.choices[0].text

    return prediction

