import json
import pandas as pd
from tqdm import tqdm

import openai_api

data = pd.read_csv('../data/survey_responses.csv')

helpfulness = data['helpfulness_freetext'].values

# analyze persona
#ori_prompt = 'Plesae analyze, conclude, and list personas (e.g. starightforward, concise, knowledgeable, ignorant, etc.) from the following 10 reviews from 10 people:\n'
#prompt = ori_prompt
#results = ''
#for idx, text in enumerate(helpfulness):
#    text = str((idx+1)) + ': ' + text.strip() + '\n'
#    prompt += text
#
#    if 0 == (idx + 1) % 10:
#        print(prompt)
#        messages = [{'role': 'user', 'content': prompt}]
#        prediction = openai_api.call_chat(messages, model='gpt-3.5-turbo-1106')
#        print(prediction)
#        results += prediction.strip() + '\n'
#        prompt = ori_prompt
#
#print(prompt)
#messages = [{'role': 'user', 'content': prompt}]
#prediction = openai_api.call_chat(messages, model='gpt-3.5-turbo-1106')
#print(prediction)
#results += prediction.strip() + '\n'
#
#with open('persona_analyze_results.txt', 'w') as f:
#    f.write(results)

# conclude persona
#with open('persona_analyze_results.txt', 'r') as f:
#    text = f.read()
#print(text)
#
#prompt = 'Please conclude the top 10 personas from the following text:'
#messages = [{'role': 'user', 'content': '\n\n'.join([prompt, text])}]
#prediction = openai_api.call_chat(messages, model='gpt-3.5-turbo-1106')
#print(prediction)
#with open('persona_analyze_results_conclude.txt', 'w') as f:
#    f.write(prediction)

persona_list = ', '.join(['persistent', 'patient', 'critical', 'efficient', 'reliant', 'pratical', 'adaptable'])
persona_list = 'Persona: ' + persona_list + '.\n'
task_prompt = 'Please identify which one or two persona(s) best match the above comment. Please list them and explain the reason line-by-line:'

results = []
for idx, text in tqdm(enumerate(helpfulness)):
    text = 'Comment:\n' + text.strip() + '\n'
    prompt = '\n'.join([persona_list, text, task_prompt])
    print(prompt)
    messages = [{'role': 'user', 'content': prompt}]
    prediction = openai_api.call_chat(messages, model='gpt-3.5-turbo-1106', max_tokens=300)
    print(prediction)
    prediction = prediction.split('\n')
    prediction = '\n'.join([s.strip(' -.') for s in prediction if '' != s])
    print(prediction)
    results.append(prediction)

with open('persona_individual.txt', 'w') as f:
    f.write(json.dumps(results, indent=2))

