import pandas as pd

df = pd.read_csv('../data/event_blocks.csv')

df = df['attn' != df['question_type']]
df = df.groupby(['worker_id'])

def line_compare(line):
    return line['answer'] == line['user_answer']

def accuracy(group):
    compare = group.apply(line_compare, axis=1)
    acc = compare.sum() / len(compare)
    return acc

results = df.apply(accuracy)
print(results)
results.to_csv('../results/accuracy_by_id.csv')

