# Generalizing Consistency Policy to Visual RL with Prioritized Proximal Experience Regularization

## Overview
This repository contains the implementation of the methods described in our paper submitted to NIPS 2024. Our approach, CP3ER (Consistency Policy with Prioritized Proximal Experience Regularization), significantly enhances the stability and performance of visual reinforcement learning models.

## Installation

### Setup
To install the required packages, please run the following command:
```bash
conda env create -f conda_env.yml
```

## Reproducing Experimental Results
### Training for dmc tasks
```bash
python train.py task_name=acrobot_swingup
```
You can decide whether to use wandb to log your experiment process by specifying the 'use_wb' parameter, and determine whether to use a GPU for training by specifying the 'device' parameter. For more parameter options, please refer to the cfgs/config.yaml file.
```bash
python train.py task_name=cheetah_run device=cuda:1 use_wb=True seed=1
```

### Training for metaworld tasks
The code for training on metaworld tasks as described in our paper will be available at a later date. 

## Acknowledgement
CP3ER is licensed under the MIT license. MuJoCo and DeepMind Control Suite are licensed under the Apache 2.0 license. We would like to thank DrQ-v2 authors for open-sourcing the DrQv2 codebase. Our implementation builds on top of their repository.