#!/bin/bash

# Set the value of ITK_GLOBAL_DEFAULT_NUMBER_OF_THREADS to 8
export ITK_GLOBAL_DEFAULT_NUMBER_OF_THREADS=8

# Initialize a counter for parallel jobs
parallel_jobs=0
max_jobs=12

# Iterate over image pairs
for i in {1..40}; do
  fixed="../registered_label_pairs/l${i}_to_l${i}.hdr"   # fixed image is i-->i

  for j in {1..40}; do
    if [ $j != $i ]; then
      moving="../registered_label_pairs/l${j}_to_l${i}.hdr"  # move j-->i (jth image is warped to ith image)
      output_prefix="outputs/deformed_${i}_${j}_seg.img"

      echo antsApplyTransforms -d 3 -i $moving -r $fixed -t  \
	      outputs/output_${i}_${j}1Warp.nii.gz -t outputs/output_${i}_${j}0GenericAffine.mat -n GenericLabel -o $output_prefix;
      # Run the registration command in the background, redirecting output to a time file
      { time -p antsApplyTransforms -d 3 -i $moving -r $fixed -t  \
	      outputs/output_${i}_${j}1Warp.nii.gz -t outputs/output_${i}_${j}0GenericAffine.mat -n GenericLabel -o $output_prefix; } &

      # Increment the parallel jobs counter
      ((parallel_jobs++))

      # Check if the maximum parallel jobs limit is reached
      if [ $parallel_jobs -eq $max_jobs ]; then
        # Wait for all background jobs to complete
        wait
        # Reset the parallel jobs counter
        parallel_jobs=0
      fi
    fi
  done
done

# Wait for any remaining background jobs to complete
wait

