# -*- coding: utf-8 -*-
"""
Created on Wed Oct 30 11:56:44 2024

@author: shara
"""

import numpy as np
from scipy.optimize import minimize_scalar
from scipy.stats import zipf
import matplotlib.pyplot as plt
import pandas as pd
import pickle
import time

def get_polarsim_data():
    N = 2**12
    all_exec_times = []

    for p in [0.01, 0.25, 0.49]:
        exec_times_filename = 'Exec_Times_BSC_N=' + str(N) + '_p=' + str(round(p,4)) + '.pickle'
        with open(exec_times_filename, 'rb') as f:
            # Pickle the 'data' dictionary using the highest protocol available.
            exec_times_p = pickle.load(f)
        all_exec_times.append(np.array(exec_times_p))
    return all_exec_times

def get_gprs_data():
    all_exec_times = []
    for p in [0.01, 0.25, 0.49]:
        with open('GPRS_Calcs/Time_GPRS_BSC_' + str(p) + '.pickle', 'rb') as f:
            exec_times_p = pickle.load(f)
        all_exec_times.append(np.array(exec_times_p))
    return all_exec_times

polarsim_times = get_polarsim_data()
polarsim_median_times = np.array( [ round( np.median(exec_times), 4) for exec_times in polarsim_times ] )
polarsim_95_times = np.array( [ round( np.percentile(exec_times, 95), 4) for exec_times in polarsim_times ] )
polarsim_5_times = np.array( [ round( np.percentile(exec_times, 5), 4) for exec_times in polarsim_times ] )

scaling_factor = 2**12/8
gprs_times = get_gprs_data()
gprs_median_times = np.array( [ round( np.median(scaling_factor * exec_times), 4) for exec_times in gprs_times ] )
gprs_95_times = np.array( [ round( np.percentile(scaling_factor * exec_times, 95), 4) for exec_times in gprs_times ] )
gprs_5_times = np.array( [ round( np.percentile(scaling_factor * exec_times, 5), 4) for exec_times in gprs_times ] )

df = pd.DataFrame({'p': [0.01, 0.25, 0.49],
                   'PolarSim Median': polarsim_median_times,
                   'PolarSim 95 percentile': polarsim_95_times,
                   'PolarSim 5 percentile': polarsim_5_times,
                   'GPRS Median': gprs_median_times,
                   'GPRS 95 percentile': gprs_95_times,
                   'GPRS 5 percentile': gprs_5_times})

df.to_csv('Exec_Time_CameraReady.csv')