import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib
matplotlib.use('TkAgg')  # Adjust based on your OS and environment


#results_df = pd.read_csv(f'res/cost_acc/servercost_cost_vs_alpha_results.csv')
results_df = pd.read_csv(f'res/cost_acc/cost_vs_alpha_results.csv')

# Create a pivot table with Cheap Alpha as rows, Expensive Alpha as columns, and Average Mean Response Time as values
pivot_table = results_df.pivot(index='Cheap Alpha', columns='Expensive Alpha', values='Average Mean Response Time')

# Create the row labels with Cheap Alpha and its cost
row_labels = [f"{row} ({results_df[results_df['Cheap Alpha'] == row]['Cheap Alpha Cost'].values[0]})" for row in
              pivot_table.index]

col_labels = [
    f"{1 - col:.1f} ({results_df[results_df['Expensive Alpha'] == col]['Expensive Alpha Cost'].values[0]})"
    for col in pivot_table.columns]

# Create the heat matrix plot
plt.figure(figsize=(12, 10))
ax = sns.heatmap(pivot_table, annot=True, cmap='YlGnBu', xticklabels=col_labels, yticklabels=row_labels, annot_kws={"size": 25})
ax.set_xticklabels(ax.get_xticklabels(), fontsize=22)
ax.set_yticklabels(ax.get_yticklabels(), fontsize=22)

# Modifying the color bar
cbar = ax.collections[0].colorbar
cbar.ax.tick_params(labelsize=25)  # Increase font size of the color bar ticks

plt.xlabel(r'Expensive: $1-\alpha$ ($c_2$)', fontsize=35)
plt.ylabel(r'Cheap: probability ($c_1$)', fontsize=35)
#plt.savefig(f'graphs/servercost_cost_vs_acc_ext_arrival_{0.9}.png')
plt.savefig(f'graphs/cost_vs_acc_ext_arrival_{0.9}.png')

plt.clf()
