import numpy as np
from scipy.integrate import quad, dblquad


#x_upper_limit = np.inf
#y_upper_limit = np.inf


y_upper_limit = 1000
x_upper_limit = 50
#alpha = 2
alpha = 0.1

Lambda = 0.5
T = 1



def calculate_ET_ext(Lambda):
    def f(x):
        return np.exp(-x)


    def pT(x):
        if x <= 0:
            return 0

        lower_bound = (1 - alpha) * x
        upper_bound = (1 + alpha) * x

        if T <= lower_bound:
            return 0
        elif T >= upper_bound:
            #print(f'pT(x): {1}')

            return 1
        else:
            if alpha == 0:
                if (x < T):
                    return 1
                else:
                    return 0
            else:
                #print(f'pT(x): {(T - lower_bound) / (2 * alpha * x)}')
                return (T - lower_bound) / (2 * alpha * x)



    def g(x, y):
        if x <= 0:
            return 0

        if (1 - alpha) * x <= y <= (1 + alpha) * x:
            if alpha == 0:
                return np.exp(-x)
            else:
                return (1 / (2 * alpha * x)) * np.exp(-x)
        else:
            return 0

    # function for rho''_q
    def rho_prime_prime(q_value):
        def integrand_rho_q_1_adjusted(x):
            return pT(x) * x * f(x)

        def integrand_rho_q_2_adjusted(x):
            return (1 - pT(x)) * x * f(x)*((q_value-((1-alpha)*x))/(2*alpha*x))

        rho_q_1_adjusted, _ = quad(integrand_rho_q_1_adjusted, 0.001, x_upper_limit, limit=1000)
        rho_q_2_adjusted, _ = quad(integrand_rho_q_2_adjusted, 0.001, x_upper_limit, limit=1000)
        return Lambda * (rho_q_1_adjusted + rho_q_2_adjusted)

    # function for E[T(x, y)]_ext^PL
    def ET_ext_PL(x, y):
        rho_q = rho_prime_prime(y)
        integral_1, _ = quad(lambda x: pT(x) * x**2 * f(x), 0.001, x_upper_limit, limit=100)
        integral_2, _ = quad(lambda x: (1 - pT(x)) * x**2 * f(x)*((y-((1-alpha)*x))/(2*alpha*x)), 0.001, x)
        integral_3, _ = dblquad(lambda x, t: (1 - pT(x)) * g(x, t) * (x - (t - y)) ** 2,
                                y,
                                y_upper_limit,
                                lambda t: t - y,
                                lambda t: x_upper_limit)

        integral_last_part, _ = quad(lambda a: 1 / (1 - rho_prime_prime(max(0, y - a))), 0.001, x, limit=100)
        #print(f'UNIP rho_q:{rho_q}, integral_1:{integral_1}, integral_2:{integral_2}, integral_3:{integral_3}, integral_last_part:{integral_last_part}')
        return (Lambda / (2 * (1 - rho_q)**2)) * (integral_1 + integral_2 + integral_3) + integral_last_part

    #E_T_ext = ET_ext_PL(1.2, 1.8)

    # Calculating E[T_ext]
    def I(x):
        if x <= 0:
            return 0
        else:
            # Calculate the integral over y
            integral, _ = quad(lambda y: ET_ext_PL(x, y), (1 - alpha) * x, (1 + alpha) * x, limit=1000)
            return (1 / (2 * alpha * x)) * np.exp(-x) * integral

    # Define the overall E[T_ext]
    def E_T_ext():
        # Calculate the integral over x
        #result1, _ = quad(lambda x: I(x), 0.001, x_upper_limit, limit=1000)
        E_T_ext_without_normal, _ = quad(lambda x: (1 - pT(x)) * f(x) * I(x), 0.001, 3, limit=1000)

        #print(f'result1: {result1}, result2:{result2}')
        normalization_factor, _ = quad(lambda x:(1 - pT(x)) * f(x), 0.001, 3)

        print(f'rnormalization_factor: {normalization_factor}')

        E_T_ext_with_normal = E_T_ext_without_normal / normalization_factor if normalization_factor != 0 else 0

        print(f'result without normalization:{E_T_ext_without_normal}, with: {E_T_ext_with_normal}')
        return E_T_ext_without_normal, E_T_ext_with_normal

    #one_point_test = ET_ext_PL(1, 1)
    #print(f'UNIP one_point_test(1,1): {one_point_test}')

    E_T_ext_without_nomal, E_T_ext_with_normal = E_T_ext()

    print(f'E_T_ext_without_nomal: {E_T_ext_without_nomal}, E_T_ext_with_normal:{E_T_ext_with_normal}')
    return E_T_ext_without_nomal, E_T_ext_with_normal


def save_results_to_file(Lambda, T, E_T_ext, filename=f'ET_{T}_{Lambda}_alpha{alpha}_ext_PL_results_uniP.txt'):
    with open(filename, "w") as file:
        file.write(f"Lambda: {Lambda}\n")
        file.write(f"T: {T}\n")
        file.write(f"E[T_ext]: {E_T_ext}\n")


E_T_ext_without, E_T_ext_with = calculate_ET_ext(Lambda)

filename=f'ET_{T}_{Lambda}_alpha{alpha}_ext_PL_results_uniP.txt'
with open(filename, "w") as file:
    file.write(f"Lambda: {Lambda}\n")
    file.write(f"T: {T}\n")
    file.write(f"E_T_ext_without: {E_T_ext_without}, E_T_ext_with:{E_T_ext_with}\n")

