# -*- coding: utf-8 -*-

# Max-Planck-Gesellschaft zur Förderung der Wissenschaften e.V. (MPG) is
# holder of all proprietary rights on this computer program.
# You can only use this computer program if you have closed
# a license agreement with MPG or you get the right to use the computer
# program from someone who is authorized to grant you that right.
# Any use of the computer program without a valid license is prohibited and
# liable to prosecution.
#
# Copyright©2020 Max-Planck-Gesellschaft zur Förderung
# der Wissenschaften e.V. (MPG). acting on behalf of its Max Planck Institute
# for Intelligent Systems. All rights reserved.
#
# Contact: ps-license@tuebingen.mpg.de

from typing import Optional
from torch import Tensor

from .base import Datastruct, dataclass, Transform


class IdentityTransform(Transform):
    def __init__(self, **kwargs):
        return

    def Datastruct(self, **kwargs):
        return IdentityDatastruct(**kwargs)

    def __repr__(self):
        return "IdentityTransform()"


@dataclass
class IdentityDatastruct(Datastruct):
    transforms: IdentityTransform

    features: Optional[Tensor] = None

    def __post_init__(self):
        self.datakeys = ["features"]

    def __len__(self):
        return len(self.rfeats)
