# -*- coding: utf-8 -*-

# Max-Planck-Gesellschaft zur Förderung der Wissenschaften e.V. (MPG) is
# holder of all proprietary rights on this computer program.
# You can only use this computer program if you have closed
# a license agreement with MPG or you get the right to use the computer
# program from someone who is authorized to grant you that right.
# Any use of the computer program without a valid license is prohibited and
# liable to prosecution.
#
# Copyright©2020 Max-Planck-Gesellschaft zur Förderung
# der Wissenschaften e.V. (MPG). acting on behalf of its Max Planck Institute
# for Intelligent Systems. All rights reserved.
#
# Contact: ps-license@tuebingen.mpg.de

# aspell list < your_file.txt > mispell2
from re import L


SPELL_CORRECTOR = {
                    "bodyshake": "body shake",
                    "plie": "slightly bend upper body",
                    "strectch": "stretch",
                    "liftin": "lift",
                    "neel": "kneel",
                    "upperbody": "upper body",
                    "intewine": "intertwine",
                    "swiming": "swim",
                    "arrn": "arm",
                    "handcircleaction": "hand circle action",
                    "limbe": "limp",
                    "carthwheel": "cartwheel",
                    "scretche": "stretch",
                    "polishbottom": "polish bottom",
                    "tposes": "t-pose",
                    "mondey": "monkey",
                    "lightbulb": "light bulb",
                    "oject": "object",
                    "aggresive": "aggressive",
                    "standup": "stand up",
                    "throwne": "throw",
                    "dane": "dance",
                    "kungfu": "kung fu",
                    "clockwaise": "clockwise",
                    "stepppe": "step",
                    "forwrd": "forward",
                    "dow": "down",
                    "bodyactions": "body actions",
                    "crossbody": "cross body",
                    "sqarts": "squat",
                    "thurn": "turn",
                    "backflip": "back flip",
                    "rotationg": "rotate",
                    "jumpstumble": "jump stumble",
                    "kneee": "kneel",
                    "polishtop": "polish top",
                    "strairs": "stairs",
                    "pushup": "push-up",
                    "hallf": "half",
                    "walklean": "walk lean",
                    "ginga": "ginga",
                    "jax": "jack",
                    "hidde": "hide",
                    "leftt": "left",
                    "righ": "right",
                    "outstretche": "out stretched",
                    "rightside": "right side",
                    "excersice": "exercise",
                    "sneek": "sneak",
                    "sittte": "sit",
                    "zag": "zag",
                    "frontpickwalk": "front pick walk",
                    "sitdown": "sit down",
                    "axe": "axe",
                    "llook": "look",
                    "rightsidebend": "right side bend",
                    "apost": "a-pose",
                    "stepjump": "step jump",
                    "upsidedown": "up and down",
                    "qaround": "around",
                    "lookin": "look",
                    "forwardss": "forward",
                    "righthand": "right hand",
                    "legge": "legs",
                    "togather": "together",
                    "wih": "with",
                    "swarve": "swing hands",
                    "indian": "indian",
                    "situps": "squat",
                    "pelvi": "pelvis",
                    "breakdance": "breakdance",
                    "turnback": "turn back",
                    "fron": "front",
                    "guiderails": "guide rails",
                    "blackflipping": "back flip",
                    "jumpke": "jump",
                    "strumble": "stumble",
                    "spinkicke": "spin kick",
                    "rotatehip": "rotate hip",
                    "placedown": "place down",
                    "foward": "forward",
                    "midlevel": "waist level",
                    "backscratche": "scratch back",
                    "ushape": "u-shape",
                    "robotically": "robotically",
                    "cirlce": "circle",
                    "crosslegge": "cross legs",
                    "ratate": "rotate",
                    "tpose": "t-pose",
                    "climbdown": "climb down",
                    "frontscratche": "scratch front",
                    "walkapose": "walk",
                    "kickboxe": "kickboxing",
                    "lowrs": "lower",
                    "stepstool": "step stool",
                    "sideway": "sideways",
                    "dumbells": "dumbbells",
                    "baseketball": "basketball",
                    "legrotate": "leg rotate",
                    "exercisingsquat": "squat",
                    "steppingupbackward": "step up backwards",
                    "outreache": "outstretched",
                    "frontmove": "front move",
                    "jumb": "jump",
                    "serie": "series",
                    "handaction": "hand action",
                    "updown": "up down",
                    "sligthly": "slightly",
                    "wlak": "walk",
                    "kung": "kung",
                    "motio": "motion",
                    "streche": "stretch",
                    "handactions": "hand actions",
                    "lookng": "look",
                    "fu": "fu",
                    "kickbox": "kickbox",
                    "blub": "bulb",
                    "lefthandsup": "left hand up",
                    "holdng": "hold",
                    "neal": "kneel",
                    "wpose": "w-pose",
                    "standingtransition": "stand transition",
                    "vpose": "v-pose",
                    "leftsideleglunges": "left side leg lunges",
                    "wark": "walk",
                    "cicular": "circular",
                    "leftleg": "left leg",
                    "bente": "bend",
                    "bodybuilde": "bodybuilding",
                    "backmove": "move backwards",
                    "entende": "extended",
                    "righttransition": "right transition",
                    "turnne": "turn",
                    "nunchaku": "karate sticks",
                    "headup": "head up",
                    "handphone": "headphones",
                    "tpost": "t-pose",
                    "benddown": "bend down",
                    "polishleft": "polish left",
                    "writingsketche": "write, sketch",
                    "climp": "climb",
                    "jumbe": "jump",
                    "lef": "leg",
                    "rotatebody": "rotate body",
                    "leftside": "left side",
                    "backstep": "step back",
                    "neckshake": "shake neck",
                    "climbup": "climb up",
                    "puch": "punch",
                    "cricle": "circle",
                    "wa": "walk",
                    "walkback": "walk back",
                    "swimimng": "swim",
                    "hnd": "hand",
                    "palce": "place",
                    "biano": "piano",
                    "backflippe": "back flip",
                    "cwarle": "crawl",
                    "tippy": "",
                    "sognal": "signal",
                    "steppin": "step",
                    "tshirt": "t-shirt",
                    "rright": "right",
                    "darg": "drag",
                    "obect": "object",
                    "excerise": "exercise",
                    "saunt": "saunter",
                    "bodyaction": "body action",
                    "walkingon": "walk on",
                    "sidetoside": "side to side",
                    "waiste": "waist",
                    "jakcs": "jacks",
                    "tposition": "t-pose",
                    "blackflip": "back flip",
                    "kneelevel": "knee level",
                    "rightsidelunges": "right side lunges",
                    "lke": "",
                    "wond": "down",
                    "pivotsturns": "pivot turn",
                    "movemnt": "movement",
                    "jumpturn": "jump turn",
                    "walkikng": "walk",
                    "rearright": "back right",
                    "cratching": "scratch",
                    "sshape": "shape",
                    "mvement": "movement",
                    "movent": "movement",
                    "fghgfhgfh": "",
                    "swinge": "swing",
                    "recentere": "recenter",
                    "aems": "arms",
                    "handsup": "hands up",
                    "stubbles": "stumble",
                    "forwad": "forward",
                    "slighlty": "slightly",
                    "shoulderwidth": "shoulder width",
                    "spose": "s-pose",
                    "backbend": "bend back",
                    "scretch": "scratch",
                    "jumpingjack": "jumping jack",
                    "handbinocular": "hand binocular",
                    "baseket": "basket",
                    "sidemove": "side move",
                    "grap": "grasp",
                    "excercises": "exercise",
                    "ith": "with",
                    "rightshoulder": "right shoulder",
                    "excercise": "exercise",
                    "wtep": "step",
                    "plae": "place",
                    "frontback": "front back",
                    "upose": "u-pose",
                    "sitlean": "sit lean",
                    "headright": "head right",
                    "hopak": "hopak",
                    "floorss": "floor",
                    "apose": "a-pose",
                    "righthandsup": "right hand up",
                    "jumprope": "jump rope",
                    "loooke": "look",
                    "crwale": "crawl",
                    "stanidng": "stand",
                    "criss": "criss",
                    "meand": "walk",
                    "zig": "zig",
                    "sidewats": "sideways",
                    "shotput": "shot put",
                    "upstair": "upstairs",
                    "joggin": "jog",
                    "leftright": "left right",
                    "headactions": "head actions",
                    "streache": "stretch"
}

def fix_spell(words):
    l_words = words.strip().split()
    for i, x in enumerate(l_words):
        if x in SPELL_CORRECTOR:
            l_words[i] = SPELL_CORRECTOR[x]
    return ' '.join(l_words)
