```uclid
module mutual_exclusion_protocol
{
  type pid_t = boolean;
  const p0 : pid_t = false;
  const p1 : pid_t = true;

  var s : pid_t;
  var y0 : boolean;
  var y1 : boolean;

  init {
    s = p0;
    y0 = false;
    y1 = false;
  }

  next {
    case
      // Process P0 action
      :: true ->
        case
          // Noncritical section
          :: true ->
            y0' = true;
            s'  = p0;

          // Enter critical section
          :: (y1 == false || s != p0) ->
            y0' = false;
            s' = s;
        esac;

      // Process P1 action
      :: true ->
        case
          // Noncritical section
          :: true ->
            y1' = true;
            s'  = p1;

          // Enter critical section
          :: (y0 == false || s != p1) ->
            y1' = false;
            s' = s;
        esac;
    esac
  }

  property mutual_exclusion {
    !((y0 == true && y1 == true) && (s == p0 && s == p1))
  }

  property starvation_freedom_P0 {
    always (eventually (y0 == true) -> eventually (s == p0 && y0 == false));
  }

  property starvation_freedom_P1 {
    always (eventually (y1 == true) -> eventually (s == p1 && y1 == false));
  }

  control {
    check;
    print_results;
  }
}
```