base_dir='output/eval'
working_dir="$base_dir"
plot_config="config/plot/30K_all.yaml"

python -m src.evaluate.compute_scores --base_model alpaca-7b-reproduced --criteria helpfulness --eval_result_path "$working_dir/gpt4_helpful_evaluation.json" --output_path "$working_dir/helpful_summary.json" --plot_config "$plot_config"

python -m src.evaluate.compute_scores --base_model alpaca-7b-reproduced --criteria harmlessness --eval_result_path "$working_dir/gpt4_safety_evaluation.json" --output_path "$working_dir/safety_summary.json" --plot_config "$plot_config"

python -m src.evaluate.plot_scores --score_type win_rate --plot_config "$plot_config" --x_summary_path "$working_dir/helpful_summary.json" --y_summary_path "$working_dir/safety_summary.json" --output_dir "$working_dir" --name_prefix "combined"
