import torch
from torch import nn
import torch.nn.functional as F
from base_classes import BaseGNN
from model_configurations import set_block, set_function

from torch_geometric.nn import MLP, GINConv, global_add_pool,global_mean_pool,global_max_pool
# Define the GNN model.
class GNN_GRAPH(BaseGNN):
  def __init__(self, opt, dataset, device=torch.device('cpu')):
    super(GNN_GRAPH, self).__init__(opt, dataset, device)
    self.f = set_function(opt)
    block = set_block(opt)
    time_tensor = torch.tensor([0, self.T]).to(device)
    self.odeblock = block(self.f, self.regularization_fns, opt, dataset.data, device, t=time_tensor).to(device)
    # self.alpha_ode = nn.Parameter(torch.tensor(torch.tensor(0.1), requires_grad=True))
    # print("self.alpha_ode: ",self.alpha_ode )
    # self.decoder = nn.Linear(opt['hidden_dim'], 1)

    self.encoder = nn.Linear(opt['num_features'], opt['hidden_dim'])
    self.decoder = nn.Linear(opt['hidden_dim'], opt['num_classes'])

  def forward(self, x_in, edge_index, batch):
    # Encode each node based on its feature.
    x = x_in.float()


    x = F.dropout(x, self.opt['input_dropout'], training=self.training)
    x = self.encoder(x)

    if self.opt['use_mlp']:
      x = F.dropout(x, self.opt['dropout'], training=self.training)
      x = F.dropout(x + self.m11(F.relu(x)), self.opt['dropout'], training=self.training)
      x = F.dropout(x + self.m12(F.relu(x)), self.opt['dropout'], training=self.training)
    # todo investigate if some input non-linearity solves the problem with smooth deformations identified in the ANODE paper


    if self.opt['batch_norm']:
      x = self.bn_in(x)



    if 'graphcon' in self.opt['function']:
      x = torch.cat([x, x], dim=-1)
      self.odeblock.set_x0(x)

      if self.training and self.odeblock.nreg > 0:
        z, self.reg_states = self.odeblock(x)
      else:
          # alpha_ode = torch.sigmoid(self.alpha_ode)
          # alpha_ode = self.alpha_ode
        z = self.odeblock(x,edge_index,edge_weight=None)
      z = z[:,self.opt['hidden_dim']:]
    elif 'term' in self.opt['function']:
      #x2 = torch.zeros_like(x, device=self.device)
      x2 = x.clone()
      # x2 = torch.ones_like(x, device=self.device)
      # x2 = torch.ones_like(x,device=self.device)
      for _ in range(self.opt['num_terms'] - 1):
        x = torch.cat((x, x2), dim=1)
      self.odeblock.set_x0(x)

      if self.training and self.odeblock.nreg > 0:
        z, self.reg_states = self.odeblock(x)
      else:
        # alpha_ode = torch.sigmoid(self.alpha_ode)
        # alpha_ode = self.alpha_ode
        z = self.odeblock(x,edge_index,edge_weight=None)
      z = z[:,0:self.opt['hidden_dim']]

    else:

      self.odeblock.set_x0(x)

      if self.training and self.odeblock.nreg > 0:
        z, self.reg_states = self.odeblock(x)
      else:
        # alpha_ode = torch.sigmoid(self.alpha_ode)
        # alpha_ode = self.alpha_ode
        z = self.odeblock(x,edge_index,edge_weight=None)




    if self.opt['augment']:
      z = torch.split(z, x.shape[1] // 2, dim=1)[0]

    # print("batch.shape: ",batch.shape)
    # print("z.shape before pooling: ",z.shape)
    z = global_add_pool(z, batch)
    # print("z.shape after pooling: ",z.shape)
    # Activation.
    z = F.relu(z)

    if self.opt['fc_out']:
      z = self.fc(z)
      z = F.relu(z)

    # Dropout.
    z = F.dropout(z, self.opt['dropout'], training=self.training)

    # Decode each node embedding to get node label.

    # z = self.m2(z)
    # z = global_add_pool(z, batch)
    z = self.decoder(z)
    # print("z.shape after decoder: ",z.shape)
    # z = global_add_pool(z, batch).squeeze(-1)
    return z
