import argparse
import os

import pandas as pd


def main():
    parser = argparse.ArgumentParser(description='Summarize results to dataframe')
    parser.add_argument('--data', '-d', type=str, required=True,
            help='Path to results data containing LipConvnet* folders')
    args = parser.parse_args()
    # Create dataframe with results
    records = []
    for aux in ['None', '50k', '100k', '200k', '500k', '1m', '5m', '10m']:
        for epochs in [800, 1600, 2400]:
            for depth, width in [(6, 128), (12, 128), (18, 128), (18, 256)]:
                config = (aux, epochs, depth, width)
                results_log = os.path.join(args.data, 'linear_res-{2}x{3}_cifar10-{0}-70-e{1}.log'.format(*config))
                if not os.path.exists(results_log):
                    print('Missing aux={} epochs={} depth={} width={}'.format(*config))
                    continue
                results = pd.read_csv(results_log, sep='\t')
                best_row = results.loc[results[' Test Robust '].idxmax()]
                best_epoch, best_train_acc, best_std_acc, best_cert_acc = int(best_row['Epoch ']), best_row[' Train Acc '], best_row[' Test Acc '], best_row[' Test Robust ']
                last_row = results.iloc[-1]
                last_train_acc, last_std_acc, last_cert_acc = last_row[' Train Acc '], last_row[' Test Acc '], last_row[' Test Robust ']
                records.append((*config, best_epoch, best_train_acc, best_std_acc, best_cert_acc, last_train_acc, last_std_acc, last_cert_acc))
    columns = ['aux', 'epochs', 'depth', 'width', 'best_epoch', 'best_train_acc', 'best_std_acc', 'best_cert_acc', 'last_train_acc', 'last_std_acc', 'last_cert_acc']
    df = pd.DataFrame.from_records(records, columns=columns)
    df.to_csv('gloro-results.csv', index=False, float_format='%.02f')


if __name__ == '__main__':
    main()
