import os
import json

def get_datasets(config):
    dataset_name = config['task']
    train_dir = 'data/LaMP/{}/train/train_questions.json'.format(dataset_name)
    train_questions = []
    with open(train_dir, 'r') as f:
        for line in f:
            data = json.loads(line)
            train_questions.append(data)
    train_ans_dir = 'data/LaMP/{}/train/train_outputs.json'.format(dataset_name)
    with open(train_ans_dir, 'r') as f:
        train_answers = json.loads(f)['golds']
    
    dev_questions = []
    dev_dir = 'data/LaMP/{}/dev/dev_questions.json'.format(dataset_name)
    with open(dev_dir, 'r') as f:
        for line in f:
            data = json.loads(line)
            dev_questions.append(data)
    dev_ans_dir = 'data/LaMP/{}/dev/dev_outputs.json'.format(dataset_name)
    with open(dev_ans_dir, 'r') as f:
        dev_answers = json.loads(f)['golds']
    
    return train_questions, train_answers, dev_questions, dev_answers
