using Lasso, Distributions, LinearAlgebra, Random
using DataFrames, CSV, Statistics

BLAS.set_num_threads(1)


font = CSV.read("font.csv", DataFrame)

X = Matrix(font[:, setdiff(1:410,[4,9,10])])
X .= log.(X .+ 1)
y = font[:, 411]
y1 = Vector{Bool}(undef, length(y))
y1 .= y

font = nothing

include("../main/functions.jl")


case = haskey(ENV, "case") ? parse(Int, ENV["case"]) : 1

ver = "1"

if case == 1
    crtn = "P"
elseif case == 2
    crtn = "A"
elseif case == 3
    crtn = "L"
end



Np = 1500
S = 500

rhos = [0.003, 0.005, 0.007, 0.01, 0.015]
lthr = 1e-3
gammas = [1]
k = size(X, 2)

Random.seed!(2)
name = string("font-", ver, "-", crtn)
for gamma in gammas, rho in rhos
    aucs = zeros(S)
    @time for i in 1:S
        try
            plt = PilotEst2(X, y1, Np, criterion = string(crtn, "-opt"),
                            standardize=true, alpha=0.95, eps=3*1e-2)
            est = SubsampleEst2(X, y1, plt, gamma, rho, lthr,
                                nlambda = 100, eps = 0.0001,
                                lambda_max = 100,
                                method = "bic", criterion = string(crtn, "-opt"),
                                standardize=false)
            aucs[i] = est.auc
        catch e
            println(i)
            aucs[i] = NaN
        end
    end
    mkpath("results/font")
    aucdf = DataFrame(aucdf = aucs)
    CSV.write(string("results/font/Subsampling-auc-", name, "-", rho, ".csv"), aucdf)
end
