_base_ = [
    './mscan_large.py',
    './schedule_160k_adamw.py',
    '../_base_/datasets/ade20k_repeat.py',
    '../_base_/default_runtime.py', 
]

model = dict(
    decode_head=dict(type='LightHamHead', num_classes=150)
)

data = dict(samples_per_gpu=4)
evaluation = dict(interval=8000, metric='mIoU')
checkpoint_config = dict(by_epoch=False, interval=8000)

# optimizer
optimizer = dict(_delete_=True, type='AdamW', lr=0.00006, betas=(0.9, 0.999), weight_decay=0.01,
                 paramwise_cfg=dict(custom_keys={'pos_block': dict(decay_mult=0.),
                                                 'norm': dict(decay_mult=0.),
                                                 'head': dict(lr_mult=10.)
                                                 }))

lr_config = dict(_delete_=True, policy='poly',
                 warmup='linear',
                 warmup_iters=1500,
                 warmup_ratio=1e-6,
                 power=1.0, min_lr=0.0, by_epoch=False)


