import logging
import os
import random
import time

import numpy as np

def get_abs_path(path):
    return os.path.realpath(os.path.expanduser(path))

def generate_dir(path):
    if not os.path.exists(path):
        os.makedirs(path, exist_ok=True)
    return

def init_logger(log_file=None, log_file_level=logging.NOTSET, rotate=False):
    log_format = logging.Formatter("%(message)s")
    logger = logging.getLogger()
    logger.setLevel(logging.INFO)

    console_handler = logging.StreamHandler()
    console_handler.setFormatter(log_format)
    logger.handlers = [console_handler]

    if log_file and log_file != "":
        if rotate:
            file_handler = RotatingFileHandler(
                log_file, maxBytes=1000000, backupCount=10
            )
        else:
            file_handler = logging.FileHandler(log_file, mode="w")
        file_handler.setLevel(log_file_level)
        file_handler.setFormatter(log_format)
        logger.addHandler(file_handler)

    return logger

def log_arguments(logger, args):
    if logger is None:
        return
    logger.info(f"Current Working Directory: {os.getcwd()}")
    for arg, value in sorted(vars(args).items()):
        logger.info(f"{arg}: {value}")
        
def log_msg(logger, msg):
    if logger is None:
        return
    logger.info(msg)
