# A Kernel Perspective on Distillation-based Collaborative Learning
This is a description of the supplementary material of "A Kernel Perspective on Distillation-based Collaborative Learning".

### Requirements
numpy==1.26.3

torch==2.1.2

torchvision==0.16.2

### Kernel Machine-based Algorithms
run DCL-KR.py with options

* cuda: gpu number to use
* data: toy1 | toy3
* algorithm: centralKRR, centralKRGD, IED, DCL-KR (ours)
* num_clients: the number of parties

hyperparameters
* centralKRR: lamda == regularization coefficient
* centralKRGD: eta == learning rate, T == number of iterations
* IED: lamda == regularization coefficient, alpha == distillation coefficient
* DCL-KR: eta == learning rate, T == number of communication rounds, local_iters == the number of local iterations

For example, we can run the code as follows:

    python3 DCL-KR.py --cuda 0 --data toy3 --algorithm DCL-KR --eta 0.1 --num_clients 40 --T 20

### Neural Network-based Algorithms
In our work, we conduct FedMD for pretraining. 

Before run DCL-NN.py to conduct DCL-NN, we should train local AI models using FedMD

We may run FedMD.py as follows:

    python3 FedMD.py --cuda 0 --ver 1 --epochs 100 --data datasets/toy3_50_hetero --save

Please read FedMD.py for several options.

To save the pretrained model using FedMD, you should use the option --save.

After running FedMD.py, we have the saved models, e.g., model_save/toy3_50_hetero/FedMD_toy3_50_1_100.pt.

Then we can run DCL-NN.py using this pretrained model as follows:

    python3 DCL-NN.py --cuda 0 --ver 1 --load model_save/toy3_50_hetero/FedMD_toy3_50_1_100.pt
