#!/bin/bash

# SBATCH --job-name=i_cllama_full
# SBATCH --output=i_cllama_full.out
# SBATCH --error=i_cllama_full.err
# SBATCH --job-name=i_cllama_full_scrp
# SBATCH --output=i_cllama_full_scrp.out
# SBATCH --error=i_cllama_full_scrp.err
#SBATCH --job-name=i_cllamaINST_full
#SBATCH --output=i_cllamaINST_full.out
#SBATCH --error=i_cllamaINST_full.err

#SBATCH --partition=compute
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=1
#SBATCH --gres=gpu:A100:4
#SBATCH --time=23:00:00
#SBATCH --mail-type=ALL
#SBATCH --mail-user=bo@andrew.cmu.edu


source ~/.bashrc
conda activate agent


# accelerate launch  --main_process_port 29513 --num_processes 2 --num_machines 1 --mixed_precision "no" /data/b_ou/agent-model/LLaMA-Factory/src/train_bash.py \
#     --stage sft \
#     --model_name_or_path /data/b_ou/ckpts/cllama/models--codellama--CodeLlama-7b-hf/snapshots/bc5283229e2fe411552f55c71657e97edf79066c/ \
#     --do_predict \
#     --dataset m2w_code_test \
#     --dataset_dir /data/b_ou/agent/data/code/ \
#     --template llama2 \
#     --finetuning_type full \
#     --checkpoint_dir /data/b_ou/ckpts/output_16k_cllama_full/checkpoint-1715/ \
#     --output_dir /data/b_ou/ckpts/output_16k_cllama_full/pred \
#     --per_device_eval_batch_size 4 \
#     --predict_with_generate True\
#     --use_safetensors True \
#     --cutoff_len 4096 \
#     --bf16 True



accelerate launch  --main_process_port 29513 --num_processes 2 --num_machines 1 --mixed_precision "no" /data/b_ou/agent-model/LLaMA-Factory/src/train_bash.py \
    --stage sft \
    --model_name_or_path /data/b_ou/ckpts/cllama_inst/models--codellama--CodeLlama-7b-Instruct-hf/snapshots/65515fcea0bf53f04b79ac582d93da752cf1e655/ \
    --do_predict \
    --dataset m2w_code_test \
    --dataset_dir /data/b_ou/agent/data/code/ \
    --template llama2 \
    --finetuning_type full \
    --checkpoint_dir /data/b_ou/ckpts/output_16k_cllamaINST_full/checkpoint-1715/ \
    --output_dir /data/b_ou/ckpts/output_16k_cllamaINST_full/pred \
    --per_device_eval_batch_size 4 \
    --predict_with_generate True\
    --use_safetensors True \
    --cutoff_len 4096 \
    --bf16 True




# accelerate launch  --main_process_port 29514 --num_processes 2 --num_machines 1 --mixed_precision "no" /data/b_ou/LLaMA-Factory/src/train_bash.py \
#     --stage sft \
#     --model_name_or_path /data/b_ou/ckpts/cllama/models--codellama--CodeLlama-7b-hf/snapshots/bc5283229e2fe411552f55c71657e97edf79066c/ \
#     --do_predict \
#     --dataset m2w_code_scrape \
#     --dataset_dir /data/b_ou/agent/data/code_scrp/ \
#     --template llama2 \
#     --finetuning_type full \
#     --checkpoint_dir /data/b_ou/ckpts/output_8k_cllama_full_scrp/checkpoint-780/ \
#     --output_dir /data/b_ou/ckpts/output_8k_cllama_full_scrp/pred \
#     --per_device_eval_batch_size 16 \
#     --predict_with_generate \
#     --use_safetensors True \
#     --bf16 True
