#!/bin/bash
#SBATCH --job-name=validation
#SBATCH --output=validation.out
#SBATCH --error=validation.err
#SBATCH --partition=babel-shared
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=1
#SBATCH --gres=gpu:A6000:2
#SBATCH --time=10:00:00
#SBATCH --mail-type=ALL
#SBATCH --mail-user=bo@andrew.cmu.edu


source ~/.bashrc
conda activate agent_eval

REC_FILE="/home/bo/agent/fine_tune/"

python validation.py \
--checkpoints-folder /data/tir/projects/tir2/users/bo/ \
--record-file-path "$REC_FILE" \
--eval-file /home/bo/agent/data/final_output_full_injected_llama2_val.json \

sort -t '-' -k2,2n "$REC_FILE" -o "$REC_FILE"
