BEGIN TRANSACTION;
CREATE TABLE AgeDemographics (CityId INTEGER REFERENCES Cities(id), Year INT PRIMARY KEY, MedianAge INT, AgeRange TEXT, PopulationGroup TEXT);
INSERT INTO "AgeDemographics" VALUES(1,2000,35,'18-34','Young Adults');
INSERT INTO "AgeDemographics" VALUES(1,2010,37,'35-44','Adults');
INSERT INTO "AgeDemographics" VALUES(1,2020,39,'45-54','Older Adults');
CREATE TABLE "Cities" (`id` INTEGER PRIMARY KEY AUTOINCREMENT, CityName TEXT, RegionId INTEGER REFERENCES Regions(id));
INSERT INTO "Cities" VALUES(1,'New York',1);
INSERT INTO "Cities" VALUES(2,'Los Angeles',2);
INSERT INTO "Cities" VALUES(3,'Chicago',3);
INSERT INTO "Cities" VALUES(4,'Houston',4);
CREATE TABLE Countries (CountryName TEXT PRIMARY KEY);
INSERT INTO "Countries" VALUES('United States');
INSERT INTO "Countries" VALUES('Canada');
INSERT INTO "Countries" VALUES('Mexico');
INSERT INTO "Countries" VALUES('France');
INSERT INTO "Countries" VALUES('Germany');
CREATE TABLE Ethnicity (CityId INTEGER REFERENCES Cities(id), Year INT PRIMARY KEY, WhitePercentage DECIMAL, BlackOrAfricanAmericanPercentage DECIMAL, AsianPercentage DECIMAL, HispanicOrLatinoPercentage DECIMAL);
INSERT INTO "Ethnicity" VALUES(1,2000,60,15,10,20);
INSERT INTO "Ethnicity" VALUES(1,2010,61,16,11,22);
INSERT INTO "Ethnicity" VALUES(1,2020,62,17,12,23);
CREATE TABLE Populations (CityId INTEGER REFERENCES Cities(id), Year INT PRIMARY KEY, TotalPopulation INT);
INSERT INTO "Populations" VALUES(1,2000,8000000);
INSERT INTO "Populations" VALUES(1,2010,8396000);
INSERT INTO "Populations" VALUES(1,2020,8960000);
CREATE TABLE Regions (RegionName TEXT PRIMARY KEY, CountryId INTEGER REFERENCES Countries(id));
INSERT INTO "Regions" VALUES('Northeast',1);
INSERT INTO "Regions" VALUES('Southwest',1);
INSERT INTO "Regions" VALUES('Central',1);
INSERT INTO "Regions" VALUES('Atlantic',1);
DELETE FROM "sqlite_sequence";
INSERT INTO "sqlite_sequence" VALUES('Cities',4);
COMMIT;
