BEGIN TRANSACTION;
CREATE TABLE PERFORMERS (
    ID INTEGER PRIMARY KEY AUTOINCREMENT,
    NAME TEXT,
    AGE INTEGER,
    GENRE TEXT,
    STREET_PERFORMER BOOLEAN DEFAULT 1, -- Assuming street performer is true by default
    STREET_LOCATION TEXT);
INSERT INTO "PERFORMERS" VALUES(1,'David Blaine',49,'Magic',1,'Times Square, New York');
INSERT INTO "PERFORMERS" VALUES(2,'Dynamo',38,'Magic',0,'Piccadilly Circus, London');
INSERT INTO "PERFORMERS" VALUES(3,'Marco Tempest',52,'Magic',1,'Las Vegas Strip, Las Vegas');
INSERT INTO "PERFORMERS" VALUES(4,'Julius Dein',27,'Magic',1,'Leicester Square, London');
INSERT INTO "PERFORMERS" VALUES(5,'Antonin Decouflé',60,'Mime',1,'Times Square, New York');
INSERT INTO "PERFORMERS" VALUES(6,'Jean-Baptiste Thoret',35,'Mime',0,'La Defense, Paris');
CREATE TABLE PERFORMER_SHOW (
    PERFORMER_ID INTEGER,
    SHOW_ID INTEGER,
    FOREIGN KEY(PERFORMER_ID) REFERENCES PERFORMERS(ID),
    FOREIGN KEY(SHOW_ID) REFERENCES SHOWS(ID));
INSERT INTO "PERFORMER_SHOW" VALUES(1,1);
INSERT INTO "PERFORMER_SHOW" VALUES(2,2);
INSERT INTO "PERFORMER_SHOW" VALUES(3,3);
INSERT INTO "PERFORMER_SHOW" VALUES(4,4);
INSERT INTO "PERFORMER_SHOW" VALUES(5,5);
CREATE TABLE SHOWS (
    ID INTEGER PRIMARY KEY AUTOINCREMENT,
    TITLE TEXT,
    DURATION REAL);
INSERT INTO "SHOWS" VALUES(1,'The Magic Show',90.0);
INSERT INTO "SHOWS" VALUES(2,'Mystery Spectacular',120.0);
INSERT INTO "SHOWS" VALUES(3,'Dynamo Live',105.0);
INSERT INTO "SHOWS" VALUES(4,'Illusionists',110.0);
INSERT INTO "SHOWS" VALUES(5,'Deception',95.0);
CREATE TABLE SHOW_VENUE_MAPPINGS (
    SHOW_ID INTEGER,
    VENUE_ID INTEGER,
    FOREIGN KEY(SHOW_ID) REFERENCES SHOWS(ID),
    FOREIGN KEY(VENUE_ID) REFERENCES VENUES(ID));
INSERT INTO "SHOW_VENUE_MAPPINGS" VALUES(1,1);
INSERT INTO "SHOW_VENUE_MAPPINGS" VALUES(2,2);
INSERT INTO "SHOW_VENUE_MAPPINGS" VALUES(3,3);
INSERT INTO "SHOW_VENUE_MAPPINGS" VALUES(4,4);
INSERT INTO "SHOW_VENUE_MAPPINGS" VALUES(5,5);
CREATE TABLE VENUES (
    ID INTEGER PRIMARY KEY AUTOINCREMENT,
    NAME TEXT,
    LOCATION TEXT);
INSERT INTO "VENUES" VALUES(1,'Broadway Theatre','New York City');
INSERT INTO "VENUES" VALUES(2,'Royal Variety Performance','London');
INSERT INTO "VENUES" VALUES(3,'Palazzo del Cinema','Venice');
INSERT INTO "VENUES" VALUES(4,'Madison Square Garden','New York City');
INSERT INTO "VENUES" VALUES(5,'Wynn Las Vegas','Las Vegas');
DELETE FROM "sqlite_sequence";
INSERT INTO "sqlite_sequence" VALUES('PERFORMERS',6);
INSERT INTO "sqlite_sequence" VALUES('SHOWS',5);
INSERT INTO "sqlite_sequence" VALUES('VENUES',5);
COMMIT;
