#include <bits/stdc++.h>
using namespace std;

const int N = 105;
const double eps = 1e-8;
const double inf = 1000000000;
const double MAXVALUE = 2.2;

int n, m;
double rho[2] = {1, 1.15}, c[2][3][2] = {{{0.9, 1.1}, {1.8, 2.2}, {1.2, 0.8}}, {{2.1, 1.9}, {0.8, 1.2}, {0.9, 1.1}}};
double r[3][2] = {{1.2, 0.8}, {1.3, 1.1}, {0.7, 0.9}}, u[3] = {0.3, 0.3, 0.4}, v[2] = {0.5, 0.5}, opt;
//double rho[2] = {1, 1}, c[2][3][2] = {{{1.8, 2.2}, {1.9, 2.1}, {1.2, 0.8}}, {{2.1, 1.9}, {0.9, 1.1}, {1.8, 2.2}}};
//double r[3][2] = {{1, 1.4}, {1.1, 0.9}, {0.6, 1}}, u[3] = {0.2, 0.4, 0.4}, v[2] = {0.5, 0.5}, opt;
//double rho[2] = {1, 1.3}, c[2][3][2] = {{{2, 0}, {2, 0}, {1, 0}}, {{2, 0}, {1, 0}, {2, 0}}};
//double r[3][2] = {{1.2, 0}, {1, 0}, {0.8, 0}}, u[3] = {0.2, 0.4, 0.4}, v[2] = {1, 0}, opt;
default_random_engine e;
uniform_real_distribution<double> ran(0.0, 1.0);
bool Partial_Info = 0;

// Simplex Method
class Simplex {
    public:
        int n, m;
        double a[N][N], b[N], c[N];
        double ans;

    void init(int N, int M) {
        n = N;
        m = M;
        ans = 0;
        for (int i = 0; i < m; i++)
            for (int j = 0; j < n + m; j++)
                a[i][j] = 0;
        for (int i = 0; i < n + m; i++) b[i] = c[i] = 0;
    }

    void print() {
        printf("Objective:\n");
        for (int i = 0; i < n; i++)
            printf("%lf ", c[i]);
        printf("\nConstraint:\n");
        for (int i = 0; i < m; i++) {
            for (int j = 0; j < n; j++)
                printf("%lf ", a[i][j]);
            printf("%lf\n", b[i]);
        }
        puts("");
    }

    double pivot(int e, int l)
    {
        for (int i = 0; i < n + m; i++) if (i != e) a[l][i] /= a[l][e];
        b[l] /= a[l][e];
        a[l][e] = 1;
        for (int i = 0; i < m; i++)
        {
            if (i == l || fabs(a[i][e]) < eps) continue;
            for (int j = 0; j < n + m; j++)
                if (j != e) a[i][j] -= a[l][j] * a[i][e];
            b[i] -= b[l] * a[i][e];
            a[i][e] = 0;
        }
        double res = b[l] * c[e];
        for (int i = 0; i < n + m; i++)
            if (i != e) c[i] -= c[e] * a[l][i];
        c[e] = 0;
        return res;
    }

    void simplex()
    {
        for (int i = 0; i < m; i++)
            a[i][n + i] = 1;
        while (1)
        {
            int e = 0;
            for (int i = 0; i < n + m; i++, e = i)
                if (c[i] > eps) break;
            if (e == n + m) break;
            double tmp = inf;
            int l = 0;
            for (int i = 0; i < m; i++)
                if (a[i][e] > eps && b[i] / a[i][e] < tmp) tmp = b[i] / a[i][e], l = i;
            ans += pivot(e, l);
        }
    }

    // Return the value of the index-th variable.
    double get_sol(int index) {
        // If it's non-basic, then return 0.
        if (fabs(c[index]) > eps) return 0;
        for (int i = 0; i < m; i++)
            if (fabs(a[i][index] - 1) < eps) return b[i];
    }
};

// Randomly generate a type.
// If c=0, then randomly select \theta; otherwise randomly select \gamma.
int select_type(int U, int V, int c) {
    double pro = ran(e);
    if (c == 0) {
        for (int i = 0; i < U; i++)
            if (pro <= u[i]) return i;
            else pro -= u[i];
    }
    else {
        for (int i = 0; i < V; i++)
            if (pro <= v[i]) return i;
            else pro -= v[i];
    }
}

double adaptive_allocation_algorithm(int U, int V, int m, int T) {
    // Initialization
    // emp_u, emp_v: empirical distribution (non-normailized)
    // B: remaining resources
    int emp_u[U] = {0}, emp_v[V] = {0}, tot = 0;
    double B[m], ans = 0;
    Simplex simplex;
    for (int i = 0; i < m; i++) B[i] = rho[i] * T;

    // Run the algorithm.
    for (int t = 1; t <= T; t++) {
        // Observe the type.
        int theta = select_type(U, V, 0), x;
        // If t=1, then just accept; otherwise compute the optimal solution of the LP and accept with some probability.
        if (t == 1) x = 1;
        else {
            // Initialize the LP
            simplex.init(U, m + U);
            for (int j = 0; j < U; j++) {
                simplex.c[j] = 0;
                for (int k = 0; k < V; k++)
                    simplex.c[j] += r[j][k] * emp_v[k] / (t - 1);
                simplex.c[j] = simplex.c[j] * emp_u[j] / (t - 1);
            }
            for (int i = 0; i < m; i++) {
                simplex.b[i] = B[i] / (T - t + 1);
                for (int j = 0; j < U; j++) {
                    simplex.a[i][j] = 0;
                    for (int k = 0; k < V; k++)
                        simplex.a[i][j] += c[i][j][k] * emp_v[k] / (t - 1);
                    simplex.a[i][j] = simplex.a[i][j] * emp_u[j] / (t - 1);
                }
            }
            for (int j = 0; j < U; j++) {
                simplex.b[m + j] = 1;
                simplex.a[m + j][j] = 1;
            }
            // Run the simplex algorithm.
            simplex.simplex();
            // Accept with some probability.
            double pro = simplex.get_sol(theta);
            if (ran(e) <= pro) x = 1;
            else x = 0;
        }

        int gamma = select_type(U, V, 1);
        emp_u[theta]++;
        if (!Partial_Info || x) emp_v[gamma]++;

        // If the resources are not sufficient, then terminate.
        for (int i = 0; i < m; i++)
            if (B[i] < MAXVALUE) {
                //printf("Not Participate: %d\n", T - tot);
                return ans;
            }
        
        // If accept, then update the status.
        if (x == 1) {
            //cerr << t << endl;
            tot++;
            ans += r[theta][gamma];
            for (int i = 0; i < m; i++)
                B[i] -= c[i][theta][gamma];
        }
    }
    //printf("Not Participate: %d\n", T - tot);
    return ans;
}

double compute_opt(int U, int V, int m) {
    Simplex simplex;
    simplex.init(U, m + U);
    for (int j = 0; j < U; j++) {
        simplex.c[j] = 0;
        for (int k = 0; k < V; k++)
            simplex.c[j] += v[k] * r[j][k];
        simplex.c[j] *= u[j];
    }
    for (int i = 0; i < m; i++) {
        simplex.b[i] = rho[i];
        for (int j = 0; j < U; j++) {
            simplex.a[i][j] = 0;
            for (int k = 0; k < V; k++)
                simplex.a[i][j] += v[k] * c[i][j][k];
            simplex.a[i][j] *= u[j];
        }
    }
    for (int j = 0; j < U; j++) {
        simplex.b[m + j] = 1;
        simplex.a[m + j][j] = 1;
    }
    simplex.print();
    simplex.simplex();
    for (int i = 0; i < U; i++)
        printf("%lf ", simplex.get_sol(i));
    puts("");
    return simplex.ans;
}

int main()
{
    char str[100];
    e.seed(time(0));
    int U = 3, V = 2, m = 2, T = 64000, K = 20000;
    //init();
    // printf("%lf\n", opt);
    opt = compute_opt(U, V, m);

    cerr << "Full Nondegenerate" << endl;
    rho[1] = 1; Partial_Info = 0;
    opt = compute_opt(U, V, m);
    str[0] = '\0';
    strcat(str, "full-nondegenerate0.txt");
    for (int t = 2000; t <= T; t *= 2) {
        freopen(str, "w", stdout);

        printf("T = %d\n", t);
        double sum = 0;
        for (int i = 0; i < K; i++) {
            double w = adaptive_allocation_algorithm(U, V, m, t);
            sum += w;
            printf("%lf\n", opt * t - w);
        }
        printf("Regret = %lf\n", opt * t - sum / K);

        fclose(stdout);
        cerr << "Regret = " << opt * t - sum / K << endl;
        str[18]++;
    }

    cerr << "Full Degenerate" << endl;
    rho[1] = 1.15; Partial_Info = 0;
    opt = compute_opt(U, V, m);
    str[0] = '\0';
    strcat(str, "full-degenerate0.txt");
    for (int t = 2000; t <= T; t *= 2) {
        freopen(str, "w", stdout);

        printf("T = %d\n", t);
        double sum = 0;
        for (int i = 0; i < K; i++) {
            double w = adaptive_allocation_algorithm(U, V, m, t);
            sum += w;
            printf("%lf\n", opt * t - w);
        }
        printf("Regret = %lf\n", opt * t - sum / K);

        fclose(stdout);
        cerr << "Regret = " << opt * t - sum / K << endl;
        str[15]++;
    }

    cerr << "Partial Nondegenerate" << endl;
    rho[1] = 1; Partial_Info = 1;
    opt = compute_opt(U, V, m);
    str[0] = '\0';
    strcat(str, "partial-nondegenerate0.txt");
    for (int t = 2000; t <= T; t *= 2) {
        freopen(str, "w", stdout);

        printf("T = %d\n", t);
        double sum = 0;
        for (int i = 0; i < K; i++) {
            double w = adaptive_allocation_algorithm(U, V, m, t);
            sum += w;
            printf("%lf\n", opt * t - w);
        }
        printf("Regret = %lf\n", opt * t - sum / K);

        fclose(stdout);
        cerr << "Regret = " << opt * t - sum / K << endl;
        str[21]++;
    }

    cerr << "Partial Degenerate" << endl;
    rho[1] = 1.15; Partial_Info = 1;
    opt = compute_opt(U, V, m);
    str[0] = '\0';
    strcat(str, "partial-degenerate0.txt");
    for (int t = 2000; t <= T; t *= 2) {
        freopen(str, "w", stdout);

        printf("T = %d\n", t);
        double sum = 0;
        for (int i = 0; i < K; i++) {
            double w = adaptive_allocation_algorithm(U, V, m, t);
            sum += w;
            printf("%lf\n", opt * t - w);
        }
        printf("Regret = %lf\n", opt * t - sum / K);

        fclose(stdout);
        cerr << "Regret = " << opt * t - sum / K << endl;
        str[18]++;
    }
    return 0;
}
// 2000-64000
// 20000