#!/bin/bash

# Define an array of percent values
percents=(30 40 50 60 80)
horizons=(64 128 256 336 396 512 768 1024)

# Loop through each percent value in the array
for percent in "${percents[@]}"
do
    for horizon in "${horizons[@]}"
    do
        # Note: Each python command will complete before the next one starts.
        python3 -u run.py \
        --is_training 1 \
        --root_path ./dataset/weather/ \
        --data_path weather.csv \
        --model_id "050573_weather_${horizon}_192_percentIs${percent}" \
        --model iTransformer \
        --data custom \
        --features M \
        --percent $percent \
        --seq_len $horizon \
        --label_len 1 \
        --pred_len 192 \
        --e_layers 4 \
        --enc_in 862 \
        --dec_in 862 \
        --c_out 862 \
        --des 'Exp' \
        --d_model 512 \
        --d_ff 512 \
        --batch_size 32 \
        --train_epochs 60 \
        --learning_rate 0.0004 \
        --weight_decay 0.00001 \
        --patience 10 \
        --coef 0.95 \
        --itr 3 >> "050573_weather_${horizon}_192_percent${percent}.log"
        wait
    done
done
