#!/bin/bash

# Define an array of percent values
percents=(100)
width=(8 12 16 32 64 128 256 384 512)

# Loop through each percent value in the array
for percent in "${percents[@]}"
do
for width in "${width[@]}"
do
    # Note: Each python command will complete before the next one starts.
    python3 -u run.py \
    --is_training 1 \
    --root_path ./dataset/traffic/ \
    --data_path traffic.csv \
    --model_id "051483_l2dim${width}_traffic_336_192_percentIs${percent}_another3Iter" \
    --model iTransformer \
    --data custom \
    --features M \
    --percent $percent \
    --seq_len 336 \
    --label_len 192 \
    --pred_len 192 \
    --e_layers 2 \
    --enc_in 862 \
    --dec_in 862 \
    --c_out 862 \
    --des 'Exp' \
    --d_model $width \
    --d_ff $width \
    --batch_size 20 \
    --train_epochs 60 \
    --learning_rate 0.0004 \
    --weight_decay 0.00001 \
    --patience 10 \
    --coef 0.95 \
    --itr 3 >> "051483_l2dim${width}_traffic_336_192_percentIs${percent}_another3Iter.log"
    wait
done
done