#!/bin/bash

# Define the array of percent values
percents=(11 16 25 37 60 100)

# Define the array of interpolate_len values
horizon_lens=(3 6 12 18 24 32 48 64 128 192)
weight_decays=(0.0005)
# Loop over each percent value
for percent in "${percents[@]}"; do
    # Loop over each interpolate_len value
    for horizon in "${horizon_lens[@]}"; do
    for weight_decay in "${weight_decays[@]}";do
        # Define model_id and log file name dynamically based on current percent and interpolate_len
        model_id="New051851_wd=${weight_decay}__Linearinterpolate_exchange_interto${horizon}__${horizon}_192__p${percent}_lr1e-3_wd1e-5_lasso0_bs8192"
        log_file="${model_id}.log"

        # Run the Python script with current configurations
        nohup python3 -u run.py \
            --exp_name MTSF \
            --is_training 1 \
            --root_path ./dataset/exchange_rate/ \
            --data_path exchange_rate.csv \
            --model_id "$model_id" \
            --model Linear_interpolate \
            --in_patch_stride 1 --in_patch_size 1 \
            --out_patch_stride 1 --out_patch_size 1 \
            --data custom \
            --features M \
            --interpolate_len "$horizon" \
            --seq_len "$horizon" \
            --pred_len 192 \
            --label_len 1 \
            --des 'Exp' \
            --e_layers 1 \
            --d_model 768 \
            --enc_in 21 \
            --dec_in 21 \
            --c_out 21 \
            --d_ff 192 \
            --itr 3 \
            --batch_size 2048 \
            --train_epochs 60 \
            --learning_rate 0.0002 \
            --weight_decay "$weight_decay" \
            --l1_lambda 0.0 \
            --percent "$percent" \
            --patience 10 \
            --coef 0.98 >> "$log_file"
        wait
    done
    done
done


