from agentgym.task_suites.task_suite import TaskEnvironment, TaskSuite
from agentgym.tools.slack import (
    Slack,
    add_user_to_channel,
    get_channels,
    get_users_in_channel,
    invite_user_to_slack,
    read_channel_messages,
    read_inbox,
    remove_user_from_slack,
    send_channel_message,
    send_direct_message,
)
from agentgym.tools.web import Web, get_webpage, post_webpage


class SlackEnvironment(TaskEnvironment):
    slack: Slack
    web: Web


TOOLS = [
    get_channels.__name__,
    add_user_to_channel.__name__,
    read_channel_messages.__name__,
    read_inbox.__name__,
    send_direct_message.__name__,
    send_channel_message.__name__,
    get_users_in_channel.__name__,
    invite_user_to_slack.__name__,
    remove_user_from_slack.__name__,
    get_webpage.__name__,
    post_webpage.__name__,
]

task_suite = TaskSuite[SlackEnvironment]("slack", SlackEnvironment, TOOLS)
