"""
Generating a dataset where the golden patch is actually generated by swe-agent
To check how useful crosschecking with swt-agent is
"""
import json
import os.path
import re
import subprocess
from typing import Optional
import os.path
import re
import subprocess
from datasets import load_dataset, Dataset, DatasetDict, load_from_disk

from unidiff import PatchSet

# Load the dataset
dataset = load_dataset("princeton-nlp/SWE-bench_Lite_bm25_27K")
swe_bench_result_dir = "results/experiments-swe-bench/20240402_sweagent_gpt4/trajs"

def load_swe_agent_patch(instance_id: str):
    traj_file = os.path.join(swe_bench_result_dir, f"{instance_id}.traj")
    if not os.path.exists(traj_file):
        return None
    with open(traj_file) as f:
        traj = json.load(f)
    sub = traj["info"].get("submission")
    return sub



splits = {}
for split in ["test"]:
    count = 0
    num_new_funs = 0
    total_count = 0
    new_examples = []
    for i, example in enumerate(dataset[split]):
        files = []
        repo_name = example["repo"].split("/")[-1]
        instance_id = example["instance_id"]
        patch = load_swe_agent_patch(instance_id)
        if patch is None:
            continue
        new_example = {
            **example,
            # The patch proposed by SWE-agent
            "patch": f"<patch>{patch}</patch>",
        }
        new_examples.append(new_example)
with open("datasets/swe_agent_patches.json", "w") as f:
    json.dump(new_examples, f, indent=2)

