import configparser
import json

import matplotlib.pyplot as plt
import os, sys
BASE_DIR = os.path.dirname(os.path.abspath(__file__))
BASE_DIR = os.path.dirname(BASE_DIR)
sys.path.append(BASE_DIR)

import argparse
import pickle
from utils.utils import set_seed, read_config_file
import numpy as np
import os

smooth_gamma = 0.0

files = [
# "../logs/rouge_gov-report_max-1000_per-5_llama2-7b-chat_weave-v10_gov-report-data_2024-01-05_18-38-17_0.pkl",
# "../logs/rouge_gov-report_max-1000_per-5_llama2-7b-chat_rerope_gov-report-data_2024-01-05_16-07-54_0.pkl",
# "../logs/rouge_gov-report_max-1000_per-5_llama2-7b-chat_lm-infinite_gov-report-data_2024-01-05_17-16-07_0.pkl",
"../logs/rouge_gov-report_max-1000_per-5_llama2-7b-chat_streaming-llm_gov-report-data_2024-01-05_17-51-52_0.pkl",



]
labels = [
    "weave"
]

width = 80 #0.2
num_datasets = len(files)
index = 0
for _filename, _label in zip(files, labels):
    with open(_filename, "rb") as f:
        data = pickle.load(f)["all_length_score"]
        smoothed = [0]
        var_values = []

        rouges = []
        max_rouges = []

        keys = list(data.keys())
        keys.sort()
        for key in keys:
            def get_max_bleu():
                bleus = data[key]["bleu"]
                max_bleu = max(bleus)
                max_bleu_index = bleus.index(max_bleu)
                return max_bleu_index

            max_bleu_index = get_max_bleu()
            response = data[key]["record"][max_bleu_index]["response"]

            response = "\n".join(response.strip().split("\n")[1:])

            print("{}: \n{}".format(str(key/1024)+"k", response))

