import configparser
import json

import torch
import numpy as np
import random
import re

from transformers import HfArgumentParser


def set_seed(seed):
    if seed is None:
        return
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    np.random.seed(seed)
    random.seed(seed)


def get_model(model_path, device, method=None, args=None):
    if method == None:
        from transformers import LlamaForCausalLM, LlamaTokenizer
    elif method == "rerope":
        from transformers import LlamaForCausalLM, LlamaTokenizer
        import methods.rerope
    elif method == "leaky-rerope":
        from transformers import LlamaTokenizer, LlamaForCausalLM
        import methods.leaky_rerope_patch
    elif method == "weave-v20":
        from transformers import LlamaForCausalLM, LlamaTokenizer
        import methods.weave_v20
        if "vicuna" in model_path:
            from methods.weave_v20 import position_set
            position_set.train_length = 2048
            position_set.last_context = 1024 # 512 #1200 #800 #1024 # 800 # 512
            position_set.context_window_length = 2048
            position_set.push_width = 200 #500 # 200 #100 # 10 #20
        if "llama2-7b-chat" in model_path:
            from methods.weave_v20 import position_set
            position_set.push_width = 20 # 10
            position_set.last_context = 800 #612 #1024
            position_set.context_window_length = 2048
            position_set.train_length = 2048
    elif method == "rerope-ablation":
        from transformers import LlamaForCausalLM, LlamaTokenizer
        # elif method == "rerope-weave-v20":
        import methods.rerope_weave_v20_self
        if "vicuna" in model_path:
            from methods.rerope_weave_v20_self import position_set
            position_set.train_length = 2048
            position_set.last_context = 1024 # 512 #1200 #800 #1024 # 800 # 512
            position_set.context_window_length = 2048
            position_set.push_width = 200 #500 # 200 #100 # 10 #20
        if "llama2-7b-chat" in model_path:
            from methods.rerope_weave_v20_self import position_set
            position_set.push_width = 20 # 10
            position_set.last_context = 800 #612 #1024
            position_set.context_window_length = 2048
            position_set.train_length = 2048
    elif method == "leaky-rerope-ablation":
        from transformers import LlamaForCausalLM, LlamaTokenizer
        # elif method == "rerope-weave-v20":
        import methods.leaky_rerope_weave_v20_other
        if "vicuna" in model_path:
            from methods.leaky_rerope_weave_v20_other import position_set
            position_set.train_length = 2048
            position_set.last_context = 1024 # 512 #1200 #800 #1024 # 800 # 512
            position_set.context_window_length = 2048
            position_set.push_width = 200 #500 # 200 #100 # 10 #20
        if "llama2-7b-chat" in model_path:
            from methods.leaky_rerope_weave_v20_other import position_set
            position_set.push_width = 20 # 10
            position_set.last_context = 800 #612 #1024
            position_set.context_window_length = 2048
            position_set.train_length = 2048

    elif method == "old":
        from transformers import LlamaForCausalLM, LlamaTokenizer
    elif method == "lm-infinite":
        # hack_args = (args.use_lambda_attention, args.local_branch, args.global_branch,
        #              args.limit_distance, args.triangle_offset)
        use_lambda_attention = True
        local_branch = 2048
        global_branch = 100
        limit_distance = 2048
        triangle_offset = 0.0
        hack_args = (use_lambda_attention, local_branch, global_branch,
                     limit_distance, triangle_offset)
    elif method == "streaming-llm":
        from transformers import AutoModelForCausalLM, AutoTokenizer
    elif method == "dynamic-ntk" or method == "dynamic-ntk-llama2":
        from transformers import LlamaForCausalLM, LlamaTokenizer, LlamaConfig
        from methods.dynamic_ntk_patch import patch_llama_for_dynamic_scaled_rotary_embeddings
    elif method == "unlimiformer":
        from transformers import LlamaTokenizer, LlamaForCausalLM
        from methods.unlimiformer_method.unlimiformer import UnlimiformerArguments, Unlimiformer
    elif method == "weave-mpt7":
        from models.mpt_7b.modeling_mpt import MPTForCausalLM, MPTConfig
        from transformers import AutoTokenizer
        import methods.weave_mpt7
    elif method == "weave-baichuan1":
        from models.baichuan_13b.modeling_baichuan import BaichuanForCausalLM
        from models.baichuan_13b.tokenization_baichuan import BaichuanTokenizer
        import methods.weave_baichuan1
    elif method == "weave-pythia1":
        from transformers.models.gpt_neox.modeling_gpt_neox import GPTNeoXForCausalLM
        from transformers import AutoTokenizer
        import methods.weave_pythia1
    elif method == "weave-pythia2":
        from transformers.models.gpt_neox.modeling_gpt_neox import GPTNeoXForCausalLM
        from transformers import AutoTokenizer
        import methods.weave_pythia2
    elif method == "weave-pythia3":
        from transformers.models.gpt_neox.modeling_gpt_neox import GPTNeoXForCausalLM
        from transformers import AutoTokenizer
        import methods.weave_pythia3
    elif method == "weave-pythia4":
        from transformers.models.gpt_neox.modeling_gpt_neox import GPTNeoXForCausalLM
        from transformers import AutoTokenizer
        import methods.weave_pythia4
    else:
        raise NotImplementedError("A no implement method")

    if "vicuna" in model_path or "llama" in model_path or "alpaca" in model_path or "longchat" in model_path:
        if method == "rerope" or method == "old" or method == "wave" or method == "leaky-rerope":
            # 只能使用固定的cuda配置，单块卡
            if "hard_cuda" in args:
                if args.hard_cuda == 1:
                    tokenizer = LlamaTokenizer.from_pretrained(model_path)
                    model = LlamaForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16)
                elif args.hard_cuda == 0:
                    from tensor_parallel import tensor_parallel
                    tokenizer = LlamaTokenizer.from_pretrained(model_path)
                    model = LlamaForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16)
                    model = tensor_parallel(model)
            else:
                from tensor_parallel import tensor_parallel
                tokenizer = LlamaTokenizer.from_pretrained(model_path)
                model = LlamaForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16)
                model = tensor_parallel(model)
        elif "weave" in method:
            tokenizer = LlamaTokenizer.from_pretrained(model_path)
            model = LlamaForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16)
            # 测试 并行
            if "weave-v30" in method:
                from tensor_parallel import tensor_parallel
                model = tensor_parallel(model)


        elif method == "lm-infinite":
            from methods.lminfinite.lm_infinite import LLAMA_Model
            max_length = 32770
            truncation_side = "right"
            load_in_4bit = False
            model = LLAMA_Model(
                model_path, model_path,
                max_length, truncation_side,
                load_in_4bit, device, *hack_args
            )
            tokenizer = model.tokenizer
        elif method == "streaming-llm":
            from methods.streaming_llm.enable_streaming_llm import enable_streaming_llm
            from methods.streaming_llm_method import StreamingLLM
            tokenizer = AutoTokenizer.from_pretrained(model_path)
            model = AutoModelForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16)
            start_size, recent_size = 4, 2000
            # 设置为一半
            if "llama-3b" in model_path or "vicuna" in model_path:
                start_size, recent_size = 4, 1020

            kv_cache = enable_streaming_llm(model, start_size=start_size, recent_size=recent_size)
            model = StreamingLLM(model=model, tokenizer=tokenizer, kv_cache=kv_cache, max_gen_len=50)
        elif method == "dynamic-ntk":
            from tensor_parallel import tensor_parallel
            config = LlamaConfig.from_pretrained(model_path)
            config.rope_scaling = {
                "type": "dynamic",
                "factor": 2.0
            }
            model = LlamaForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16, config=config)
            if "LlamaForCausalLM" in model.config.architectures:
                patch_llama_for_dynamic_scaled_rotary_embeddings(model, ntk=2.0)
            else:
                raise NotImplementedError("not LlamaForCausalLM for ntk")
            model = tensor_parallel(model)
            tokenizer = LlamaTokenizer.from_pretrained(model_path)
        elif method == "dynamic-ntk-llama2":
            from tensor_parallel import tensor_parallel
            config = LlamaConfig.from_pretrained(model_path)
            config.rope_scaling = {
                "type": "dynamic",
                "factor": 2.0
            }
            model = LlamaForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16, config=config)
            model = tensor_parallel(model)
            tokenizer = LlamaTokenizer.from_pretrained(model_path)
        elif method == "unlimiformer":
            tokenizer = LlamaTokenizer.from_pretrained(model_path)
            model = LlamaForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16)
            hf_parser = HfArgumentParser(UnlimiformerArguments)
            unlimiformer_args, unknown_unlimiformer_args = hf_parser.parse_known_args()
            if unlimiformer_args.test_unlimiformer:
                unlimiformer_kwargs = {
                    'layer_begin': unlimiformer_args.layer_begin,
                    'layer_end': unlimiformer_args.layer_end,
                    'unlimiformer_head_num': unlimiformer_args.unlimiformer_head_num,
                    'exclude_attention': unlimiformer_args.unlimiformer_exclude,
                    'chunk_overlap': unlimiformer_args.unlimiformer_chunk_overlap,
                    'model_encoder_max_len': unlimiformer_args.unlimiformer_chunk_size,
                    'verbose': unlimiformer_args.unlimiformer_verbose, 'tokenizer': tokenizer,
                    'unlimiformer_training': unlimiformer_args.unlimiformer_training,
                    'use_datastore': unlimiformer_args.use_datastore,
                    'flat_index': unlimiformer_args.flat_index,
                    'test_datastore': unlimiformer_args.test_datastore,
                    'reconstruct_embeddings': unlimiformer_args.reconstruct_embeddings,
                    'gpu_datastore': unlimiformer_args.gpu_datastore,
                    'gpu_index': unlimiformer_args.gpu_index,
                    'index_devices': unlimiformer_args.index_devices,
                    'datastore_device': args.cuda,
                }

                model = Unlimiformer.convert_model(model, **unlimiformer_kwargs)
        else:
            raise NotImplementedError("no inplement method")

    elif "mpt" in model_path:
        if "old" == method:
            from models.mpt_7b.modeling_mpt import MPTForCausalLM, MPTConfig
            from transformers import AutoTokenizer
            config = MPTConfig.from_pretrained(model_path)
            config.max_seq_len = 32 * 1024
            # 暂时设置该参数，否则运算极其慢
            # config.use_cache = True
            config.use_cache = False
            tokenizer = AutoTokenizer.from_pretrained(model_path)
            model = MPTForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16, config=config)
        elif "weave-mpt1" == method:
            # from methods.weave_mpt1 import build_alibi_bias as new_build_alibi_bias
            # from models.mpt_7b.attention import build_alibi_bias as old_build_alibi_bias
            # old_build_alibi_bias = new_build_alibi_bias


            config = MPTConfig.from_pretrained(model_path)
            config.max_seq_len = 32 * 1024
            # 暂时设置该参数，否则运算极其慢
            # 对于weave 似乎？
            config.use_cache = True
            # config.use_cache = False
            tokenizer = AutoTokenizer.from_pretrained(model_path)
            model = MPTForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16,
                                                   config=config)

        elif "weave-mpt2" == method:
            config = MPTConfig.from_pretrained(model_path)
            config.max_seq_len = 32*1024
            # 暂时设置该参数，否则运算极其慢
            # 对于weave 似乎？
            config.use_cache = True
            # config.use_cache = False
            tokenizer = AutoTokenizer.from_pretrained(model_path)
            model = MPTForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16,
                                                   config=config)

        elif "weave-mpt3" == method:
            config = MPTConfig.from_pretrained(model_path)
            config.max_seq_len = 32*1024
            # 暂时设置该参数，否则运算极其慢
            # 对于weave 似乎？
            config.use_cache = True
            # config.use_cache = False
            tokenizer = AutoTokenizer.from_pretrained(model_path)
            model = MPTForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16,
                                                   config=config)
        elif "weave-mpt4" == method:
            config = MPTConfig.from_pretrained(model_path)
            config.max_seq_len = 32*1024
            # 暂时设置该参数，否则运算极其慢
            # 对于weave 似乎？
            config.use_cache = True
            # config.use_cache = False
            tokenizer = AutoTokenizer.from_pretrained(model_path)
            model = MPTForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16,
                                                   config=config)

        elif "weave-mpt5" == method or "weave-mpt" in method:
            config = MPTConfig.from_pretrained(model_path)
            config.max_seq_len = 32*1024
            # 暂时设置该参数，否则运算极其慢
            # 对于weave 似乎？
            config.use_cache = True
            # config.use_cache = False

            # alibi 是近似，测试是否有效 emb_pos
            config.learned_pos_emb = True

            tokenizer = AutoTokenizer.from_pretrained(model_path)
            model = MPTForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16,
                                                   config=config)

        elif method == "streaming-llm":
            from models.mpt_7b.modeling_mpt import MPTForCausalLM, MPTConfig
            from transformers import AutoTokenizer
            config = MPTConfig.from_pretrained(model_path)
            config.max_seq_len = 32 * 1024
            # 暂时设置该参数，否则运算极其慢
            config.use_cache = True
            # config.use_cache = False
            tokenizer = AutoTokenizer.from_pretrained(model_path)
            model = MPTForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16,
                                                   config=config)

            from methods.streaming_llm.enable_streaming_llm import enable_streaming_llm
            from methods.streaming_llm_method import StreamingLLM

            start_size, recent_size = 4, 2000
            kv_cache = enable_streaming_llm(model, start_size=start_size, recent_size=recent_size)
            model = StreamingLLM(model=model, tokenizer=tokenizer, kv_cache=kv_cache, max_gen_len=50)

        elif method == "lm-infinite":
            from methods.lminfinite.mpt_7b import MPT_7B_Model
            max_length = 32770
            truncation_side = "right"

            # 设置 use lambda attention 为 false： false时计算偏慢
            use_lambda_attention = False
            local_branch = 2048
            global_branch = 100
            limit_distance = 2048
            triangle_offset = 0.0
            hack_args = (use_lambda_attention, local_branch, global_branch,
                         limit_distance, triangle_offset)

            model = MPT_7B_Model(model_path, max_length, truncation_side, device, *hack_args)
            tokenizer = model.tokenizer

            import models.mpt_7b.attention as mpt_attention
            import models.mpt_7b.lm_infinite_attention as lm_infinite_attention
            mpt_attention.GroupedQueryAttention.forward = lm_infinite_attention.GroupedQueryAttention.forward
        else:
            raise NotImplementedError("no implement")

    elif "baichuan" in model_path:
        if "old" == method:
            from models.baichuan_13b.modeling_baichuan import BaichuanForCausalLM
            # from transformers import AutoTokenizer
            from models.baichuan_13b.tokenization_baichuan import BaichuanTokenizer

            tokenizer = BaichuanTokenizer.from_pretrained(model_path)
            model = BaichuanForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16)
        elif "weave-baichuan1" == method:
            tokenizer = BaichuanTokenizer.from_pretrained(model_path)
            model = BaichuanForCausalLM.from_pretrained(model_path, device_map=device, torch_dtype=torch.float16)
        else:
            raise NotImplementedError("no implement")

    elif "pythia" in model_path:
        if "old" == method:
            from transformers import GPTNeoXForCausalLM
            from transformers import AutoTokenizer
            model = GPTNeoXForCausalLM.from_pretrained(
                model_path,
                # revision="step3000",
                device_map=device,
                # config=config,
            )

            tokenizer = AutoTokenizer.from_pretrained(model_path)

        elif "weave-pythia" in method:
            model = GPTNeoXForCausalLM.from_pretrained(
                model_path,
                # revision="step3000",
                device_map=device,
                # config=config,
            )

            tokenizer = AutoTokenizer.from_pretrained(model_path)

        elif "streaming-llm" == method:
            from transformers import GPTNeoXForCausalLM
            from transformers import AutoTokenizer
            model = GPTNeoXForCausalLM.from_pretrained(
                model_path,
                device_map=device,
            )
            tokenizer = AutoTokenizer.from_pretrained(model_path)

            from methods.streaming_llm.enable_streaming_llm import enable_streaming_llm
            from methods.streaming_llm_method import StreamingLLM

            start_size, recent_size = 4, 1024
            kv_cache = enable_streaming_llm(model, start_size=start_size, recent_size=recent_size)
            model = StreamingLLM(model=model, tokenizer=tokenizer, kv_cache=kv_cache, max_gen_len=50)

        else:
            raise NotImplementedError



    else:
        raise NotImplementedError

    # if method == "rerope" or method == "old":
    #     from tensor_parallel import tensor_parallel
    #     model = tensor_parallel(model)

    return tokenizer, model

def get_tokenizer(model_path):
    from transformers import LlamaTokenizer
    if "vicuna" in model_path or "llama" in model_path or "alpaca" in model_path:
        tokenizer = LlamaTokenizer.from_pretrained(model_path)
    elif "mpt" in model_path or "pythia" in model_path:
        from transformers import AutoTokenizer
        tokenizer = AutoTokenizer.from_pretrained(model_path)
    else:
        raise NotImplementedError

    return tokenizer


def get_prompt_weave_v20_llama3b():
    SYSTEM_INFO = "Q:{}  \n\nWhat's the pass key?\nA:"
    return SYSTEM_INFO

def get_prompt_2_weave_v20_llama3b():
    SYSTEM_INFO = "Q:{}  \n\nA:"
    return SYSTEM_INFO

def get_prompt_3_weave_v20_llama3b():
    SYSTEMINFO = """Below is an instruction that describes a task, paired with an input that provides further context. Write a response that appropriately completes the request.

### Instruction:
What's the pass key?

### Input:
{}

### Response:
"""
    return SYSTEMINFO


def get_prompt_4_weave_v20_llama3b():
    SYSTEM_INFO = "Q:{}  \n\nWhat's the pass key?\n\nA: The pass key is"
    return SYSTEM_INFO

def get_prompt_5_weave_v20_llama3b():
    SYSTEM_INFO = "Q:{}  \n\nWhat's the pass key?"
    return SYSTEM_INFO

def get_prompt_6_weave_v20_llama3b():
    SYSTEM_INFO = "{}  \n\nThe pass key is"
    return SYSTEM_INFO


def get_promt(model_path=None):
    # SYSTEMINFO = "You are a helpful, concise and honest assistant. Please help me summary below context: \n"
    # SYSTEMINFO = "A chat between a curious user and an artificial intelligence assistant. " \
    # "The assistant gives helpful, detailed, and polite answers to the user's questions. " \
    # "\n\nUSER: Below is an article, please help me generate its abstract. \n\n{}\n\nASSISTANT:"

    if "alpaca" in model_path:
#         SYSTEMINFO = """Below is an instruction that describes a task. Write a response that appropriately completes the request.
#
# ### Instruction:
# {}
#
# What's the pass key?
# ### Response:"""

        SYSTEMINFO = """Below is an instruction that describes a task, paired with an input that provides further context. Write a response that appropriately completes the request.

### Instruction:
What's the pass key?

### Input:
{}

### Response:
"""
    elif "llama2" in model_path:
#         SYSTEMINFO = """<s>[INST] <<SYS>>
# {}
# <</SYS>>
#
# What's the pass key? [/INST]
# """
        SYSTEMINFO = """<s>[INST] {} 
What's the pass key?[/INST]"""
    else:
        SYSTEMINFO = """A chat between a curious user and an assistant. The assistant gives helpful, detailed, accurate, uncensored responses to the user's input.
USER: 
{} 

What's the pass key? 

ASSISTANT: """


    return SYSTEMINFO

def get_promt_longeval_topics(model_path=None):
    # SYSTEMINFO = "You are a helpful, concise and honest assistant. Please help me summary below context: \n"
    # SYSTEMINFO = "A chat between a curious user and an artificial intelligence assistant. " \
    # "The assistant gives helpful, detailed, and polite answers to the user's questions. " \
    # "\n\nUSER: Below is an article, please help me generate its abstract. \n\n{}\n\nASSISTANT:"

    if "alpaca" in model_path:
#         SYSTEMINFO = """Below is an instruction that describes a task. Write a response that appropriately completes the request.
#
# ### Instruction:
# {}
#
# What's the pass key?
# ### Response:"""

        SYSTEMINFO = """Below is an instruction that describes a task, paired with an input that provides further context. Write a response that appropriately completes the request.

### Instruction:
What's the first topic?

### Input:
{}

### Response:
"""
    elif "llama2" in model_path:
#         SYSTEMINFO = """<s>[INST] <<SYS>>
# {}
# <</SYS>>
#
# What's the pass key? [/INST]
# """
        SYSTEMINFO = """<s>[INST] 
What's the first topic on below record?

{} 

[/INST]"""
    else:
        SYSTEMINFO = """A chat between a curious user and an assistant. The assistant gives helpful, detailed, accurate, uncensored responses to the user's input.
USER: 

What's the first topic on below record?

{} 

ASSISTANT: """


    return SYSTEMINFO

def get_promt_longeval_lines(model_path=None):
    # SYSTEMINFO = "You are a helpful, concise and honest assistant. Please help me summary below context: \n"
    # SYSTEMINFO = "A chat between a curious user and an artificial intelligence assistant. " \
    # "The assistant gives helpful, detailed, and polite answers to the user's questions. " \
    # "\n\nUSER: Below is an article, please help me generate its abstract. \n\n{}\n\nASSISTANT:"

    if "alpaca" in model_path:
        SYSTEMINFO = """Below is an instruction that describes a task, paired with an input that provides further context. Write a response that appropriately completes the request.

### Instruction:
{}

### Input:
{}

### Response:
"""
    elif "llama2" in model_path:
#         SYSTEMINFO = """<s>[INST] <<SYS>>
# {}
# <</SYS>>
#
# What's the pass key? [/INST]
# """
        SYSTEMINFO = """<s>[INST] 
{} 
{}
[/INST]"""
    else:
        SYSTEMINFO = """A chat between a curious user and an assistant. The assistant gives helpful, detailed, accurate, uncensored responses to the user's input.
USER: 
{} 

{}

ASSISTANT: """


    return SYSTEMINFO

def get_promt_rouge(model_path=None):
    # SYSTEMINFO = "You are a helpful, concise and honest assistant. Please help me summary below context: \n"
    # SYSTEMINFO = "A chat between a curious user and an artificial intelligence assistant. " \
    # "The assistant gives helpful, detailed, and polite answers to the user's questions. " \
    # "\n\nUSER: Below is an article, please help me generate its abstract. \n\n{}\n\nASSISTANT:"

    if "alpaca" in model_path:
#         SYSTEMINFO = """Below is an instruction that describes a task. Write a response that appropriately completes the request.
#
# ### Instruction:
# {}
#
# What's the pass key?
# ### Response:"""

        SYSTEMINFO = """Below is an instruction that describes a task, paired with an input that provides further context. Write a response that appropriately completes the request.

### Instruction:
Please help me summarize its main content from the input below.

### Input:
{}

### Response:
"""
    elif "llama2" in model_path:
        SYSTEMINFO = """<s>[INST] <<SYS>>
Please help me summarize its main content from the below.
<</SYS>>
{}
 [/INST]
"""
#         SYSTEMINFO = """<s>[INST] {}
# What's the pass key?[/INST]"""
    else:
        SYSTEMINFO = """A chat between a curious user and an assistant. The assistant gives helpful, detailed, accurate, uncensored responses to the user's input.
USER: Please help me summarize its main content from the below.

{} 

ASSISTANT: """


    return SYSTEMINFO

def compare_retrieval_acc(response, target):
    def extract_answer(text):
        answer = re.findall(r'\d+', text)
        if len(answer) == 0:
            return 0
        else:
            return int(answer[0])

    if extract_answer(response) == int(target):
        return 1
    else:
        return 0



def read_config_file(config_path):
    if "../conf/" not in config_path:
        config_path = "../conf/" + config_path
    if ".ini" in config_path:
        config = configparser.ConfigParser()
        config.read(config_path)
    elif ".json" in config_path:
        with open(config_path, "r") as f:
            config = json.load(f)
    else:
        raise NotImplementedError("No implement read")
    return config
